/*
 * Decompiled with CFR 0.152.
 */
package nxt.tools;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.tools.DiagnosticCollector;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import nxt.util.security.BlockchainPermission;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class JDKToolsWrapper {
    private static final Pattern JAVAC_8_CLASS_COMPILATION_EVENT = Pattern.compile("^\\[wrote RegularFileObject\\[(.*)]]");
    private static final Pattern JAVAC_10_CLASS_COMPILATION_EVENT = Pattern.compile("^\\[wrote DirectoryFileObject\\[(.*):([^\\\\].*)]]");
    private static final Pattern JAVAC_11_CLASS_COMPILATION_EVENT = Pattern.compile("^\\[wrote (.*)]");

    public static void main(String[] stringArray) {
        CommandLine commandLine;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("tools"));
        }
        Options options = new Options();
        Arrays.stream(OPTION.values()).forEach(oPTION -> options.addOption(new Option(oPTION.getOpt(), oPTION.getLongOpt(), oPTION.hasArgs(), oPTION.getDescription())));
        DefaultParser defaultParser = new DefaultParser();
        HelpFormatter helpFormatter = new HelpFormatter();
        try {
            commandLine = defaultParser.parse(options, stringArray);
        }
        catch (ParseException parseException) {
            System.out.println(parseException.getMessage());
            helpFormatter.printHelp(JDKToolsWrapper.class.getName(), options);
            return;
        }
        if (!commandLine.hasOption(OPTION.SOURCE.longOpt)) {
            helpFormatter.printHelp(JDKToolsWrapper.class.getName(), options);
            return;
        }
        String string2 = System.getProperty("java.io.tmpdir");
        Path path = Paths.get(string2, "src");
        Map<String, byte[]> map = JDKToolsWrapper.compile(commandLine.getOptionValue(OPTION.SOURCE.longOpt), commandLine.getOptionValue(OPTION.JAVAC.longOpt), path);
        if (map == null) {
            System.out.println("No classes compiled");
            return;
        }
        map.keySet().forEach(string -> System.out.printf("Class %s bytes size %d", string, map.getOrDefault(string, new byte[0]).length));
    }

    static Map<String, byte[]> compile(String string, String string2, Path path) {
        List<String> list;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("tools"));
        }
        System.out.printf("Compiling source file %s with compiler options %s\n", string, string2);
        JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
        if (javaCompiler == null) {
            System.out.println("Java compiler is not supported when running JRE use JDK instead");
            return null;
        }
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectory(path, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        StandardJavaFileManager standardJavaFileManager = javaCompiler.getStandardFileManager(diagnosticCollector, null, Charset.forName("UTF8"));
        try {
            standardJavaFileManager.setLocation(StandardLocation.CLASS_OUTPUT, Collections.singletonList(path.toFile()));
        }
        catch (IOException iOException) {
            throw new IllegalStateException();
        }
        File file = Paths.get(string, new String[0]).toFile();
        Iterable<? extends JavaFileObject> iterable = standardJavaFileManager.getJavaFileObjectsFromFiles(Collections.singletonList(file));
        StringWriter stringWriter = new StringWriter();
        List<String> list2 = Arrays.asList("-encoding", "utf8", "-verbose");
        if (string2 == null || string2.equals("")) {
            list = list2;
        } else {
            list = Arrays.asList(string2.split(" "));
            list = Stream.concat(list.stream(), list2.stream()).collect(Collectors.toList());
        }
        JavaCompiler.CompilationTask compilationTask = javaCompiler.getTask(stringWriter, standardJavaFileManager, diagnosticCollector, list, null, iterable);
        Boolean bl = compilationTask.call();
        System.out.println("Compilation Succeeded: " + bl);
        List list3 = diagnosticCollector.getDiagnostics();
        String string3 = list3.stream().map(Object::toString).collect(Collectors.joining("\n"));
        System.out.println("Compilation messages: " + string3);
        System.out.println("Output: " + stringWriter.toString());
        if (!bl.booleanValue()) {
            return null;
        }
        String string4 = stringWriter.toString();
        String[] stringArray = string4.split("\r\n");
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        for (String string5 : stringArray) {
            Path path2;
            Object object;
            Matcher matcher = JAVAC_10_CLASS_COMPILATION_EVENT.matcher(string5);
            if (matcher.matches() && matcher.groupCount() == 2) {
                object = matcher.group(1);
                String string6 = matcher.group(2);
                path2 = Paths.get((String)object, string6);
            } else {
                matcher = JAVAC_8_CLASS_COMPILATION_EVENT.matcher(string5);
                if (matcher.matches() && matcher.groupCount() == 1) {
                    object = matcher.group(1);
                    path2 = Paths.get((String)object, new String[0]);
                } else {
                    matcher = JAVAC_11_CLASS_COMPILATION_EVENT.matcher(string5);
                    if (!matcher.matches() || matcher.groupCount() != 1) continue;
                    object = matcher.group(1);
                    path2 = Paths.get((String)object, new String[0]);
                }
            }
            try {
                object = Files.readAllBytes(path2);
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
            hashMap.put(path2.toAbsolutePath().toString(), (byte[])object);
        }
        return hashMap;
    }

    static String javap(byte[] byArray) {
        int n;
        boolean bl;
        Object object;
        Object object2;
        List<String> list;
        Object object3;
        Object object4;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("tools"));
        }
        String string2 = System.getProperty("java.io.tmpdir");
        Path path = Paths.get(string2, "javapdata");
        Path path2 = path.resolve("Temp.class");
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectory(path, new FileAttribute[0]);
                Files.write(path2, byArray, new OpenOption[0]);
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        try {
            object4 = Class.forName("com.sun.tools.javap.JavapFileManager");
            object3 = ((Class)object4).getMethod("create", DiagnosticListener.class, PrintWriter.class);
            list = (JavaFileManager)((Method)object3).invoke(null, diagnosticCollector, printWriter);
            Class<?> clazz = Class.forName("com.sun.tools.javap.JavapTask");
            object2 = clazz.getConstructor(Writer.class, JavaFileManager.class, DiagnosticListener.class, Iterable.class, Iterable.class);
            object = ((Constructor)object2).newInstance(printWriter, list, diagnosticCollector, Collections.singletonList("-v"), Collections.singletonList(path2.toString()));
            Method method = clazz.getMethod("call", new Class[0]);
            bl = (Boolean)method.invoke(object, new Object[0]);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ClassNotFoundException) {
                System.out.println("Javap tool is not supported when running JRE use JDK instead");
                return null;
            }
            throw new IllegalStateException(throwable);
        }
        object4 = diagnosticCollector.getDiagnostics();
        object3 = object4.stream().map(Object::toString).collect(Collectors.joining("\n"));
        System.out.println("Javap messages: " + (String)object3);
        System.out.println("Javap Output: " + stringWriter.toString());
        if (!bl) {
            System.out.println("Javap failed");
            return null;
        }
        list = Arrays.asList(stringWriter.toString().split("\\r?\\n"));
        int n2 = list.stream().filter(string -> string.contains("major version:")).mapToInt(string -> Integer.parseInt(string.split(": ")[1]) - 44).findFirst().orElse(-1);
        if (n2 != (n = Integer.parseInt((String)(((?)(object = ((String)(object2 = System.getProperty("java.version"))).split("\\."))).length == 0 ? object2 : (((String)object[0]).equals("1") ? object[1] : object[0]))))) {
            System.out.printf("Contract was compiled with Java %d, you are using Java %d, re-run the verification with Java JDK version %d\n", n2, n, n2);
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DEBUG_INFO dEBUG_INFO : DEBUG_INFO.values()) {
            if (!list.stream().anyMatch(string -> string.contains(dEBUG_INFO.getIdentifier()))) continue;
            arrayList.add(dEBUG_INFO.toString().toLowerCase());
        }
        if (arrayList.size() == 0) {
            return "-g:none";
        }
        if (arrayList.size() == 2 && arrayList.contains(DEBUG_INFO.SOURCE.toString().toLowerCase()) && arrayList.contains(DEBUG_INFO.LINES.toString().toLowerCase())) {
            return "";
        }
        if (arrayList.size() == 3) {
            return "-g";
        }
        return "-g:" + String.join((CharSequence)",", arrayList);
    }

    static enum DEBUG_INFO {
        SOURCE("Compiled from \""),
        LINES("LineNumberTable:"),
        VARS("LocalVariableTable:");

        private String identifier;

        private DEBUG_INFO(String string2) {
            this.identifier = string2;
        }

        public String getIdentifier() {
            return this.identifier;
        }
    }

    static enum OPTION {
        SOURCE('s', "source", true, "path to source code file to verify"),
        JAVAC('j', "javac", true, "javac options (space separated, surround with quotes)");

        private final char opt;
        private final String longOpt;
        private boolean hasArgs;
        private String description;

        private OPTION(char c, String string2, boolean bl, String string3) {
            this.opt = c;
            this.longOpt = string2;
            this.hasArgs = bl;
            this.description = string3;
        }

        public String getOpt() {
            return Character.toString(this.opt);
        }

        public String getLongOpt() {
            return this.longOpt;
        }

        public boolean hasArgs() {
            return this.hasArgs;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

