/*
 * Decompiled with CFR 0.152.
 */
package nxt.util;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class MemoryHandler
extends Handler {
    private static final int DEFAULT_SIZE = 100;
    private static final int OFF_VALUE = Level.OFF.intValue();
    private final LogRecord[] buffer;
    private int start = 0;
    private int count = 0;
    private Level level;

    public MemoryHandler() {
        int n;
        String string;
        LogManager logManager = LogManager.getLogManager();
        String string2 = this.getClass().getName();
        try {
            string = logManager.getProperty(string2 + ".size");
            n = string != null ? Math.max(Integer.valueOf(string.trim()), 10) : 100;
        }
        catch (NumberFormatException numberFormatException) {
            n = 100;
        }
        this.buffer = new LogRecord[n];
        try {
            string = logManager.getProperty(string2 + ".level");
            this.level = string != null ? Level.parse(string.trim()) : Level.ALL;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.level = Level.ALL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void publish(LogRecord logRecord) {
        if (logRecord == null || logRecord.getLevel().intValue() < this.level.intValue() || this.level.intValue() == OFF_VALUE) return;
        LogRecord[] logRecordArray = this.buffer;
        synchronized (this.buffer) {
            int n = (this.start + this.count) % this.buffer.length;
            this.buffer[n] = logRecord;
            if (this.count < this.buffer.length) {
                ++this.count;
            } else {
                ++this.start;
                this.start %= this.buffer.length;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getMessages(int n) {
        ArrayList<String> arrayList = new ArrayList<String>(this.buffer.length);
        LogRecord[] logRecordArray = this.buffer;
        synchronized (this.buffer) {
            int n2 = Math.min(n, this.count);
            int n3 = (this.start + (this.count - n2)) % this.buffer.length;
            Formatter formatter = this.getFormatter();
            for (int i = 0; i < n2; ++i) {
                arrayList.add(formatter.format(this.buffer[n3++]));
                if (n3 != this.buffer.length) continue;
                n3 = 0;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        LogRecord[] logRecordArray = this.buffer;
        synchronized (this.buffer) {
            this.start = 0;
            this.count = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void close() {
        this.level = Level.OFF;
    }
}

