/*
 * Decompiled with CFR 0.152.
 */
package nxt.util.security;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import nxt.Nxt;
import nxt.NxtException;
import nxt.util.security.BlockchainCertificate;

public class BlockchainCertificateFactorySpi
extends CertificateFactorySpi {
    @Override
    public Certificate engineGenerateCertificate(InputStream inputStream) throws CertificateException {
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.flush();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return new BlockchainCertificate(Nxt.newTransactionBuilder(byArray2, null).build());
        }
        catch (IOException | NxtException.NotValidException exception) {
            throw new CertificateException(exception);
        }
    }

    @Override
    public Collection<? extends Certificate> engineGenerateCertificates(InputStream inputStream) throws CertificateException {
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        arrayList.add(this.engineGenerateCertificate(inputStream));
        return arrayList;
    }

    @Override
    public CRL engineGenerateCRL(InputStream inputStream) {
        return null;
    }

    @Override
    public Collection<? extends CRL> engineGenerateCRLs(InputStream inputStream) {
        return Collections.EMPTY_LIST;
    }
}

