/*
 * Decompiled with CFR 0.152.
 */
package nxt.util.security;

import java.security.AccessController;
import java.security.Provider;
import nxt.util.security.BlockchainPermission;

public class BlockchainSecurityProvider
extends Provider {
    public BlockchainSecurityProvider() {
        super("Jelurida", 1.0, "Jelurida Security Provider, bridging the gap between Java security and the blockchain");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("securityProvider"));
        }
        AccessController.doPrivileged(() -> {
            this.put("CertificateFactory.Blockchain", "nxt.util.security.BlockchainCertificateFactorySpi");
            this.put("CertPathBuilder.Blockchain", "nxt.util.security.BlockchainCertPathBuilderSpi");
            this.put("KeyStore.Blockchain", "nxt.util.security.BlockchainKeyStoreSpi");
            return null;
        });
    }
}

