/*
 * Decompiled with CFR 0.152.
 */
package nxt.voting;

import java.nio.ByteBuffer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import nxt.Nxt;
import nxt.NxtException;
import nxt.account.Account;
import nxt.ae.Asset;
import nxt.blockchain.Chain;
import nxt.blockchain.ChainTransactionId;
import nxt.blockchain.ChildTransaction;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionImpl;
import nxt.db.DbUtils;
import nxt.ms.Currency;
import nxt.util.BooleanExpression;
import nxt.util.Convert;
import nxt.util.JSON;
import nxt.util.bbh.LengthRwPrimitiveType;
import nxt.util.bbh.StringRw;
import nxt.voting.PhasingPollHome;
import nxt.voting.VoteWeighting;
import org.json.simple.JSONArray;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;

public class PhasingParams {
    public static final String COMMON_COLUMN_NAMES = "voting_model, quorum, min_balance, holding_id, min_balance_model, sender_property_setter_id, sender_property_name, sender_property_value, recipient_property_setter_id, recipient_property_name, recipient_property_value";
    public static final String COMMON_COLUMN_PARAMETER_MARKERS = "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?";
    private final long quorum;
    private final VoteWeighting voteWeighting;
    private long[] whitelist;
    private Supplier<long[]> whitelistSupplier = null;
    private List<ChainTransactionId> linkedTransactionsIds;
    private Supplier<List<ChainTransactionId>> linkedTransactionsSupplier = null;
    private final HashVoting hashVoting;
    private final CompositeVoting compositeVoting;
    private final PropertyVoting senderPropertyVoting;
    private final PropertyVoting recipientPropertyVoting;

    public PhasingParams(ByteBuffer byteBuffer) throws NxtException.NotValidException {
        byte by = byteBuffer.get();
        this.quorum = byteBuffer.getLong();
        long l = byteBuffer.getLong();
        int n = byteBuffer.get();
        if (n > 0) {
            this.whitelist = new long[n];
            for (int i = 0; i < n; ++i) {
                this.whitelist[i] = byteBuffer.getLong();
            }
        } else {
            this.whitelist = Convert.EMPTY_LONG;
        }
        long l2 = byteBuffer.getLong();
        byte by2 = byteBuffer.get();
        this.voteWeighting = new VoteWeighting(by, l2, l, by2);
        int n2 = 0;
        if (this.voteWeighting.getVotingModel() == VoteWeighting.VotingModel.TRANSACTION) {
            n2 = byteBuffer.get();
        }
        if (n2 > 0) {
            this.linkedTransactionsIds = new ArrayList<ChainTransactionId>(n2);
            for (int i = 0; i < n2; ++i) {
                this.linkedTransactionsIds.add(ChainTransactionId.parse(byteBuffer));
            }
        } else {
            this.linkedTransactionsIds = Collections.emptyList();
        }
        this.hashVoting = this.voteWeighting.getVotingModel() == VoteWeighting.VotingModel.HASH ? new HashVoting(byteBuffer) : new HashVoting(Convert.EMPTY_BYTE, 0);
        this.compositeVoting = this.voteWeighting.getVotingModel() == VoteWeighting.VotingModel.COMPOSITE ? new CompositeVoting(byteBuffer) : CompositeVoting.EMPTY;
        if (this.voteWeighting.getVotingModel() == VoteWeighting.VotingModel.PROPERTY) {
            this.senderPropertyVoting = new PropertyVoting(byteBuffer);
            this.recipientPropertyVoting = new PropertyVoting(byteBuffer);
        } else {
            this.senderPropertyVoting = PropertyVoting.EMPTY;
            this.recipientPropertyVoting = PropertyVoting.EMPTY;
        }
    }

    public PhasingParams(JSONObject jSONObject) {
        int n;
        this.quorum = Convert.parseLong(jSONObject.get((Object)"phasingQuorum"));
        long l = Convert.parseLong(jSONObject.get((Object)"phasingMinBalance"));
        byte by = ((Long)jSONObject.get((Object)"phasingVotingModel")).byteValue();
        long l2 = Convert.parseUnsignedLong((String)jSONObject.get((Object)"phasingHolding"));
        JSONArray jSONArray = (JSONArray)jSONObject.get((Object)"phasingWhitelist");
        if (jSONArray != null && jSONArray.size() > 0) {
            this.whitelist = new long[jSONArray.size()];
            for (n = 0; n < this.whitelist.length; ++n) {
                this.whitelist[n] = Convert.parseUnsignedLong((String)jSONArray.get(n));
            }
        } else {
            this.whitelist = Convert.EMPTY_LONG;
        }
        n = ((Long)jSONObject.get((Object)"phasingMinBalanceModel")).byteValue();
        this.voteWeighting = new VoteWeighting(by, l2, l, (byte)n);
        JSONArray jSONArray2 = (JSONArray)jSONObject.get((Object)"phasingLinkedTransactions");
        if (jSONArray2 != null && jSONArray2.size() > 0) {
            this.linkedTransactionsIds = new ArrayList<ChainTransactionId>(jSONArray2.size());
            jSONArray2.forEach(object -> this.linkedTransactionsIds.add(ChainTransactionId.parse((JSONObject)object)));
        } else {
            this.linkedTransactionsIds = Collections.emptyList();
        }
        this.hashVoting = new HashVoting(jSONObject);
        this.compositeVoting = this.voteWeighting.getVotingModel() == VoteWeighting.VotingModel.COMPOSITE ? new CompositeVoting(jSONObject) : CompositeVoting.EMPTY;
        boolean bl = this.voteWeighting.getVotingModel() == VoteWeighting.VotingModel.PROPERTY;
        Object object2 = jSONObject.get((Object)"phasingSenderProperty");
        this.senderPropertyVoting = bl && object2 != null ? new PropertyVoting((JSONObject)object2) : PropertyVoting.EMPTY;
        Object object3 = jSONObject.get((Object)"phasingRecipientProperty");
        this.recipientPropertyVoting = bl && object3 != null ? new PropertyVoting((JSONObject)object3) : PropertyVoting.EMPTY;
    }

    public PhasingParams(VoteWeighting voteWeighting, long l, long[] lArray, List<ChainTransactionId> list, HashVoting hashVoting, CompositeVoting compositeVoting, PropertyVoting propertyVoting, PropertyVoting propertyVoting2) {
        this(voteWeighting, l, hashVoting, compositeVoting, propertyVoting, propertyVoting2);
        if (lArray != null && lArray.length > 0) {
            Arrays.sort(lArray);
        }
        this.setWhitelist(lArray);
        if (list != null && !list.isEmpty()) {
            Collections.sort(list);
        }
        this.setLinkedTransactions(list);
    }

    public PhasingParams(VoteWeighting voteWeighting, long l, Supplier<long[]> supplier, Supplier<List<ChainTransactionId>> supplier2, HashVoting hashVoting, CompositeVoting compositeVoting, PropertyVoting propertyVoting, PropertyVoting propertyVoting2) {
        this(voteWeighting, l, hashVoting, compositeVoting, propertyVoting, propertyVoting2);
        this.whitelistSupplier = supplier;
        if (supplier == null) {
            this.whitelist = Convert.EMPTY_LONG;
        }
        this.linkedTransactionsSupplier = supplier2;
        if (supplier2 == null) {
            this.linkedTransactionsIds = Collections.emptyList();
        }
    }

    private PhasingParams(VoteWeighting voteWeighting, long l, HashVoting hashVoting, CompositeVoting compositeVoting, PropertyVoting propertyVoting, PropertyVoting propertyVoting2) {
        this.quorum = l;
        this.voteWeighting = voteWeighting;
        this.hashVoting = hashVoting != null ? hashVoting : new HashVoting(Convert.EMPTY_BYTE, 0);
        this.compositeVoting = compositeVoting != null ? compositeVoting : CompositeVoting.EMPTY;
        this.senderPropertyVoting = propertyVoting != null ? propertyVoting : PropertyVoting.EMPTY;
        this.recipientPropertyVoting = propertyVoting2 != null ? propertyVoting2 : PropertyVoting.EMPTY;
    }

    public int getMySize() {
        int n = 18 + 8 * this.getWhitelist().length + 8 + 1;
        if (this.voteWeighting.getVotingModel() == VoteWeighting.VotingModel.TRANSACTION) {
            n += 1 + 36 * this.getLinkedTransactionsIds().size();
        }
        if (this.voteWeighting.getVotingModel() == VoteWeighting.VotingModel.HASH) {
            n += this.hashVoting.getMySize();
        }
        if (this.voteWeighting.getVotingModel() == VoteWeighting.VotingModel.COMPOSITE) {
            n += this.compositeVoting.getMySize();
        }
        if (this.voteWeighting.getVotingModel() == VoteWeighting.VotingModel.PROPERTY) {
            n += this.senderPropertyVoting.getMySize();
            n += this.recipientPropertyVoting.getMySize();
        }
        return n;
    }

    public void putMyBytes(ByteBuffer byteBuffer) {
        byteBuffer.put(this.voteWeighting.getVotingModel().getCode());
        byteBuffer.putLong(this.quorum);
        byteBuffer.putLong(this.voteWeighting.getMinBalance());
        long[] lArray = this.getWhitelist();
        byteBuffer.put((byte)lArray.length);
        for (long l : lArray) {
            byteBuffer.putLong(l);
        }
        byteBuffer.putLong(this.voteWeighting.getHoldingId());
        byteBuffer.put(this.voteWeighting.getMinBalanceModel().getCode());
        if (this.voteWeighting.getVotingModel() == VoteWeighting.VotingModel.TRANSACTION) {
            Object object = this.getLinkedTransactionsIds();
            byteBuffer.put((byte)object.size());
            object.forEach(chainTransactionId -> chainTransactionId.put(byteBuffer));
        }
        if (this.voteWeighting.getVotingModel() == VoteWeighting.VotingModel.HASH) {
            this.hashVoting.putMyBytes(byteBuffer);
        }
        if (this.voteWeighting.getVotingModel() == VoteWeighting.VotingModel.COMPOSITE) {
            this.compositeVoting.putMyBytes(byteBuffer);
        }
        if (this.voteWeighting.getVotingModel() == VoteWeighting.VotingModel.PROPERTY) {
            this.senderPropertyVoting.putMyBytes(byteBuffer);
            this.recipientPropertyVoting.putMyBytes(byteBuffer);
        }
    }

    public void putMyJSON(JSONObject jSONObject) {
        JSONArray jSONArray;
        jSONObject.put((Object)"phasingQuorum", (Object)String.valueOf(this.quorum));
        jSONObject.put((Object)"phasingMinBalance", (Object)String.valueOf(this.voteWeighting.getMinBalance()));
        jSONObject.put((Object)"phasingVotingModel", (Object)this.voteWeighting.getVotingModel().getCode());
        jSONObject.put((Object)"phasingHolding", (Object)Long.toUnsignedString(this.voteWeighting.getHoldingId()));
        jSONObject.put((Object)"phasingMinBalanceModel", (Object)this.voteWeighting.getMinBalanceModel().getCode());
        long[] lArray = this.getWhitelist();
        if (lArray.length > 0) {
            jSONArray = new JSONArray();
            for (long l : lArray) {
                jSONArray.add((Object)Long.toUnsignedString(l));
            }
            jSONObject.put((Object)"phasingWhitelist", (Object)jSONArray);
        }
        if ((jSONArray = this.getLinkedTransactionsIds()).size() > 0) {
            JSONArray jSONArray2 = new JSONArray();
            jSONArray.forEach(chainTransactionId -> jSONArray2.add((Object)chainTransactionId.getJSON()));
            jSONObject.put((Object)"phasingLinkedTransactions", (Object)jSONArray2);
        }
        this.hashVoting.putMyJSON(jSONObject);
        this.compositeVoting.putMyJSON(jSONObject);
        if (this.senderPropertyVoting.getSetterId() != 0L) {
            JSONObject jSONObject2 = new JSONObject();
            this.senderPropertyVoting.putMyJSON(jSONObject2);
            jSONObject.put((Object)"phasingSenderProperty", (Object)jSONObject2);
        }
        if (this.recipientPropertyVoting.getSetterId() != 0L) {
            JSONObject jSONObject3 = new JSONObject();
            this.recipientPropertyVoting.putMyJSON(jSONObject3);
            jSONObject.put((Object)"phasingRecipientProperty", (Object)jSONObject3);
        }
    }

    public void validateRestrictableParams() throws NxtException.ValidationException {
        this.validateRestrictableParams(false);
    }

    private void validateRestrictableParams(boolean bl) throws NxtException.ValidationException {
        Object object;
        long[] lArray = this.getWhitelist();
        if (lArray.length > 10) {
            throw new NxtException.NotValidException("Whitelist is too big");
        }
        long l = 0L;
        for (long l2 : lArray) {
            if (l != 0L && l2 < l) {
                throw new NxtException.NotValidException("Whitelist not sorted " + Arrays.toString(lArray));
            }
            if (l2 == l) {
                throw new NxtException.NotValidException("Duplicate accountId " + Long.toUnsignedString(l2) + " in whitelist");
            }
            l = l2;
        }
        if (this.quorum <= 0L && this.voteWeighting.getVotingModel() != VoteWeighting.VotingModel.NONE) {
            throw new NxtException.NotValidException("quorum <= 0");
        }
        if (this.voteWeighting.getVotingModel() == VoteWeighting.VotingModel.NONE) {
            if (this.quorum != 0L) {
                throw new NxtException.NotValidException("Quorum must be 0 for no-voting phased transaction");
            }
            if (lArray.length != 0) {
                throw new NxtException.NotValidException("No whitelist needed for no-voting phased transaction");
            }
        }
        if (this.voteWeighting.getVotingModel() == VoteWeighting.VotingModel.ACCOUNT && lArray.length > 0 && this.quorum > (long)lArray.length) {
            throw new NxtException.NotValidException("Quorum of " + this.quorum + " cannot be achieved in by-account voting with whitelist of length " + lArray.length);
        }
        this.voteWeighting.validate();
        if (this.voteWeighting.getVotingModel() == VoteWeighting.VotingModel.CURRENCY) {
            object = Currency.getCurrency(this.voteWeighting.getHoldingId());
            if (object == null) {
                throw new NxtException.NotCurrentlyValidException("Currency " + Long.toUnsignedString(this.voteWeighting.getHoldingId()) + " not found");
            }
            if (this.quorum > ((Currency)object).getMaxSupplyQNT()) {
                throw new NxtException.NotCurrentlyValidException("Quorum of " + this.quorum + " exceeds max currency supply " + ((Currency)object).getMaxSupplyQNT());
            }
            if (this.voteWeighting.getMinBalance() > ((Currency)object).getMaxSupplyQNT()) {
                throw new NxtException.NotCurrentlyValidException("MinBalance of " + this.voteWeighting.getMinBalance() + " exceeds max currency supply " + ((Currency)object).getMaxSupplyQNT());
            }
        } else if (this.voteWeighting.getVotingModel() == VoteWeighting.VotingModel.ASSET) {
            object = Asset.getAsset(this.voteWeighting.getHoldingId());
            if (this.quorum > ((Asset)object).getQuantityQNT()) {
                throw new NxtException.NotCurrentlyValidException("Quorum of " + this.quorum + " exceeds total asset quantity " + ((Asset)object).getQuantityQNT());
            }
            if (this.voteWeighting.getMinBalance() > ((Asset)object).getQuantityQNT()) {
                throw new NxtException.NotCurrentlyValidException("MinBalance of " + this.voteWeighting.getMinBalance() + " exceeds total asset quantity " + ((Asset)object).getQuantityQNT());
            }
        } else if (this.voteWeighting.getMinBalance() > 0L) {
            if (this.voteWeighting.getMinBalanceModel() == VoteWeighting.MinBalanceModel.ASSET) {
                object = Asset.getAsset(this.voteWeighting.getHoldingId());
                if (this.voteWeighting.getMinBalance() > ((Asset)object).getQuantityQNT()) {
                    throw new NxtException.NotCurrentlyValidException("MinBalance of " + this.voteWeighting.getMinBalance() + " exceeds total asset quantity " + ((Asset)object).getQuantityQNT());
                }
            } else if (this.voteWeighting.getMinBalanceModel() == VoteWeighting.MinBalanceModel.CURRENCY) {
                object = Currency.getCurrency(this.voteWeighting.getHoldingId());
                if (object == null) {
                    throw new NxtException.NotCurrentlyValidException("Currency " + Long.toUnsignedString(this.voteWeighting.getHoldingId()) + " not found");
                }
                if (this.voteWeighting.getMinBalance() > ((Currency)object).getMaxSupplyQNT()) {
                    throw new NxtException.NotCurrentlyValidException("MinBalance of " + this.voteWeighting.getMinBalance() + " exceeds max currency supply " + ((Currency)object).getMaxSupplyQNT());
                }
            }
        }
        if (this.voteWeighting.getVotingModel() == VoteWeighting.VotingModel.COMPOSITE) {
            if (bl) {
                throw new NxtException.NotValidException("Nested sub-polls are not allowed");
            }
            if (this.quorum != 1L) {
                throw new NxtException.NotValidException("Composite voting requires quorum 1");
            }
            if (lArray.length != 0) {
                throw new NxtException.NotValidException("No whitelist needed for composite voting");
            }
            if (this.getExpressionStr().isEmpty()) {
                throw new NxtException.NotValidException("Composite voting requires boolean expression");
            }
            if (!CompositeVoting.EXPRESSION_RW.validate(this.getExpressionStr())) {
                throw new NxtException.NotValidException("Invalid boolean expression size " + this.getExpressionStr());
            }
            if (this.getSubPolls().size() > 20) {
                throw new NxtException.NotValidException("Sub-polls count " + this.getSubPolls().size() + " exceeds the maximum of " + 20 + " variables");
            }
            object = this.getExpression();
            BooleanExpression.BadSyntaxException badSyntaxException = ((BooleanExpression)object).getSyntaxException();
            if (badSyntaxException != null) {
                throw new NxtException.NotValidException("Failed to parse boolean expression \"" + badSyntaxException.getMessage() + "\"", badSyntaxException);
            }
            if (((BooleanExpression)object).getVariables().size() > 20) {
                throw new NxtException.NotValidException("Variables count " + this.getSubPolls().size() + " exceeds the maximum of " + 20);
            }
            for (String string : ((BooleanExpression)object).getVariables()) {
                if (CompositeVoting.SUB_POLL_NAME_RW.validate(string)) continue;
                throw new NxtException.NotValidException("Invalid variable name size " + string);
            }
            int n = ((BooleanExpression)object).getLiteralsCount();
            if (n > 30) {
                throw new NxtException.NotValidException("Literals count " + n + "  exceeds the maximum of " + 30);
            }
            if (!((BooleanExpression)object).getVariables().equals(this.getSubPolls().keySet())) {
                throw new NxtException.NotValidException("The variables found in the boolean expression do not match the sub-polls names");
            }
            for (PhasingParams phasingParams : this.getSubPolls().values()) {
                phasingParams.validateRestrictableParams(true);
            }
        } else {
            if (!this.getExpressionStr().isEmpty()) {
                throw new NxtException.NotValidException("Boolean expression can only be used with VotingModel.COMPOSITE");
            }
            if (!this.getSubPolls().isEmpty()) {
                throw new NxtException.NotValidException("Sub-polls can only be used with VotingModel.COMPOSITE");
            }
        }
        if (this.voteWeighting.getVotingModel() == VoteWeighting.VotingModel.PROPERTY) {
            this.senderPropertyVoting.validate("Sender");
            this.recipientPropertyVoting.validate("Recipient");
            if (this.senderPropertyVoting.getSetterId() == 0L && this.recipientPropertyVoting.getSetterId() == 0L) {
                throw new NxtException.NotValidException("By-property voting requires property parameters for either sender or recipient, or both");
            }
        } else {
            this.senderPropertyVoting.validateEmpty("Sender");
            this.recipientPropertyVoting.validateEmpty("Recipient");
        }
    }

    void validate(Transaction transaction) throws NxtException.ValidationException {
        this.validateRestrictableParams();
        this.validateByTransactionAndHashParams(transaction);
    }

    private void validateByTransactionAndHashParams(Transaction transaction) throws NxtException.NotValidException, NxtException.NotCurrentlyValidException {
        Object object2;
        List<ChainTransactionId> list = this.getLinkedTransactionsIds();
        if (this.getVoteWeighting().getVotingModel() == VoteWeighting.VotingModel.TRANSACTION) {
            if (list.size() == 0 || list.size() > 10) {
                throw new NxtException.NotValidException("Invalid number of linkedFullHashes " + list.size());
            }
            object2 = null;
            for (ChainTransactionId object3 : list) {
                Object object = object3.getFullHash();
                if (Convert.emptyToNull(object) == null || ((byte[])object).length != 32) {
                    throw new NxtException.NotValidException("Invalid linkedFullHash " + Convert.toHexString(object));
                }
                if (object2 != null && object2.compareTo(object3) >= 0) {
                    throw new NxtException.NotValidException("Linked transaction ids not sorted or contain duplicates");
                }
                object2 = object3;
                Chain chain = object3.getChain();
                if (chain == null) {
                    throw new NxtException.NotValidException("Invalid chain id " + object3.getChainId());
                }
                TransactionImpl transactionImpl = chain.getTransactionHome().findTransaction((byte[])object, Nxt.getBlockchain().getHeight());
                if (transactionImpl == null) continue;
                if (transaction.getTimestamp() - transactionImpl.getTimestamp() > 5184000) {
                    throw new NxtException.NotValidException("Linked transaction cannot be more than 60 days older than the phased transaction");
                }
                if (!(transactionImpl instanceof ChildTransaction) || ((ChildTransaction)((Object)transactionImpl)).getPhasing() == null) continue;
                throw new NxtException.NotCurrentlyValidException("Cannot link to an already existing phased transaction");
            }
            if (this.getQuorum() > (long)list.size()) {
                throw new NxtException.NotValidException("Quorum of " + this.getQuorum() + " cannot be achieved in by-transaction voting with " + list.size() + " linked full hashes only");
            }
        } else if (list.size() != 0) {
            throw new NxtException.NotValidException("LinkedFullHashes can only be used with VotingModel.TRANSACTION");
        }
        object2 = this.getHashedSecret();
        byte by = this.getAlgorithm();
        if (this.getVoteWeighting().getVotingModel() == VoteWeighting.VotingModel.HASH) {
            if (this.getQuorum() != 1L) {
                throw new NxtException.NotValidException("Quorum must be 1 for by-hash voting");
            }
            if (((byte[])object2).length == 0 || ((byte[])object2).length > 127) {
                throw new NxtException.NotValidException("Invalid hashedSecret " + Convert.toHexString(object2));
            }
            if (PhasingPollHome.getHashFunction(by) == null) {
                throw new NxtException.NotValidException("Invalid hashedSecretAlgorithm " + by);
            }
        } else {
            if (((byte[])object2).length != 0) {
                throw new NxtException.NotValidException("HashedSecret can only be used with VotingModel.HASH");
            }
            if (by != 0) {
                throw new NxtException.NotValidException("HashedSecretAlgorithm can only be used with VotingModel.HASH");
            }
        }
        if (this.voteWeighting.getVotingModel() == VoteWeighting.VotingModel.COMPOSITE) {
            for (Object object : this.getSubPolls().values()) {
                super.validateByTransactionAndHashParams(transaction);
            }
        }
    }

    public void checkApprovable() throws NxtException.NotCurrentlyValidException {
        if (this.voteWeighting.getVotingModel() == VoteWeighting.VotingModel.CURRENCY && Currency.getCurrency(this.voteWeighting.getHoldingId()) == null) {
            throw new NxtException.NotCurrentlyValidException("Currency " + Long.toUnsignedString(this.voteWeighting.getHoldingId()) + " not found");
        }
        if (this.voteWeighting.getMinBalance() > 0L && this.voteWeighting.getMinBalanceModel() == VoteWeighting.MinBalanceModel.CURRENCY && Currency.getCurrency(this.voteWeighting.getHoldingId()) == null) {
            throw new NxtException.NotCurrentlyValidException("Currency " + Long.toUnsignedString(this.voteWeighting.getHoldingId()) + " not found");
        }
        for (PhasingParams phasingParams : this.getSubPolls().values()) {
            phasingParams.checkApprovable();
        }
    }

    public boolean isAccountWhitelisted(long l) {
        if (this.voteWeighting.getVotingModel() == VoteWeighting.VotingModel.COMPOSITE) {
            return this.getSubPolls().values().stream().anyMatch(phasingParams -> phasingParams.isAccountWhitelisted(l));
        }
        long[] lArray = this.getWhitelist();
        return lArray.length == 0 || Arrays.binarySearch(lArray, l) >= 0;
    }

    public boolean acceptsVotes() {
        if (this.voteWeighting.getVotingModel() == VoteWeighting.VotingModel.COMPOSITE) {
            return this.getSubPolls().values().stream().anyMatch(PhasingParams::acceptsVotes);
        }
        return this.voteWeighting.acceptsVotes();
    }

    public long getQuorum() {
        return this.quorum;
    }

    public long[] getWhitelist() {
        if (this.whitelist == null) {
            this.setWhitelist(this.whitelistSupplier.get());
        }
        return this.whitelist;
    }

    private void setWhitelist(long[] lArray) {
        this.whitelist = Convert.nullToEmpty(lArray);
    }

    public VoteWeighting getVoteWeighting() {
        return this.voteWeighting;
    }

    public List<ChainTransactionId> getLinkedTransactionsIds() {
        if (this.linkedTransactionsIds == null) {
            this.setLinkedTransactions(this.linkedTransactionsSupplier.get());
        }
        return this.linkedTransactionsIds;
    }

    private void setLinkedTransactions(List<ChainTransactionId> list) {
        this.linkedTransactionsIds = list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
    }

    public byte[] getHashedSecret() {
        return this.hashVoting.hashedSecret;
    }

    public byte getAlgorithm() {
        return this.hashVoting.algorithm;
    }

    public String getExpressionStr() {
        return this.compositeVoting.expressionStr;
    }

    public BooleanExpression getExpression() {
        return this.compositeVoting.expression;
    }

    public SortedMap<String, PhasingParams> getSubPolls() {
        return this.compositeVoting.subPolls;
    }

    public PropertyVoting getSenderPropertyVoting() {
        return this.senderPropertyVoting;
    }

    public PropertyVoting getRecipientPropertyVoting() {
        return this.recipientPropertyVoting;
    }

    public HashVoting getHashVoting() {
        return this.hashVoting;
    }

    public boolean allowEarlyFinish() {
        return PhasingParams.allowEarlyFinish(this, false);
    }

    public boolean allowFinishAtCreation() {
        return PhasingParams.allowEarlyFinish(this, true);
    }

    private static boolean allowEarlyFinish(PhasingParams phasingParams, boolean bl) {
        VoteWeighting voteWeighting = phasingParams.getVoteWeighting();
        VoteWeighting.VotingModel votingModel = voteWeighting.getVotingModel();
        if (votingModel == VoteWeighting.VotingModel.COMPOSITE) {
            Map<String, BooleanExpression.Value> map = phasingParams.getSubPolls().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> PhasingParams.allowEarlyFinish((PhasingParams)entry.getValue(), bl) ? BooleanExpression.Value.TRUE : BooleanExpression.Value.UNKNOWN));
            try {
                return phasingParams.getExpression().evaluate(map) != BooleanExpression.Value.UNKNOWN;
            }
            catch (BooleanExpression.BooleanExpressionException booleanExpressionException) {
                throw new RuntimeException("Invalid boolean expression while counting votes.", booleanExpressionException);
            }
        }
        if (bl) {
            return votingModel == VoteWeighting.VotingModel.PROPERTY;
        }
        return votingModel != VoteWeighting.VotingModel.NONE && voteWeighting.isBalanceIndependent() && (phasingParams.getWhitelist().length > 0 || votingModel != VoteWeighting.VotingModel.ACCOUNT);
    }

    public boolean equals(Object object) {
        if (!(object instanceof PhasingParams)) {
            return false;
        }
        PhasingParams phasingParams = (PhasingParams)object;
        return phasingParams.quorum == this.quorum && phasingParams.voteWeighting.equals(this.voteWeighting) && Arrays.equals(phasingParams.getWhitelist(), this.getWhitelist()) && phasingParams.getLinkedTransactionsIds().equals(this.getLinkedTransactionsIds()) && phasingParams.hashVoting.equals(this.hashVoting) && phasingParams.compositeVoting.equals(this.compositeVoting) && phasingParams.senderPropertyVoting.equals(this.senderPropertyVoting) && phasingParams.recipientPropertyVoting.equals(this.recipientPropertyVoting);
    }

    public int hashCode() {
        int n = 17;
        n = 31 * n + Long.hashCode(this.quorum);
        for (long l : this.getWhitelist()) {
            n = 31 * n + Long.hashCode(l);
        }
        n = 31 * n + this.voteWeighting.hashCode();
        Object object = this.getLinkedTransactionsIds().iterator();
        while (object.hasNext()) {
            ChainTransactionId chainTransactionId = (ChainTransactionId)object.next();
            n = 31 * n + chainTransactionId.hashCode();
        }
        n = 31 * n + this.hashVoting.hashCode();
        n = 31 * n + this.compositeVoting.hashCode();
        n = 31 * n + this.senderPropertyVoting.hashCode();
        n = 31 * n + this.recipientPropertyVoting.hashCode();
        return n;
    }

    public String toString() {
        JSONObject jSONObject = new JSONObject();
        this.putMyJSON(jSONObject);
        return JSON.toJSONString((JSONAware)jSONObject);
    }

    public static int setCommonColumnValues(PhasingParams phasingParams, PreparedStatement preparedStatement, int n) throws SQLException {
        VoteWeighting voteWeighting = phasingParams.getVoteWeighting();
        preparedStatement.setByte(++n, voteWeighting.getVotingModel().getCode());
        DbUtils.setLongZeroToNull(preparedStatement, ++n, phasingParams.getQuorum());
        DbUtils.setLongZeroToNull(preparedStatement, ++n, voteWeighting.getMinBalance());
        DbUtils.setLongZeroToNull(preparedStatement, ++n, voteWeighting.getHoldingId());
        preparedStatement.setByte(++n, voteWeighting.getMinBalanceModel().getCode());
        n = phasingParams.senderPropertyVoting.save(preparedStatement, n);
        n = phasingParams.recipientPropertyVoting.save(preparedStatement, n);
        return n;
    }

    static long[] readWhitelist(ResultSet resultSet) throws SQLException {
        Long[] longArray = (Long[])DbUtils.getArray(resultSet, "whitelist", Long[].class);
        return longArray == null ? null : Convert.toArray(longArray);
    }

    static PropertyVoting readPropertyVoting(ResultSet resultSet, String string, VoteWeighting voteWeighting) throws SQLException {
        PropertyVoting propertyVoting = null;
        if (voteWeighting.getVotingModel() == VoteWeighting.VotingModel.PROPERTY) {
            propertyVoting = new PropertyVoting(resultSet.getLong(string + "property_setter_id"), resultSet.getString(string + "property_name"), resultSet.getString(string + "property_value"));
        }
        return propertyVoting;
    }

    public static class PropertyVoting {
        public static final PropertyVoting EMPTY = new PropertyVoting(0L, "", "");
        private final long propertySetterId;
        private final String propertyName;
        private final String propertyValue;

        private PropertyVoting(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            this.propertySetterId = byteBuffer.getLong();
            this.propertyName = Account.PROPERTY_NAME_RW.readFromBuffer(byteBuffer);
            this.propertyValue = Account.PROPERTY_VALUE_RW.readFromBuffer(byteBuffer);
        }

        private PropertyVoting(JSONObject jSONObject) {
            this.propertySetterId = Convert.parseUnsignedLong((String)jSONObject.get((Object)"setter"));
            this.propertyName = Convert.nullToEmpty((String)jSONObject.get((Object)"name"));
            this.propertyValue = Convert.nullToEmpty((String)jSONObject.get((Object)"value"));
        }

        public PropertyVoting(long l, String string, String string2) {
            this.propertySetterId = l;
            this.propertyName = Convert.nullToEmpty(string);
            this.propertyValue = Convert.nullToEmpty(string2);
        }

        private int getMySize() {
            return 8 + Account.PROPERTY_NAME_RW.getSize(this.propertyName) + Account.PROPERTY_VALUE_RW.getSize(this.propertyValue);
        }

        private void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.putLong(this.propertySetterId);
            Account.PROPERTY_NAME_RW.writeToBuffer(this.propertyName, byteBuffer);
            Account.PROPERTY_VALUE_RW.writeToBuffer(this.propertyValue, byteBuffer);
        }

        private void putMyJSON(JSONObject jSONObject) {
            if (this.propertySetterId != 0L) {
                jSONObject.put((Object)"setter", (Object)Long.toUnsignedString(this.propertySetterId));
            }
            if (!this.propertyName.isEmpty()) {
                jSONObject.put((Object)"name", (Object)this.propertyName);
            }
            if (!this.propertyValue.isEmpty()) {
                jSONObject.put((Object)"value", (Object)this.propertyValue);
            }
        }

        private int save(PreparedStatement preparedStatement, int n) throws SQLException {
            preparedStatement.setLong(++n, this.propertySetterId);
            preparedStatement.setString(++n, this.propertyName);
            preparedStatement.setString(++n, this.propertyValue);
            return n;
        }

        private void validate(String string) throws NxtException.NotValidException {
            if (this.propertySetterId != 0L) {
                if (this.propertyName.isEmpty()) {
                    throw new NxtException.NotValidException(string + "PropertyName must not be empty");
                }
                if (!Account.PROPERTY_NAME_RW.validate(this.propertyName)) {
                    throw new NxtException.NotValidException("Invalid " + string + "PropertyName " + this.propertyName);
                }
                if (!Account.PROPERTY_VALUE_RW.validate(this.propertyValue)) {
                    throw new NxtException.NotValidException("Invalid " + string + "PropertyValue " + this.propertyValue);
                }
            }
        }

        private void validateEmpty(String string) throws NxtException.NotValidException {
            if (this.propertySetterId != 0L) {
                throw new NxtException.NotValidException(string + "PropertySetterId can only be used with VotingModel.PROPERTY");
            }
            if (!this.propertyName.isEmpty()) {
                throw new NxtException.NotValidException(string + "PropertyName can only be used with VotingModel.PROPERTY");
            }
            if (!this.propertyValue.isEmpty()) {
                throw new NxtException.NotValidException(string + "PropertyValue can only be used with VotingModel.PROPERTY");
            }
        }

        public long getSetterId() {
            return this.propertySetterId;
        }

        public String getName() {
            return this.propertyName;
        }

        public String getValue() {
            return this.propertyValue;
        }

        public boolean equals(Object object) {
            if (!(object instanceof PropertyVoting)) {
                return false;
            }
            PropertyVoting propertyVoting = (PropertyVoting)object;
            return propertyVoting.propertySetterId == this.propertySetterId && propertyVoting.propertyName.equals(this.propertyName) && propertyVoting.propertyValue.equals(this.propertyValue);
        }

        public int hashCode() {
            int n = 17;
            n = 31 * n + Long.hashCode(this.propertySetterId);
            n = 31 * n + this.propertyName.hashCode();
            n = 31 * n + this.propertyValue.hashCode();
            return n;
        }
    }

    public static class CompositeVoting {
        public static final CompositeVoting EMPTY = new CompositeVoting("", null);
        public static final StringRw EXPRESSION_RW = new StringRw(LengthRwPrimitiveType.SHORT, 1000);
        public static final StringRw SUB_POLL_NAME_RW = new StringRw(LengthRwPrimitiveType.BYTE, 10);
        private final String expressionStr;
        private final SortedMap<String, PhasingParams> subPolls;
        private final BooleanExpression expression;

        private CompositeVoting(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            this.expressionStr = EXPRESSION_RW.readFromBuffer(byteBuffer);
            this.expression = new BooleanExpression(this.expressionStr);
            int n = byteBuffer.get();
            if (n > 0) {
                TreeMap<String, PhasingParams> treeMap = new TreeMap<String, PhasingParams>();
                for (int i = 0; i < n; ++i) {
                    String string = SUB_POLL_NAME_RW.readFromBuffer(byteBuffer);
                    PhasingParams phasingParams = new PhasingParams(byteBuffer);
                    treeMap.put(string, phasingParams);
                }
                this.subPolls = Collections.unmodifiableSortedMap(treeMap);
            } else {
                this.subPolls = Collections.emptySortedMap();
            }
        }

        public CompositeVoting(String string, SortedMap<String, PhasingParams> sortedMap) {
            this.expressionStr = Convert.nullToEmpty(string);
            this.expression = new BooleanExpression(this.expressionStr);
            this.subPolls = sortedMap == null ? Collections.emptySortedMap() : Collections.unmodifiableSortedMap(sortedMap);
        }

        private CompositeVoting(JSONObject jSONObject) {
            this.expressionStr = Convert.nullToEmpty((String)jSONObject.get((Object)"phasingExpression"));
            this.expression = new BooleanExpression(this.expressionStr);
            Set<String> set = this.expression.getVariables();
            JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"phasingSubPolls");
            this.subPolls = new TreeMap<String, PhasingParams>();
            for (String string : set) {
                JSONObject jSONObject3 = (JSONObject)jSONObject2.get((Object)string);
                this.subPolls.put(string, new PhasingParams(jSONObject3));
            }
        }

        private int getMySize() {
            int n = EXPRESSION_RW.getSize(this.expressionStr);
            ++n;
            return n += this.subPolls.entrySet().stream().mapToInt(entry -> SUB_POLL_NAME_RW.getSize((String)entry.getKey()) + ((PhasingParams)entry.getValue()).getMySize()).sum();
        }

        private void putMyBytes(ByteBuffer byteBuffer) {
            EXPRESSION_RW.writeToBuffer(this.expressionStr, byteBuffer);
            byteBuffer.put((byte)this.subPolls.size());
            this.subPolls.forEach((string, phasingParams) -> {
                SUB_POLL_NAME_RW.writeToBuffer((String)string, byteBuffer);
                phasingParams.putMyBytes(byteBuffer);
            });
        }

        private void putMyJSON(JSONObject jSONObject) {
            if (!this.expressionStr.isEmpty()) {
                jSONObject.put((Object)"phasingExpression", (Object)this.expressionStr);
            }
            if (!this.subPolls.isEmpty()) {
                JSONObject jSONObject2 = new JSONObject();
                this.subPolls.forEach((string, phasingParams) -> {
                    JSONObject jSONObject2 = new JSONObject();
                    phasingParams.putMyJSON(jSONObject2);
                    jSONObject2.put(string, (Object)jSONObject2);
                });
                jSONObject.put((Object)"phasingSubPolls", (Object)jSONObject2);
            }
        }

        public boolean equals(Object object) {
            if (!(object instanceof CompositeVoting)) {
                return false;
            }
            CompositeVoting compositeVoting = (CompositeVoting)object;
            return compositeVoting.expressionStr.equals(this.expressionStr) && compositeVoting.subPolls.equals(this.subPolls);
        }

        public int hashCode() {
            return 31 * this.expressionStr.hashCode() + this.subPolls.hashCode();
        }
    }

    public static class HashVoting {
        private final byte[] hashedSecret;
        private final byte algorithm;

        private HashVoting(ByteBuffer byteBuffer) {
            byte by = byteBuffer.get();
            if (by > 0) {
                this.hashedSecret = new byte[by];
                byteBuffer.get(this.hashedSecret);
            } else {
                this.hashedSecret = Convert.EMPTY_BYTE;
            }
            this.algorithm = byteBuffer.get();
        }

        private HashVoting(JSONObject jSONObject) {
            String string = Convert.emptyToNull((String)jSONObject.get((Object)"phasingHashedSecret"));
            if (string != null) {
                this.hashedSecret = Convert.parseHexString(string);
                this.algorithm = ((Long)jSONObject.get((Object)"phasingHashedSecretAlgorithm")).byteValue();
            } else {
                this.hashedSecret = Convert.EMPTY_BYTE;
                this.algorithm = 0;
            }
        }

        public HashVoting(byte[] byArray, byte by) {
            this.hashedSecret = byArray != null ? byArray : Convert.EMPTY_BYTE;
            this.algorithm = by;
        }

        public byte[] getHashedSecret() {
            return this.hashedSecret;
        }

        public byte getAlgorithm() {
            return this.algorithm;
        }

        private int getMySize() {
            return 1 + this.hashedSecret.length + 1;
        }

        private void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.put((byte)this.hashedSecret.length);
            byteBuffer.put(this.hashedSecret);
            byteBuffer.put(this.algorithm);
        }

        private void putMyJSON(JSONObject jSONObject) {
            if (this.hashedSecret.length > 0) {
                jSONObject.put((Object)"phasingHashedSecret", (Object)Convert.toHexString(this.hashedSecret));
                jSONObject.put((Object)"phasingHashedSecretAlgorithm", (Object)this.algorithm);
            }
        }

        public boolean equals(Object object) {
            if (!(object instanceof HashVoting)) {
                return false;
            }
            HashVoting hashVoting = (HashVoting)object;
            return Arrays.equals(hashVoting.hashedSecret, this.hashedSecret) && hashVoting.algorithm == this.algorithm;
        }

        public int hashCode() {
            return 31 * Arrays.hashCode(this.hashedSecret) + this.algorithm;
        }
    }
}

