/*
 * Decompiled with CFR 0.152.
 */
package nxt.voting;

import java.nio.ByteBuffer;
import java.util.Collections;
import nxt.NxtException;
import nxt.blockchain.Attachment;
import nxt.blockchain.TransactionType;
import nxt.util.Convert;
import nxt.voting.VoteWeighting;
import nxt.voting.VotingTransactionType;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public final class PollCreationAttachment
extends Attachment.AbstractAttachment {
    private final String pollName;
    private final String pollDescription;
    private final String[] pollOptions;
    private final int finishHeight;
    private final byte minNumberOfOptions;
    private final byte maxNumberOfOptions;
    private final byte minRangeValue;
    private final byte maxRangeValue;
    private final VoteWeighting voteWeighting;

    public PollCreationAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
        super(byteBuffer);
        int n;
        this.pollName = Convert.readString(byteBuffer, byteBuffer.getShort(), 100);
        this.pollDescription = Convert.readString(byteBuffer, byteBuffer.getShort(), 1000);
        this.finishHeight = byteBuffer.getInt();
        int n2 = byteBuffer.get();
        if (n2 > 100) {
            throw new NxtException.NotValidException("Invalid number of poll options: " + n2);
        }
        this.pollOptions = new String[n2];
        for (n = 0; n < n2; ++n) {
            this.pollOptions[n] = Convert.readString(byteBuffer, byteBuffer.getShort(), 100);
        }
        n = byteBuffer.get();
        this.minNumberOfOptions = byteBuffer.get();
        this.maxNumberOfOptions = byteBuffer.get();
        this.minRangeValue = byteBuffer.get();
        this.maxRangeValue = byteBuffer.get();
        long l = byteBuffer.getLong();
        byte by = byteBuffer.get();
        long l2 = byteBuffer.getLong();
        this.voteWeighting = new VoteWeighting((byte)n, l2, l, by);
    }

    public PollCreationAttachment(JSONObject jSONObject) {
        super(jSONObject);
        byte by;
        this.pollName = ((String)jSONObject.get((Object)"name")).trim();
        this.pollDescription = ((String)jSONObject.get((Object)"description")).trim();
        this.finishHeight = ((Long)jSONObject.get((Object)"finishHeight")).intValue();
        JSONArray jSONArray = (JSONArray)jSONObject.get((Object)"options");
        this.pollOptions = new String[jSONArray.size()];
        for (by = 0; by < this.pollOptions.length; ++by) {
            this.pollOptions[by] = ((String)jSONArray.get((int)by)).trim();
        }
        by = ((Long)jSONObject.get((Object)"votingModel")).byteValue();
        this.minNumberOfOptions = ((Long)jSONObject.get((Object)"minNumberOfOptions")).byteValue();
        this.maxNumberOfOptions = ((Long)jSONObject.get((Object)"maxNumberOfOptions")).byteValue();
        this.minRangeValue = ((Long)jSONObject.get((Object)"minRangeValue")).byteValue();
        this.maxRangeValue = ((Long)jSONObject.get((Object)"maxRangeValue")).byteValue();
        long l = Convert.parseLong(jSONObject.get((Object)"minBalance"));
        byte by2 = ((Long)jSONObject.get((Object)"minBalanceModel")).byteValue();
        long l2 = Convert.parseUnsignedLong((String)jSONObject.get((Object)"holding"));
        this.voteWeighting = new VoteWeighting(by, l2, l, by2);
    }

    private PollCreationAttachment(PollBuilder pollBuilder) {
        this.pollName = pollBuilder.pollName;
        this.pollDescription = pollBuilder.pollDescription;
        this.pollOptions = pollBuilder.pollOptions;
        this.finishHeight = pollBuilder.finishHeight;
        this.minNumberOfOptions = pollBuilder.minNumberOfOptions;
        this.maxNumberOfOptions = pollBuilder.maxNumberOfOptions;
        this.minRangeValue = pollBuilder.minRangeValue;
        this.maxRangeValue = pollBuilder.maxRangeValue;
        this.voteWeighting = new VoteWeighting(pollBuilder.votingModel, pollBuilder.holdingId, pollBuilder.minBalance, pollBuilder.minBalanceModel);
    }

    @Override
    protected int getMySize() {
        int n = 2 + Convert.toBytes(this.pollName).length + 2 + Convert.toBytes(this.pollDescription).length + 1;
        for (String string : this.pollOptions) {
            n += 2 + Convert.toBytes(string).length;
        }
        return n += 26;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byte[] byArray = Convert.toBytes(this.pollName);
        byte[] byArray2 = Convert.toBytes(this.pollDescription);
        byte[][] byArrayArray = new byte[this.pollOptions.length][];
        for (int i = 0; i < this.pollOptions.length; ++i) {
            byArrayArray[i] = Convert.toBytes(this.pollOptions[i]);
        }
        byteBuffer.putShort((short)byArray.length);
        byteBuffer.put(byArray);
        byteBuffer.putShort((short)byArray2.length);
        byteBuffer.put(byArray2);
        byteBuffer.putInt(this.finishHeight);
        byteBuffer.put((byte)byArrayArray.length);
        for (byte[] byArray3 : byArrayArray) {
            byteBuffer.putShort((short)byArray3.length);
            byteBuffer.put(byArray3);
        }
        byteBuffer.put(this.voteWeighting.getVotingModel().getCode());
        byteBuffer.put(this.minNumberOfOptions);
        byteBuffer.put(this.maxNumberOfOptions);
        byteBuffer.put(this.minRangeValue);
        byteBuffer.put(this.maxRangeValue);
        byteBuffer.putLong(this.voteWeighting.getMinBalance());
        byteBuffer.put(this.voteWeighting.getMinBalanceModel().getCode());
        byteBuffer.putLong(this.voteWeighting.getHoldingId());
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"name", (Object)this.pollName);
        jSONObject.put((Object)"description", (Object)this.pollDescription);
        jSONObject.put((Object)"finishHeight", (Object)this.finishHeight);
        JSONArray jSONArray = new JSONArray();
        if (this.pollOptions != null) {
            Collections.addAll(jSONArray, this.pollOptions);
        }
        jSONObject.put((Object)"options", (Object)jSONArray);
        jSONObject.put((Object)"minNumberOfOptions", (Object)this.minNumberOfOptions);
        jSONObject.put((Object)"maxNumberOfOptions", (Object)this.maxNumberOfOptions);
        jSONObject.put((Object)"minRangeValue", (Object)this.minRangeValue);
        jSONObject.put((Object)"maxRangeValue", (Object)this.maxRangeValue);
        jSONObject.put((Object)"votingModel", (Object)this.voteWeighting.getVotingModel().getCode());
        jSONObject.put((Object)"minBalance", (Object)this.voteWeighting.getMinBalance());
        jSONObject.put((Object)"minBalanceModel", (Object)this.voteWeighting.getMinBalanceModel().getCode());
        jSONObject.put((Object)"holding", (Object)Long.toUnsignedString(this.voteWeighting.getHoldingId()));
    }

    @Override
    public TransactionType getTransactionType() {
        return VotingTransactionType.POLL_CREATION;
    }

    public String getPollName() {
        return this.pollName;
    }

    public String getPollDescription() {
        return this.pollDescription;
    }

    public int getFinishHeight() {
        return this.finishHeight;
    }

    public String[] getPollOptions() {
        return this.pollOptions;
    }

    public byte getMinNumberOfOptions() {
        return this.minNumberOfOptions;
    }

    public byte getMaxNumberOfOptions() {
        return this.maxNumberOfOptions;
    }

    public byte getMinRangeValue() {
        return this.minRangeValue;
    }

    public byte getMaxRangeValue() {
        return this.maxRangeValue;
    }

    public VoteWeighting getVoteWeighting() {
        return this.voteWeighting;
    }

    public static final class PollBuilder {
        private final String pollName;
        private final String pollDescription;
        private final String[] pollOptions;
        private final int finishHeight;
        private final byte votingModel;
        private long minBalance = 0L;
        private byte minBalanceModel;
        private final byte minNumberOfOptions;
        private final byte maxNumberOfOptions;
        private final byte minRangeValue;
        private final byte maxRangeValue;
        private long holdingId;

        public PollBuilder(String string, String string2, String[] stringArray, int n, byte by, byte by2, byte by3, byte by4, byte by5) {
            this.pollName = string;
            this.pollDescription = string2;
            this.pollOptions = stringArray;
            this.finishHeight = n;
            this.votingModel = by;
            this.minNumberOfOptions = by2;
            this.maxNumberOfOptions = by3;
            this.minRangeValue = by4;
            this.maxRangeValue = by5;
            this.minBalanceModel = VoteWeighting.VotingModel.get(by).getMinBalanceModel().getCode();
        }

        public PollBuilder minBalance(byte by, long l) {
            this.minBalanceModel = by;
            this.minBalance = l;
            return this;
        }

        public PollBuilder holdingId(long l) {
            this.holdingId = l;
            return this;
        }

        public PollCreationAttachment build() {
            return new PollCreationAttachment(this);
        }
    }
}

