/*
 * Decompiled with CFR 0.152.
 */
package nxt.voting;

import java.nio.ByteBuffer;
import nxt.NxtException;
import nxt.blockchain.Attachment;
import nxt.blockchain.TransactionType;
import nxt.util.Convert;
import nxt.voting.VotingTransactionType;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public final class VoteCastingAttachment
extends Attachment.AbstractAttachment {
    private final long pollId;
    private final byte[] pollVote;

    public VoteCastingAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
        super(byteBuffer);
        this.pollId = byteBuffer.getLong();
        byte by = byteBuffer.get();
        if (by > 100) {
            throw new NxtException.NotValidException("More than 100 options in a vote");
        }
        this.pollVote = new byte[by];
        byteBuffer.get(this.pollVote);
    }

    public VoteCastingAttachment(JSONObject jSONObject) {
        super(jSONObject);
        this.pollId = Convert.parseUnsignedLong((String)jSONObject.get((Object)"poll"));
        JSONArray jSONArray = (JSONArray)jSONObject.get((Object)"vote");
        this.pollVote = new byte[jSONArray.size()];
        for (int i = 0; i < this.pollVote.length; ++i) {
            this.pollVote[i] = ((Long)jSONArray.get(i)).byteValue();
        }
    }

    public VoteCastingAttachment(long l, byte[] byArray) {
        this.pollId = l;
        this.pollVote = byArray;
    }

    @Override
    protected int getMySize() {
        return 9 + this.pollVote.length;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byteBuffer.putLong(this.pollId);
        byteBuffer.put((byte)this.pollVote.length);
        byteBuffer.put(this.pollVote);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"poll", (Object)Long.toUnsignedString(this.pollId));
        JSONArray jSONArray = new JSONArray();
        if (this.pollVote != null) {
            for (byte by : this.pollVote) {
                jSONArray.add((Object)by);
            }
        }
        jSONObject.put((Object)"vote", (Object)jSONArray);
    }

    @Override
    public TransactionType getTransactionType() {
        return VotingTransactionType.VOTE_CASTING;
    }

    public long getPollId() {
        return this.pollId;
    }

    public byte[] getPollVote() {
        return this.pollVote;
    }
}

