/*
 * Decompiled with CFR 0.152.
 */
package nxtdesktop;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.concurrent.Worker;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.FileChooser;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javax.net.ssl.HttpsURLConnection;
import netscape.javascript.JSObject;
import nxt.Nxt;
import nxt.blockchain.Block;
import nxt.blockchain.BlockchainProcessor;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildChain;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionProcessor;
import nxt.http.API;
import nxt.messaging.PrunableMessageHome;
import nxt.taggeddata.TaggedDataHome;
import nxt.util.Convert;
import nxt.util.Logger;
import nxt.util.TrustAllSSLProvider;
import nxt.util.security.BlockchainPermission;
import nxtdesktop.JavaScriptBridge;

public class DesktopApplication
extends Application {
    private static final Set DOWNLOAD_REQUEST_TYPES = new HashSet<String>(Arrays.asList("downloadTaggedData", "downloadPrunableMessage"));
    private static final boolean ENABLE_JAVASCRIPT_DEBUGGER = false;
    private static volatile boolean isLaunched;
    private static volatile Stage stage;
    private static volatile WebEngine webEngine;
    private JSObject nrs;
    private volatile long updateTime;
    private JavaScriptBridge javaScriptBridge;

    public static void launch() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("desktop"));
        }
        if (!isLaunched) {
            isLaunched = true;
            Application.launch(DesktopApplication.class, (String[])new String[0]);
            return;
        }
        if (stage != null) {
            Platform.runLater(() -> DesktopApplication.showStage(false));
        }
    }

    public static void refresh() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("desktop"));
        }
        Platform.runLater(() -> DesktopApplication.showStage(true));
    }

    private static void showStage(boolean bl) {
        if (bl) {
            webEngine.load(DesktopApplication.getUrl());
        }
        if (!stage.isShowing()) {
            stage.show();
        } else if (stage.isIconified()) {
            stage.setIconified(false);
        } else {
            stage.toFront();
        }
    }

    public static void shutdown() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("desktop"));
        }
        System.out.println("shutting down JavaFX platform");
        Platform.exit();
        System.out.println("JavaFX platform shutdown complete");
    }

    public void start(Stage stage) {
        Thread.currentThread().setName("jfx");
        this.logJavaFxProperties();
        DesktopApplication.stage = stage;
        Rectangle2D rectangle2D = Screen.getPrimary().getVisualBounds();
        WebView webView = new WebView();
        WebView webView2 = new WebView();
        int n = (int)Math.min(rectangle2D.getMaxY() - 100.0, 1000.0);
        int n2 = (int)Math.min(rectangle2D.getMaxX() - 100.0, 1618.0);
        webView.setMinHeight((double)n);
        webView.setMinWidth((double)n2);
        webEngine = webView.getEngine();
        webEngine.setUserDataDirectory(Nxt.getConfDir());
        Worker worker = webEngine.getLoadWorker();
        worker.stateProperty().addListener((observableValue, state, state2) -> {
            Logger.logDebugMessage("loadWorker old state " + state + " new state " + state2);
            if (state2 != Worker.State.SUCCEEDED) {
                Logger.logDebugMessage("loadWorker state change ignored");
                return;
            }
            JSObject jSObject = (JSObject)webEngine.executeScript("window");
            this.javaScriptBridge = new JavaScriptBridge(this);
            jSObject.setMember("java", this.javaScriptBridge);
            Locale locale = Locale.getDefault();
            String string = locale.getLanguage().toLowerCase() + "-" + locale.getCountry().toUpperCase();
            jSObject.setMember("javaFxLanguage", string);
            webEngine.executeScript("console.log = function(msg) { java.log(msg); };");
            stage.setTitle("Ardor Desktop - " + webEngine.getLocation());
            this.nrs = (JSObject)webEngine.executeScript("NRS");
            this.updateClientState("Desktop Wallet started");
            BlockchainProcessor blockchainProcessor = Nxt.getBlockchainProcessor();
            blockchainProcessor.addListener(this::updateClientState, BlockchainProcessor.Event.BLOCK_PUSHED);
            Nxt.getTransactionProcessor().addListener(list -> this.updateClientState(TransactionProcessor.Event.ADDED_UNCONFIRMED_TRANSACTIONS, (List<? extends Transaction>)list), TransactionProcessor.Event.ADDED_UNCONFIRMED_TRANSACTIONS);
            Nxt.getTransactionProcessor().addListener(list -> this.updateClientState(TransactionProcessor.Event.REMOVED_UNCONFIRMED_TRANSACTIONS, (List<? extends Transaction>)list), TransactionProcessor.Event.REMOVED_UNCONFIRMED_TRANSACTIONS);
        });
        webView2.getEngine().locationProperty().addListener((observableValue, string, string2) -> this.popupHandlerURLChange((String)string2));
        webEngine.locationProperty().addListener((observableValue, string, string2) -> this.webViewURLChange((String)string2));
        webEngine.setCreatePopupHandler(popupFeatures -> {
            Logger.logInfoMessage("popup request from webEngine");
            return webView2.getEngine();
        });
        webEngine.load(DesktopApplication.getUrl());
        Scene scene = new Scene((Parent)webView);
        String string3 = API.getServerRootUri().toString();
        stage.getIcons().add((Object)new Image(string3 + "/img/nxt-icon-32x32.png"));
        stage.initStyle(StageStyle.DECORATED);
        stage.setScene(scene);
        stage.sizeToScene();
        stage.show();
        Platform.setImplicitExit((boolean)false);
    }

    private void updateClientState(Block block) {
        if (Nxt.getBlockchainProcessor().isDownloading() && System.currentTimeMillis() - this.updateTime < 10000L) {
            return;
        }
        String string = BlockchainProcessor.Event.BLOCK_PUSHED.toString() + " id " + block.getStringId() + " height " + block.getHeight();
        this.updateClientState(string);
    }

    private void updateClientState(TransactionProcessor.Event event, List<? extends Transaction> list) {
        if (System.currentTimeMillis() - this.updateTime > 3000L) {
            String string = event.toString() + " ids " + list.stream().map(Transaction::getStringId).collect(Collectors.joining(","));
            this.updateClientState(string);
        }
    }

    private void updateClientState(String string) {
        this.updateTime = System.currentTimeMillis();
        Platform.runLater(() -> webEngine.executeScript("NRS.getState(null, '" + string + "')"));
    }

    private static String getUrl() {
        String string;
        String string2 = API.getWelcomePageUri().toString();
        if (string2.startsWith("https")) {
            HttpsURLConnection.setDefaultSSLSocketFactory(TrustAllSSLProvider.getSslSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(TrustAllSSLProvider.getHostNameVerifier());
        }
        if ((string = Nxt.getStringProperty("nxt.defaultDesktopAccount")) != null && !string.equals("")) {
            string2 = string2 + "?account=" + string;
        }
        return string2;
    }

    public void popupHandlerURLChange(String string) {
        Logger.logInfoMessage("popup request for " + string);
        Platform.runLater(() -> {
            try {
                Desktop.getDesktop().browse(new URI(string));
            }
            catch (Exception exception) {
                Logger.logInfoMessage("Cannot open " + string + " error " + exception.getMessage());
            }
        });
    }

    private void webViewURLChange(String string) {
        URL uRL;
        Logger.logInfoMessage("webview address changed to " + string);
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            Logger.logInfoMessage("Malformed URL " + string, malformedURLException);
            return;
        }
        String string2 = uRL.getQuery();
        if (string2 == null) {
            return;
        }
        String[] stringArray = string2.split("&");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string3 : stringArray) {
            String[] stringArray2 = string3.split("=");
            if (stringArray2.length != 2) continue;
            hashMap.put(stringArray2[0], stringArray2[1]);
        }
        String string4 = (String)hashMap.get("requestType");
        if (DOWNLOAD_REQUEST_TYPES.contains(string4)) {
            this.download(string4, hashMap);
        } else {
            Logger.logInfoMessage(String.format("requestType %s is not a download request", string4));
        }
    }

    private void download(String string, Map<String, String> map) {
        String string2 = map.get("chain");
        Chain chain = Chain.getChain(string2);
        if (chain == null) {
            chain = Chain.getChain(Integer.valueOf(string2));
        }
        boolean bl = "true".equals(map.get("retrieve"));
        byte[] byArray = Convert.parseHexString(map.get("transactionFullHash"));
        if (string.equals("downloadTaggedData")) {
            ChildChain childChain = (ChildChain)chain;
            TaggedDataHome.TaggedData taggedData = childChain.getTaggedDataHome().getData(byArray);
            if (taggedData == null && bl) {
                try {
                    if (Nxt.getBlockchainProcessor().restorePrunedTransaction(childChain, byArray) == null) {
                        this.growl("Pruned transaction data not currently available from any peer");
                        return;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.growl("Pruned transaction data cannot be restored using desktop wallet without full blockchain. Use Web Wallet instead");
                    return;
                }
                taggedData = childChain.getTaggedDataHome().getData(byArray);
            }
            if (taggedData == null) {
                this.growl("Tagged data not found");
                return;
            }
            byte[] byArray2 = taggedData.getData();
            String string3 = taggedData.getFilename();
            if (string3 == null || string3.trim().isEmpty()) {
                string3 = taggedData.getName().trim();
            }
            this.downloadFile(byArray2, string3);
        } else if (string.equals("downloadPrunableMessage")) {
            PrunableMessageHome.PrunableMessage prunableMessage = chain.getPrunableMessageHome().getPrunableMessage(byArray);
            if (prunableMessage == null && bl) {
                try {
                    if (Nxt.getBlockchainProcessor().restorePrunedTransaction(chain, byArray) == null) {
                        this.growl("Pruned message not currently available from any peer");
                        return;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.growl("Pruned message cannot be restored using desktop wallet without full blockchain. Use Web Wallet instead");
                    return;
                }
                prunableMessage = chain.getPrunableMessageHome().getPrunableMessage(byArray);
            }
            String string4 = map.get("secretPhrase");
            byte[] byArray3 = Convert.parseHexString(map.get("sharedKey"));
            if (byArray3 == null) {
                byArray3 = Convert.EMPTY_BYTE;
            }
            if (byArray3.length != 0 && string4 != null) {
                this.growl("Do not specify both secret phrase and shared key");
                return;
            }
            byte[] byArray4 = null;
            if (prunableMessage != null) {
                try {
                    byArray4 = string4 != null ? prunableMessage.decrypt(string4) : (byArray3.length > 0 ? prunableMessage.decrypt(byArray3) : prunableMessage.getMessage());
                }
                catch (RuntimeException runtimeException) {
                    Logger.logDebugMessage("Decryption of message to recipient failed: " + runtimeException.toString());
                    this.growl("Wrong secretPhrase or sharedKey");
                    return;
                }
            }
            if (byArray4 == null) {
                byArray4 = Convert.EMPTY_BYTE;
            }
            this.downloadFile(byArray4, Long.toUnsignedString(Convert.fullHashToId(byArray)));
        }
    }

    private void downloadFile(byte[] byArray, String string) {
        Path path = Paths.get(System.getProperty("user.home"), "Downloads");
        if (!Files.exists(path, new LinkOption[0])) {
            path = Paths.get(System.getProperty("user.home"), new String[0]);
        }
        Path path2 = Paths.get(path.toString(), string);
        Logger.logInfoMessage("Before downloading file %s to default path %s", string, path2.toAbsolutePath());
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save File");
        fileChooser.setInitialDirectory(path.toFile());
        fileChooser.setInitialFileName(string);
        File file = fileChooser.showSaveDialog((Window)stage);
        if (file != null) {
            try (OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
                outputStream.write(byArray);
                this.growl(String.format("File %s downloaded", file.getAbsolutePath()));
            }
            catch (IOException iOException) {
                this.growl("Download failed " + iOException.getMessage(), iOException);
            }
        } else {
            this.growl("File download cancelled");
        }
    }

    void downloadFile(String string, String string2) {
        this.downloadFile(string.getBytes(StandardCharsets.UTF_8), string2);
    }

    Optional<String> readTextfile(Path path, String string) throws IOException {
        Logger.logInfoMessage("Before loading file %s from path %s", string, path.toAbsolutePath());
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Load File");
        fileChooser.setInitialDirectory(path.toFile());
        fileChooser.setInitialFileName(string);
        File file = fileChooser.showOpenDialog((Window)stage);
        if (file != null) {
            String string2 = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
            this.growl(String.format("File %s loaded", file.getAbsolutePath()));
            return Optional.of(string2);
        }
        this.growl("File load cancelled");
        return Optional.empty();
    }

    public void stop() {
        System.out.println("DesktopApplication stopped");
    }

    private void growl(String string) {
        this.growl(string, null);
    }

    private void growl(String string, Exception exception) {
        if (exception == null) {
            Logger.logInfoMessage(string);
        } else {
            Logger.logInfoMessage(string, exception);
        }
        this.nrs.call("growl", string);
    }

    private void logJavaFxProperties() {
        String[] stringArray;
        for (String string : stringArray = new String[]{"javafx.version", "javafx.runtime.version"}) {
            Logger.logDebugMessage(String.format("%s = %s", string, System.getProperty(string)));
        }
    }
}

