/*
 * Decompiled with CFR 0.152.
 */
package com.jelurida.ardor.contracts;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import nxt.addons.AbstractContractContext;
import nxt.addons.JO;

public class BittrexRateProvider {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static JO getRate(AbstractContractContext context, String coin) {
        URL url;
        String protocol = "https";
        String host = "bittrex.com";
        int port = 443;
        String urlParams = "/api/v1.1/public/getticker?market=BTC-" + coin;
        JO response = new JO();
        try {
            url = new URL(protocol, host, port, urlParams);
        }
        catch (MalformedURLException e) {
            context.logErrorMessage((Throwable)e);
            response.put("errorCode", (Object)10002);
            response.put("errorDescription", (Object)e.getMessage());
            return response;
        }
        try {
            context.logInfoMessage("Sending request to server: " + url.toString(), new Object[0]);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            if (connection.getResponseCode() != 200) {
                context.logInfoMessage("getRate response %d", new Object[]{connection.getResponseCode()});
                response.put("errorCode", (Object)10003);
                response.put("errorDescription", (Object)"No response");
                return response;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                JO jO = JO.parse((Reader)reader);
                return jO;
            }
        }
        catch (IOException | RuntimeException e) {
            context.logErrorMessage((Throwable)e);
            response.put("errorCode", (Object)10004);
            response.put("errorDescription", (Object)e.getMessage());
            return response;
        }
    }
}

