/*
 * Decompiled with CFR 0.152.
 */
package com.mohamnag.fxwebview_debugger;

import com.mohamnag.fxwebview_debugger.DevToolsDebuggerServer;
import java.io.IOException;
import java.text.MessageFormat;
import javax.servlet.ServletContext;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;

public class DevToolsWebSocket
implements WebSocketListener {
    public static final String WEB_SOCKET_ATTR_NAME = "org.javafx.devtools.DevToolsWebSocket";
    private Session session;
    private ServletContext context = DevToolsDebuggerServer.getServletContext();

    public void onWebSocketConnect(Session session) {
        this.session = session;
        if (this.context.getAttribute(WEB_SOCKET_ATTR_NAME) != null) {
            session.close();
            System.out.println("Another client is already connected. Connection refused");
        } else {
            this.context.setAttribute(WEB_SOCKET_ATTR_NAME, (Object)this);
            System.out.println("Client connected");
        }
    }

    public void onWebSocketClose(int closeCode, String message) {
        DevToolsWebSocket mainSocket = (DevToolsWebSocket)this.context.getAttribute(WEB_SOCKET_ATTR_NAME);
        if (mainSocket == this) {
            this.context.removeAttribute(WEB_SOCKET_ATTR_NAME);
            System.out.println("Client disconnected");
        }
    }

    public void sendMessage(String data) throws IOException {
        RemoteEndpoint remote = this.session.getRemote();
        remote.sendString(data);
    }

    public void onWebSocketText(String data) {
        DevToolsDebuggerServer.sendMessageToBrowser(data);
    }

    public void onWebSocketError(Throwable t) {
        String errorMessage = t.getMessage();
        System.out.println(MessageFormat.format("WebSocket error occurred: {0}", errorMessage));
    }

    public void onWebSocketBinary(byte[] arg0, int arg1, int arg2) {
    }
}

