/*
 * Decompiled with CFR 0.152.
 */
package nxt.account;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import nxt.Constants;
import nxt.Nxt;
import nxt.blockchain.Block;
import nxt.blockchain.Blockchain;
import nxt.blockchain.BlockchainProcessor;
import nxt.blockchain.Chain;
import nxt.blockchain.FxtChain;
import nxt.blockchain.Transaction;
import nxt.db.DbUtils;
import nxt.db.DerivedDbTable;
import nxt.dbschema.Db;
import nxt.util.Convert;
import nxt.util.Listener;
import nxt.util.Listeners;
import nxt.util.Logger;
import nxt.util.security.BlockchainPermission;

public class AccountLedger {
    private static final boolean ledgerEnabled;
    private static final boolean trackAllAccounts;
    private static final SortedSet<Long> trackAccounts;
    private static final int logUnconfirmed;
    public static final int trimKeep;
    private static final Blockchain blockchain;
    private static final BlockchainProcessor blockchainProcessor;
    private static final List<LedgerEntry> pendingEntries;
    private static final AccountLedgerTable accountLedgerTable;
    private static final Listeners<LedgerEntry, Event> listeners;

    public static void init() {
    }

    public static boolean addListener(Listener<LedgerEntry> listener, Event event) {
        return listeners.addListener(listener, event);
    }

    public static boolean removeListener(Listener<LedgerEntry> listener, Event event) {
        return listeners.removeListener(listener, event);
    }

    static boolean mustLogEntry(LedgerEvent ledgerEvent, long l, boolean bl) {
        if (ledgerEvent == null) {
            return false;
        }
        if (!ledgerEnabled || !trackAllAccounts && !trackAccounts.contains(l)) {
            return false;
        }
        if (!blockchainProcessor.isProcessingBlock()) {
            return false;
        }
        if (bl && logUnconfirmed == 0) {
            return false;
        }
        if (!bl && logUnconfirmed == 2) {
            return false;
        }
        if (trimKeep > 0 && blockchain.getHeight() <= Constants.LAST_KNOWN_BLOCK - trimKeep) {
            return false;
        }
        return !blockchainProcessor.isScanning() || trimKeep <= 0 || blockchain.getHeight() > blockchainProcessor.getInitialScanHeight() - trimKeep;
    }

    static void logEntry(LedgerEntry ledgerEntry) {
        if (!Db.db.isInTransaction()) {
            throw new IllegalStateException("Not in transaction");
        }
        int n = pendingEntries.indexOf(ledgerEntry);
        if (n >= 0) {
            LedgerEntry ledgerEntry2 = pendingEntries.remove(n);
            ledgerEntry.updateChange(ledgerEntry2.getChange());
            long l = ledgerEntry2.getBalance() - ledgerEntry2.getChange();
            while (n < pendingEntries.size()) {
                ledgerEntry2 = pendingEntries.get(n);
                if (ledgerEntry2.getAccountId() == ledgerEntry.getAccountId() && ledgerEntry2.getHolding() == ledgerEntry.getHolding() && ledgerEntry2.getHoldingId() == ledgerEntry.getHoldingId()) {
                    ledgerEntry2.setBalance(l += ledgerEntry2.getChange());
                }
                ++n;
            }
        }
        pendingEntries.add(ledgerEntry);
    }

    public static void commitEntries() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("ledger"));
        }
        int n = 0;
        for (LedgerEntry ledgerEntry : pendingEntries) {
            AccountLedger.accountLedgerTable.insert(ledgerEntry);
            listeners.notify(ledgerEntry, Event.ADD_ENTRY);
            if (++n % Constants.BATCH_COMMIT_SIZE != 0) continue;
            Db.db.commitTransaction();
        }
        pendingEntries.clear();
    }

    public static void clearEntries() {
        pendingEntries.clear();
    }

    public static LedgerEntry getEntry(long l) {
        LedgerEntry ledgerEntry;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("ledger"));
        }
        if (!ledgerEnabled) {
            return null;
        }
        try (Connection connection = accountLedgerTable.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM account_ledger WHERE db_id = ?");){
            preparedStatement.setLong(1, l);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                ledgerEntry = resultSet.next() ? new LedgerEntry(resultSet) : null;
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
        return ledgerEntry;
    }

    public static List<LedgerEntry> getEntries(long l, LedgerEvent ledgerEvent, long l2, LedgerHolding ledgerHolding, long l3, int n, int n2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("ledger"));
        }
        if (!ledgerEnabled) {
            return Collections.emptyList();
        }
        ArrayList<LedgerEntry> arrayList = new ArrayList<LedgerEntry>();
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("SELECT * FROM account_ledger ");
        if (l != 0L || ledgerEvent != null || ledgerHolding != null) {
            stringBuilder.append("WHERE ");
        }
        if (l != 0L) {
            stringBuilder.append("account_id = ? ");
        }
        if (ledgerEvent != null) {
            if (l != 0L) {
                stringBuilder.append("AND ");
            }
            stringBuilder.append("event_type = ? ");
            if (l2 != 0L) {
                stringBuilder.append("AND event_id = ? ");
            }
        }
        if (ledgerHolding != null) {
            if (l != 0L || ledgerEvent != null) {
                stringBuilder.append("AND ");
            }
            stringBuilder.append("holding_type = ? ");
            if (l3 != 0L) {
                stringBuilder.append("AND holding_id = ? ");
            }
        }
        stringBuilder.append("ORDER BY db_id DESC ");
        stringBuilder.append(DbUtils.limitsClause(n, n2));
        blockchain.readLock();
        try (Connection connection = accountLedgerTable.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(stringBuilder.toString());){
            int n3 = 0;
            if (l != 0L) {
                preparedStatement.setLong(++n3, l);
            }
            if (ledgerEvent != null) {
                preparedStatement.setByte(++n3, (byte)ledgerEvent.getCode());
                if (l2 != 0L) {
                    preparedStatement.setLong(++n3, l2);
                }
            }
            if (ledgerHolding != null) {
                preparedStatement.setByte(++n3, (byte)ledgerHolding.getCode());
                if (l3 != 0L) {
                    preparedStatement.setLong(++n3, l3);
                }
            }
            DbUtils.setLimits(++n3, preparedStatement, n, n2);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    arrayList.add(new LedgerEntry(resultSet));
                }
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
        finally {
            blockchain.readUnlock();
        }
        return arrayList;
    }

    public static LedgerEventId newEventId(final long l, final byte[] byArray, final Chain chain) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("ledger"));
        }
        return new LedgerEventId(){

            @Override
            public long getId() {
                return l;
            }

            @Override
            public byte[] getFullHash() {
                return byArray;
            }

            @Override
            public Chain getChain() {
                return chain;
            }
        };
    }

    public static LedgerEventId newEventId(Transaction transaction) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("ledger"));
        }
        return transaction;
    }

    public static LedgerEventId newEventId(final Block block) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("ledger"));
        }
        return new LedgerEventId(){

            @Override
            public long getId() {
                return block.getId();
            }

            @Override
            public byte[] getFullHash() {
                return null;
            }

            @Override
            public Chain getChain() {
                return FxtChain.FXT;
            }
        };
    }

    static {
        trackAccounts = new TreeSet<Long>();
        trimKeep = Nxt.getIntProperty("nxt.ledgerTrimKeep", 30000);
        blockchain = Nxt.getBlockchain();
        blockchainProcessor = Nxt.getBlockchainProcessor();
        pendingEntries = new ArrayList<LedgerEntry>();
        List<String> list = Nxt.getStringListProperty("nxt.ledgerAccounts");
        ledgerEnabled = !list.isEmpty();
        trackAllAccounts = list.contains("*");
        if (ledgerEnabled) {
            if (trackAllAccounts) {
                Logger.logInfoMessage("Account ledger is tracking all accounts");
            } else {
                for (String string : list) {
                    try {
                        trackAccounts.add(Convert.parseAccountId(string));
                        Logger.logInfoMessage("Account ledger is tracking account " + string);
                    }
                    catch (RuntimeException runtimeException) {
                        Logger.logErrorMessage("Account " + string + " is not valid; ignored");
                    }
                }
            }
        } else {
            Logger.logInfoMessage("Account ledger is not enabled");
        }
        int n = Nxt.getIntProperty("nxt.ledgerLogUnconfirmed", 1);
        logUnconfirmed = n >= 0 && n <= 2 ? n : 1;
        accountLedgerTable = new AccountLedgerTable();
        listeners = new Listeners();
    }

    public static class LedgerEntry {
        private long ledgerId = -1L;
        private final LedgerEvent event;
        private final long eventId;
        private final byte[] eventHash;
        private final int chainId;
        private final long accountId;
        private final LedgerHolding holding;
        private final long holdingId;
        private long change;
        private long balance;
        private final long blockId;
        private final int height;
        private final int timestamp;

        public LedgerEntry(LedgerEvent ledgerEvent, LedgerEventId ledgerEventId, long l, LedgerHolding ledgerHolding, long l2, long l3, long l4) {
            this.event = ledgerEvent;
            this.eventId = ledgerEventId.getId();
            this.eventHash = ledgerEventId.getFullHash();
            this.chainId = ledgerEventId.getChain().getId();
            this.accountId = l;
            this.holding = ledgerHolding;
            this.holdingId = l2;
            this.change = l3;
            this.balance = l4;
            Block block = blockchain.getLastBlock();
            this.blockId = block.getId();
            this.height = block.getHeight();
            this.timestamp = block.getTimestamp();
        }

        private LedgerEntry(ResultSet resultSet) throws SQLException {
            this.ledgerId = resultSet.getLong("db_id");
            this.event = LedgerEvent.fromCode(resultSet.getByte("event_type"));
            this.eventId = resultSet.getLong("event_id");
            this.eventHash = resultSet.getBytes("event_hash");
            this.chainId = resultSet.getInt("chain_id");
            this.accountId = resultSet.getLong("account_id");
            this.holding = LedgerHolding.fromCode(resultSet.getByte("holding_type"));
            this.holdingId = resultSet.getLong("holding_id");
            this.change = resultSet.getLong("change");
            this.balance = resultSet.getLong("balance");
            this.blockId = resultSet.getLong("block_id");
            this.height = resultSet.getInt("height");
            this.timestamp = resultSet.getInt("timestamp");
        }

        public long getLedgerId() {
            return this.ledgerId;
        }

        public LedgerEvent getEvent() {
            return this.event;
        }

        public long getEventId() {
            return this.eventId;
        }

        public byte[] getEventHash() {
            return this.eventHash;
        }

        public int getChainId() {
            return this.chainId;
        }

        public long getAccountId() {
            return this.accountId;
        }

        public LedgerHolding getHolding() {
            return this.holding;
        }

        public long getHoldingId() {
            return this.holdingId;
        }

        private void updateChange(long l) {
            this.change += l;
        }

        public long getChange() {
            return this.change;
        }

        private void setBalance(long l) {
            this.balance = l;
        }

        public long getBalance() {
            return this.balance;
        }

        public long getBlockId() {
            return this.blockId;
        }

        public int getHeight() {
            return this.height;
        }

        public int getTimestamp() {
            return this.timestamp;
        }

        public int hashCode() {
            return Long.hashCode(this.accountId) ^ this.event.getCode() ^ Long.hashCode(this.eventId) ^ this.holding.getCode() ^ Long.hashCode(this.holdingId);
        }

        public boolean equals(Object object) {
            return object != null && object instanceof LedgerEntry && this.accountId == ((LedgerEntry)object).accountId && this.event == ((LedgerEntry)object).event && this.eventId == ((LedgerEntry)object).eventId && Arrays.equals(this.eventHash, ((LedgerEntry)object).eventHash) && this.chainId == ((LedgerEntry)object).chainId && this.holding == ((LedgerEntry)object).holding && this.holdingId == ((LedgerEntry)object).holdingId;
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO account_ledger (account_id, event_type, event_id, event_hash, chain_id, holding_type, holding_id, change, balance, block_id, height, timestamp) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", 1);){
                int n = 0;
                preparedStatement.setLong(++n, this.accountId);
                preparedStatement.setByte(++n, (byte)this.event.getCode());
                preparedStatement.setLong(++n, this.eventId);
                DbUtils.setBytes(preparedStatement, ++n, this.eventHash);
                preparedStatement.setInt(++n, this.chainId);
                preparedStatement.setByte(++n, (byte)this.holding.getCode());
                DbUtils.setLong(preparedStatement, ++n, this.holdingId);
                preparedStatement.setLong(++n, this.change);
                preparedStatement.setLong(++n, this.balance);
                preparedStatement.setLong(++n, this.blockId);
                preparedStatement.setInt(++n, this.height);
                preparedStatement.setInt(++n, this.timestamp);
                preparedStatement.executeUpdate();
                try (ResultSet resultSet = preparedStatement.getGeneratedKeys();){
                    if (resultSet.next()) {
                        this.ledgerId = resultSet.getLong(1);
                    }
                }
            }
        }
    }

    public static interface LedgerEventId {
        public long getId();

        public byte[] getFullHash();

        public Chain getChain();
    }

    public static enum LedgerHolding {
        UNCONFIRMED_COIN_BALANCE(1, true),
        COIN_BALANCE(2, false),
        UNCONFIRMED_ASSET_BALANCE(3, true),
        ASSET_BALANCE(4, false),
        UNCONFIRMED_CURRENCY_BALANCE(5, true),
        CURRENCY_BALANCE(6, false);

        private static final Map<Integer, LedgerHolding> holdingMap;
        private final int code;
        private final boolean isUnconfirmed;

        private LedgerHolding(int n2, boolean bl) {
            this.code = n2;
            this.isUnconfirmed = bl;
        }

        public boolean isUnconfirmed() {
            return this.isUnconfirmed;
        }

        public int getCode() {
            return this.code;
        }

        public static LedgerHolding fromCode(int n) {
            LedgerHolding ledgerHolding = holdingMap.get(n);
            if (ledgerHolding == null) {
                throw new IllegalArgumentException("LedgerHolding code " + n + " is unknown");
            }
            return ledgerHolding;
        }

        static {
            holdingMap = new HashMap<Integer, LedgerHolding>();
            for (LedgerHolding ledgerHolding : LedgerHolding.values()) {
                if (holdingMap.put(ledgerHolding.code, ledgerHolding) == null) continue;
                throw new RuntimeException("LedgerHolding code " + ledgerHolding.code + " reused");
            }
        }
    }

    public static enum LedgerEvent {
        BLOCK_GENERATED(1, false),
        REJECT_PHASED_TRANSACTION(2, true),
        TRANSACTION_FEE(3, true),
        CHILD_BLOCK(4, true),
        ORDINARY_PAYMENT(5, true),
        FXT_PAYMENT(6, true),
        ACCOUNT_INFO(7, true),
        ALIAS_ASSIGNMENT(8, true),
        ALIAS_BUY(9, true),
        ALIAS_DELETE(10, true),
        ALIAS_SELL(11, true),
        ARBITRARY_MESSAGE(12, true),
        PHASING_VOTE_CASTING(13, true),
        POLL_CREATION(14, true),
        VOTE_CASTING(15, true),
        ACCOUNT_PROPERTY_SET(16, true),
        ACCOUNT_PROPERTY_DELETE(17, true),
        ASSET_ASK_ORDER_CANCELLATION(18, true),
        ASSET_ASK_ORDER_PLACEMENT(19, true),
        ASSET_BID_ORDER_CANCELLATION(20, true),
        ASSET_BID_ORDER_PLACEMENT(21, true),
        ASSET_DIVIDEND_PAYMENT(22, true),
        ASSET_ISSUANCE(23, true),
        ASSET_TRADE(24, true),
        ASSET_TRANSFER(25, true),
        ASSET_DELETE(26, true),
        ASSET_INCREASE(61, true),
        ASSET_SET_PHASING_CONTROL(62, true),
        ASSET_PROPERTY_SET(65, true),
        ASSET_PROPERTY_DELETE(66, true),
        DIGITAL_GOODS_DELISTED(27, true),
        DIGITAL_GOODS_DELISTING(28, true),
        DIGITAL_GOODS_DELIVERY(29, true),
        DIGITAL_GOODS_FEEDBACK(30, true),
        DIGITAL_GOODS_LISTING(31, true),
        DIGITAL_GOODS_PRICE_CHANGE(32, true),
        DIGITAL_GOODS_PURCHASE(33, true),
        DIGITAL_GOODS_PURCHASE_EXPIRED(34, true),
        DIGITAL_GOODS_QUANTITY_CHANGE(35, true),
        DIGITAL_GOODS_REFUND(36, true),
        ACCOUNT_CONTROL_EFFECTIVE_BALANCE_LEASING(37, true),
        ACCOUNT_CONTROL_PHASING_ONLY(38, true),
        CURRENCY_DELETION(39, true),
        CURRENCY_DISTRIBUTION(40, true),
        CURRENCY_EXCHANGE(41, true),
        CURRENCY_EXCHANGE_BUY(42, true),
        CURRENCY_EXCHANGE_SELL(43, true),
        CURRENCY_ISSUANCE(44, true),
        CURRENCY_MINTING(45, true),
        CURRENCY_OFFER_EXPIRED(46, true),
        CURRENCY_OFFER_REPLACED(47, true),
        CURRENCY_PUBLISH_EXCHANGE_OFFER(48, true),
        CURRENCY_RESERVE_CLAIM(49, true),
        CURRENCY_RESERVE_INCREASE(50, true),
        CURRENCY_TRANSFER(51, true),
        CURRENCY_UNDO_CROWDFUNDING(52, true),
        TAGGED_DATA_UPLOAD(53, true),
        SHUFFLING_REGISTRATION(54, true),
        SHUFFLING_PROCESSING(55, true),
        SHUFFLING_CANCELLATION(56, true),
        SHUFFLING_DISTRIBUTION(57, true),
        COIN_EXCHANGE_ORDER_ISSUE(58, true),
        COIN_EXCHANGE_ORDER_CANCEL(59, true),
        COIN_EXCHANGE_TRADE(60, true),
        CONTRACT_REFERENCE_SET(63, true),
        CONTRACT_REFERENCE_DELETE(64, true);

        private static final Map<Integer, LedgerEvent> eventMap;
        private final int code;
        private final boolean isTransaction;

        private LedgerEvent(int n2, boolean bl) {
            this.code = n2;
            this.isTransaction = bl;
        }

        public boolean isTransaction() {
            return this.isTransaction;
        }

        public int getCode() {
            return this.code;
        }

        public static LedgerEvent fromCode(int n) {
            LedgerEvent ledgerEvent;
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new BlockchainPermission("ledger"));
            }
            if ((ledgerEvent = eventMap.get(n)) == null) {
                throw new IllegalArgumentException("LedgerEvent code " + n + " is unknown");
            }
            return ledgerEvent;
        }

        static {
            eventMap = new HashMap<Integer, LedgerEvent>();
            for (LedgerEvent ledgerEvent : LedgerEvent.values()) {
                if (eventMap.put(ledgerEvent.code, ledgerEvent) == null) continue;
                throw new RuntimeException("LedgerEvent code " + ledgerEvent.code + " reused");
            }
        }
    }

    public static enum Event {
        ADD_ENTRY;

    }

    private static class AccountLedgerTable
    extends DerivedDbTable {
        private AccountLedgerTable() {
            super("public.account_ledger");
        }

        private void insert(LedgerEntry ledgerEntry) {
            try (Connection connection = this.getConnection();){
                ledgerEntry.save(connection);
            }
            catch (SQLException sQLException) {
                throw new RuntimeException(sQLException.toString(), sQLException);
            }
        }

        @Override
        public void trim(int n) {
            if (trimKeep <= 0) {
                return;
            }
            try (Connection connection = this.getConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM account_ledger WHERE height <= ? LIMIT " + Constants.BATCH_COMMIT_SIZE);){
                int n2;
                preparedStatement.setInt(1, Math.max(blockchain.getHeight() - trimKeep, 0));
                do {
                    n2 = preparedStatement.executeUpdate();
                    db.commitTransaction();
                } while (n2 >= Constants.BATCH_COMMIT_SIZE);
            }
            catch (SQLException sQLException) {
                throw new RuntimeException(sQLException.toString(), sQLException);
            }
        }
    }
}

