/*
 * Decompiled with CFR 0.152.
 */
package nxt.account;

import java.nio.ByteBuffer;
import java.util.Map;
import nxt.NxtException;
import nxt.account.Account;
import nxt.account.AccountInfoAttachment;
import nxt.account.AccountLedger;
import nxt.account.AccountPropertyAttachment;
import nxt.account.AccountPropertyDeleteAttachment;
import nxt.blockchain.Appendix;
import nxt.blockchain.ChildTransactionImpl;
import nxt.blockchain.ChildTransactionType;
import nxt.blockchain.Fee;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionImpl;
import nxt.blockchain.TransactionType;
import org.json.simple.JSONObject;

public abstract class AccountPropertyTransactionType
extends ChildTransactionType {
    private static final byte SUBTYPE_ACCOUNT_PROPERTY_ACCOUNT_INFO = 0;
    private static final byte SUBTYPE_ACCOUNT_PROPERTY_SET = 1;
    private static final byte SUBTYPE_ACCOUNT_PROPERTY_DELETE = 2;
    public static final TransactionType ACCOUNT_INFO = new AccountPropertyTransactionType(){
        private final Fee ACCOUNT_INFO_FEE = new Fee.SizeBasedFee(100000000L, 100000000L, 32){

            @Override
            public int getSize(TransactionImpl transactionImpl, Appendix appendix) {
                AccountInfoAttachment accountInfoAttachment = (AccountInfoAttachment)transactionImpl.getAttachment();
                return accountInfoAttachment.getName().length() + accountInfoAttachment.getDescription().length();
            }
        };

        @Override
        public byte getSubtype() {
            return 0;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.ACCOUNT_INFO;
        }

        @Override
        public String getName() {
            return "AccountInfo";
        }

        @Override
        public Fee getBaselineFee(Transaction transaction) {
            return this.ACCOUNT_INFO_FEE;
        }

        @Override
        public AccountInfoAttachment parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            return new AccountInfoAttachment(byteBuffer);
        }

        @Override
        public AccountInfoAttachment parseAttachment(JSONObject jSONObject) {
            return new AccountInfoAttachment(jSONObject);
        }

        @Override
        public void validateAttachment(ChildTransactionImpl childTransactionImpl) throws NxtException.ValidationException {
            AccountInfoAttachment accountInfoAttachment = (AccountInfoAttachment)childTransactionImpl.getAttachment();
            if (!AccountInfoAttachment.NAME_RW.validate(accountInfoAttachment.getName()) || !AccountInfoAttachment.DESCRIPTION_RW.validate(accountInfoAttachment.getDescription())) {
                throw new NxtException.NotValidException("Invalid account info issuance: " + accountInfoAttachment.getJSONObject());
            }
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            AccountInfoAttachment accountInfoAttachment = (AccountInfoAttachment)childTransactionImpl.getAttachment();
            account.setAccountInfo(accountInfoAttachment.getName(), accountInfoAttachment.getDescription());
        }

        @Override
        public boolean isBlockDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            return 1.isDuplicate(ACCOUNT_INFO, this.getName(), map, true);
        }

        @Override
        public boolean canHaveRecipient() {
            return false;
        }

        @Override
        public boolean isPhasingSafe() {
            return true;
        }
    };
    public static final TransactionType ACCOUNT_PROPERTY_SET = new AccountPropertyTransactionType(){
        private final Fee ACCOUNT_PROPERTY_FEE = new Fee.SizeBasedFee(10000000L, 10000000L, 32){

            @Override
            public int getSize(TransactionImpl transactionImpl, Appendix appendix) {
                AccountPropertyAttachment accountPropertyAttachment = (AccountPropertyAttachment)transactionImpl.getAttachment();
                return accountPropertyAttachment.getValue().length();
            }
        };

        @Override
        public byte getSubtype() {
            return 1;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.ACCOUNT_PROPERTY_SET;
        }

        @Override
        public String getName() {
            return "AccountProperty";
        }

        @Override
        public Fee getBaselineFee(Transaction transaction) {
            return this.ACCOUNT_PROPERTY_FEE;
        }

        @Override
        public AccountPropertyAttachment parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            return new AccountPropertyAttachment(byteBuffer);
        }

        @Override
        public AccountPropertyAttachment parseAttachment(JSONObject jSONObject) {
            return new AccountPropertyAttachment(jSONObject);
        }

        @Override
        public void validateAttachment(ChildTransactionImpl childTransactionImpl) throws NxtException.ValidationException {
            AccountPropertyAttachment accountPropertyAttachment = (AccountPropertyAttachment)childTransactionImpl.getAttachment();
            if (!Account.PROPERTY_NAME_RW.validate(accountPropertyAttachment.getProperty()) || accountPropertyAttachment.getProperty().length() == 0 || !Account.PROPERTY_VALUE_RW.validate(accountPropertyAttachment.getValue())) {
                throw new NxtException.NotValidException("Invalid account property: " + accountPropertyAttachment.getJSONObject());
            }
            if (childTransactionImpl.getAmount() != 0L) {
                throw new NxtException.NotValidException("Account property transaction cannot be used to send money");
            }
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            AccountPropertyAttachment accountPropertyAttachment = (AccountPropertyAttachment)childTransactionImpl.getAttachment();
            account2.setProperty(childTransactionImpl, account, accountPropertyAttachment.getProperty(), accountPropertyAttachment.getValue());
        }

        @Override
        protected void validateId(ChildTransactionImpl childTransactionImpl) throws NxtException.NotCurrentlyValidException {
            if (Account.getProperty(childTransactionImpl.getId()) != null) {
                throw new NxtException.NotCurrentlyValidException("Duplicate account property id " + childTransactionImpl.getStringId());
            }
        }

        @Override
        public boolean canHaveRecipient() {
            return true;
        }

        @Override
        public boolean isPhasingSafe() {
            return true;
        }
    };
    public static final TransactionType ACCOUNT_PROPERTY_DELETE = new AccountPropertyTransactionType(){

        @Override
        public byte getSubtype() {
            return 2;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.ACCOUNT_PROPERTY_DELETE;
        }

        @Override
        public String getName() {
            return "AccountPropertyDelete";
        }

        @Override
        public AccountPropertyDeleteAttachment parseAttachment(ByteBuffer byteBuffer) {
            return new AccountPropertyDeleteAttachment(byteBuffer);
        }

        @Override
        public AccountPropertyDeleteAttachment parseAttachment(JSONObject jSONObject) {
            return new AccountPropertyDeleteAttachment(jSONObject);
        }

        @Override
        public void validateAttachment(ChildTransactionImpl childTransactionImpl) throws NxtException.ValidationException {
            AccountPropertyDeleteAttachment accountPropertyDeleteAttachment = (AccountPropertyDeleteAttachment)childTransactionImpl.getAttachment();
            Account.AccountProperty accountProperty = Account.getProperty(accountPropertyDeleteAttachment.getPropertyId());
            if (accountProperty == null) {
                throw new NxtException.NotCurrentlyValidException("No such property " + Long.toUnsignedString(accountPropertyDeleteAttachment.getPropertyId()));
            }
            if (accountProperty.getRecipientId() != childTransactionImpl.getSenderId() && accountProperty.getSetterId() != childTransactionImpl.getSenderId()) {
                throw new NxtException.NotValidException("Account " + Long.toUnsignedString(childTransactionImpl.getSenderId()) + " cannot delete property " + Long.toUnsignedString(accountPropertyDeleteAttachment.getPropertyId()));
            }
            if (accountProperty.getRecipientId() != childTransactionImpl.getRecipientId()) {
                throw new NxtException.NotValidException("Account property " + Long.toUnsignedString(accountPropertyDeleteAttachment.getPropertyId()) + " does not belong to " + Long.toUnsignedString(childTransactionImpl.getRecipientId()));
            }
            if (childTransactionImpl.getAmount() != 0L) {
                throw new NxtException.NotValidException("Account property transaction cannot be used to send money");
            }
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            AccountPropertyDeleteAttachment accountPropertyDeleteAttachment = (AccountPropertyDeleteAttachment)childTransactionImpl.getAttachment();
            account.deleteProperty(accountPropertyDeleteAttachment.getPropertyId());
        }

        @Override
        public boolean canHaveRecipient() {
            return true;
        }

        @Override
        public boolean isPhasingSafe() {
            return true;
        }
    };

    public static TransactionType findTransactionType(byte by) {
        switch (by) {
            case 0: {
                return ACCOUNT_INFO;
            }
            case 1: {
                return ACCOUNT_PROPERTY_SET;
            }
            case 2: {
                return ACCOUNT_PROPERTY_DELETE;
            }
        }
        return null;
    }

    private AccountPropertyTransactionType() {
    }

    @Override
    public final byte getType() {
        return 10;
    }

    @Override
    public final boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
        return true;
    }

    @Override
    public final void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
    }

    @Override
    public final boolean isGlobal() {
        return true;
    }
}

