/*
 * Decompiled with CFR 0.152.
 */
package nxt.account;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import nxt.Constants;
import nxt.Nxt;
import nxt.account.Account;
import nxt.account.AccountLedger;
import nxt.blockchain.Chain;
import nxt.blockchain.FxtChain;
import nxt.db.DbKey;
import nxt.db.VersionedEntityDbTable;
import nxt.util.Listener;
import nxt.util.Listeners;
import nxt.util.security.BlockchainPermission;

public final class BalanceHome {
    private static final Listeners<Balance, Event> listeners = new Listeners();
    private final DbKey.LongKeyFactory<Balance> balanceDbKeyFactory;
    private final VersionedEntityDbTable<Balance> balanceTable;
    private final Chain chain;

    public static BalanceHome forChain(Chain chain) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("balance"));
        }
        if (chain.getBalanceHome() != null) {
            throw new IllegalStateException("already set");
        }
        return new BalanceHome(chain);
    }

    public static boolean addListener(Listener<Balance> listener, Event event) {
        return listeners.addListener(listener, event);
    }

    public static boolean removeListener(Listener<Balance> listener, Event event) {
        return listeners.removeListener(listener, event);
    }

    private BalanceHome(Chain chain) {
        this.chain = chain;
        this.balanceDbKeyFactory = new DbKey.LongKeyFactory<Balance>("account_id"){

            @Override
            public DbKey newKey(Balance balance) {
                return balance.dbKey == null ? this.newKey(balance.accountId) : balance.dbKey;
            }

            @Override
            public Balance newEntity(DbKey dbKey) {
                return new Balance(((DbKey.LongKey)dbKey).getId());
            }
        };
        this.balanceTable = chain instanceof FxtChain ? new VersionedEntityDbTable<Balance>(chain.getSchemaTable("balance_fxt"), this.balanceDbKeyFactory){

            @Override
            protected Balance load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
                return new Balance(resultSet, dbKey);
            }

            @Override
            protected void save(Connection connection, Balance balance) throws SQLException {
                balance.save(connection);
            }

            @Override
            public void trim(int n) {
                if (n <= Constants.GUARANTEED_BALANCE_CONFIRMATIONS) {
                    return;
                }
                super.trim(n);
            }

            @Override
            public void checkAvailable(int n) {
                if (n > Constants.GUARANTEED_BALANCE_CONFIRMATIONS) {
                    super.checkAvailable(n);
                    return;
                }
                if (n > Nxt.getBlockchain().getHeight()) {
                    throw new IllegalArgumentException("Height " + n + " exceeds blockchain height " + Nxt.getBlockchain().getHeight());
                }
            }
        } : new VersionedEntityDbTable<Balance>(chain.getSchemaTable("balance"), this.balanceDbKeyFactory){

            @Override
            protected Balance load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
                return new Balance(resultSet, dbKey);
            }

            @Override
            protected void save(Connection connection, Balance balance) throws SQLException {
                balance.save(connection);
            }
        };
    }

    public Balance getBalance(long l) {
        DbKey dbKey = this.balanceDbKeyFactory.newKey(l);
        Balance balance = (Balance)this.balanceTable.get(dbKey);
        if (balance == null) {
            balance = (Balance)this.balanceTable.newEntity(dbKey);
        }
        return balance;
    }

    public Balance getBalance(long l, int n) {
        DbKey dbKey = this.balanceDbKeyFactory.newKey(l);
        Balance balance = (Balance)this.balanceTable.get(dbKey, n);
        if (balance == null) {
            balance = new Balance(l);
        }
        return balance;
    }

    public final class Balance {
        private final long accountId;
        private final DbKey dbKey;
        private long balance;
        private long unconfirmedBalance;

        Balance(long l) {
            this.accountId = l;
            this.dbKey = BalanceHome.this.balanceDbKeyFactory.newKey(l);
            this.balance = 0L;
            this.unconfirmedBalance = 0L;
        }

        private Balance(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.accountId = resultSet.getLong("account_id");
            this.dbKey = dbKey;
            this.balance = resultSet.getLong("balance");
            this.unconfirmedBalance = resultSet.getLong("unconfirmed_balance");
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO " + BalanceHome.this.balanceTable.getSchemaTable() + " (account_id, balance, unconfirmed_balance, height, latest) KEY (account_id, height) VALUES (?, ?, ?, ?, TRUE)");){
                int n = 0;
                preparedStatement.setLong(++n, this.accountId);
                preparedStatement.setLong(++n, this.balance);
                preparedStatement.setLong(++n, this.unconfirmedBalance);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }

        private void save() {
            if (this.balance == 0L && this.unconfirmedBalance == 0L) {
                BalanceHome.this.balanceTable.delete(this, true);
            } else {
                BalanceHome.this.balanceTable.insert(this);
            }
        }

        public Chain getChain() {
            return BalanceHome.this.chain;
        }

        public long getAccountId() {
            return this.accountId;
        }

        public long getBalance() {
            return this.balance;
        }

        public long getUnconfirmedBalance() {
            return this.unconfirmedBalance;
        }

        public void addToBalance(AccountLedger.LedgerEvent ledgerEvent, AccountLedger.LedgerEventId ledgerEventId, long l) {
            this.addToBalance(ledgerEvent, ledgerEventId, l, 0L);
        }

        public void addToBalance(AccountLedger.LedgerEvent ledgerEvent, AccountLedger.LedgerEventId ledgerEventId, long l, long l2) {
            if (l == 0L && l2 == 0L) {
                return;
            }
            long l3 = Math.addExact(l, l2);
            this.balance = Math.addExact(this.balance, l3);
            if (BalanceHome.this.chain == FxtChain.FXT) {
                Account.addToGuaranteedBalanceFQT(this.accountId, l3);
            }
            Account.checkBalance(this.accountId, this.balance, this.unconfirmedBalance);
            this.save();
            listeners.notify(this, Event.BALANCE);
            if (AccountLedger.mustLogEntry(ledgerEvent, this.accountId, false)) {
                if (l2 != 0L) {
                    AccountLedger.logEntry(new AccountLedger.LedgerEntry(AccountLedger.LedgerEvent.TRANSACTION_FEE, ledgerEventId, this.accountId, AccountLedger.LedgerHolding.COIN_BALANCE, BalanceHome.this.chain.getId(), l2, this.balance - l));
                }
                if (l != 0L) {
                    AccountLedger.logEntry(new AccountLedger.LedgerEntry(ledgerEvent, ledgerEventId, this.accountId, AccountLedger.LedgerHolding.COIN_BALANCE, BalanceHome.this.chain.getId(), l, this.balance));
                }
            }
        }

        public void addToUnconfirmedBalance(AccountLedger.LedgerEvent ledgerEvent, AccountLedger.LedgerEventId ledgerEventId, long l) {
            this.addToUnconfirmedBalance(ledgerEvent, ledgerEventId, l, 0L);
        }

        void addToUnconfirmedBalance(AccountLedger.LedgerEvent ledgerEvent, AccountLedger.LedgerEventId ledgerEventId, long l, long l2) {
            if (l == 0L && l2 == 0L) {
                return;
            }
            long l3 = Math.addExact(l, l2);
            this.unconfirmedBalance = Math.addExact(this.unconfirmedBalance, l3);
            Account.checkBalance(this.accountId, this.balance, this.unconfirmedBalance);
            this.save();
            listeners.notify(this, Event.UNCONFIRMED_BALANCE);
            if (AccountLedger.mustLogEntry(ledgerEvent, this.accountId, true)) {
                if (l2 != 0L) {
                    AccountLedger.logEntry(new AccountLedger.LedgerEntry(AccountLedger.LedgerEvent.TRANSACTION_FEE, ledgerEventId, this.accountId, AccountLedger.LedgerHolding.UNCONFIRMED_COIN_BALANCE, BalanceHome.this.chain.getId(), l2, this.unconfirmedBalance - l));
                }
                if (l != 0L) {
                    AccountLedger.logEntry(new AccountLedger.LedgerEntry(ledgerEvent, ledgerEventId, this.accountId, AccountLedger.LedgerHolding.UNCONFIRMED_COIN_BALANCE, BalanceHome.this.chain.getId(), l, this.unconfirmedBalance));
                }
            }
        }

        public void addToBalanceAndUnconfirmedBalance(AccountLedger.LedgerEvent ledgerEvent, AccountLedger.LedgerEventId ledgerEventId, long l) {
            this.addToBalanceAndUnconfirmedBalance(ledgerEvent, ledgerEventId, l, 0L);
        }

        void addToBalanceAndUnconfirmedBalance(AccountLedger.LedgerEvent ledgerEvent, AccountLedger.LedgerEventId ledgerEventId, long l, long l2) {
            if (l == 0L && l2 == 0L) {
                return;
            }
            long l3 = Math.addExact(l, l2);
            this.balance = Math.addExact(this.balance, l3);
            this.unconfirmedBalance = Math.addExact(this.unconfirmedBalance, l3);
            if (BalanceHome.this.chain == FxtChain.FXT) {
                Account.addToGuaranteedBalanceFQT(this.accountId, l3);
            }
            Account.checkBalance(this.accountId, this.balance, this.unconfirmedBalance);
            this.save();
            listeners.notify(this, Event.BALANCE);
            listeners.notify(this, Event.UNCONFIRMED_BALANCE);
            if (AccountLedger.mustLogEntry(ledgerEvent, this.accountId, true)) {
                if (l2 != 0L) {
                    AccountLedger.logEntry(new AccountLedger.LedgerEntry(AccountLedger.LedgerEvent.TRANSACTION_FEE, ledgerEventId, this.accountId, AccountLedger.LedgerHolding.UNCONFIRMED_COIN_BALANCE, BalanceHome.this.chain.getId(), l2, this.unconfirmedBalance - l));
                }
                if (l != 0L) {
                    AccountLedger.logEntry(new AccountLedger.LedgerEntry(ledgerEvent, ledgerEventId, this.accountId, AccountLedger.LedgerHolding.UNCONFIRMED_COIN_BALANCE, BalanceHome.this.chain.getId(), l, this.unconfirmedBalance));
                }
            }
            if (AccountLedger.mustLogEntry(ledgerEvent, this.accountId, false)) {
                if (l2 != 0L) {
                    AccountLedger.logEntry(new AccountLedger.LedgerEntry(AccountLedger.LedgerEvent.TRANSACTION_FEE, ledgerEventId, this.accountId, AccountLedger.LedgerHolding.COIN_BALANCE, BalanceHome.this.chain.getId(), l2, this.balance - l));
                }
                if (l != 0L) {
                    AccountLedger.logEntry(new AccountLedger.LedgerEntry(ledgerEvent, ledgerEventId, this.accountId, AccountLedger.LedgerHolding.COIN_BALANCE, BalanceHome.this.chain.getId(), l, this.balance));
                }
            }
        }
    }

    public static enum Event {
        BALANCE,
        UNCONFIRMED_BALANCE;

    }
}

