/*
 * Decompiled with CFR 0.152.
 */
package nxt.account;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import nxt.Nxt;
import nxt.NxtException;
import nxt.account.Account;
import nxt.account.BalanceHome;
import nxt.account.HoldingType;
import nxt.account.PaymentAttachment;
import nxt.account.PaymentFxtAttachment;
import nxt.ae.AssetTransferAttachment;
import nxt.blockchain.Attachment;
import nxt.blockchain.Block;
import nxt.blockchain.BlockchainProcessor;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildChain;
import nxt.blockchain.ChildTransaction;
import nxt.blockchain.FxtChain;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionImpl;
import nxt.crypto.Crypto;
import nxt.db.DbIterator;
import nxt.ms.CurrencyTransferAttachment;
import nxt.util.Convert;
import nxt.util.Filter;
import nxt.util.Listener;
import nxt.util.Logger;
import nxt.util.security.BlockchainPermission;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;

public final class FundingMonitor {
    public static final long MIN_FUND_AMOUNT = 1L;
    public static final long MIN_FUND_THRESHOLD = 1L;
    public static final int MIN_FUND_INTERVAL = 10;
    private static final int MAX_MONITORS = Nxt.getIntProperty("nxt.maxNumberOfMonitors");
    private static volatile boolean started = false;
    private static volatile boolean stopped = false;
    private static final List<FundingMonitor> monitors = new ArrayList<FundingMonitor>();
    private static final Map<Long, List<MonitoredAccount>> accounts = new HashMap<Long, List<MonitoredAccount>>();
    private static final Semaphore processSemaphore = new Semaphore(0);
    private static final ConcurrentLinkedQueue<MonitoredAccount> pendingEvents = new ConcurrentLinkedQueue();
    private final HoldingType holdingType;
    private final long holdingId;
    private final Chain chain;
    private final String property;
    private final long amount;
    private final long threshold;
    private final int interval;
    private final long accountId;
    private final String accountName;
    private final String secretPhrase;
    private final byte[] publicKey;
    private final long feeRateNQTPerFXT;

    private FundingMonitor(Chain chain, HoldingType holdingType, long l, String string, long l2, long l3, int n, long l4, String string2, long l5) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("fundingMonitor"));
        }
        this.holdingType = holdingType;
        this.holdingId = l;
        this.chain = chain;
        this.property = string;
        this.amount = l2;
        this.threshold = l3;
        this.interval = n;
        this.accountId = l4;
        this.accountName = Convert.rsAccount(l4);
        this.secretPhrase = string2;
        this.publicKey = Crypto.getPublicKey(string2);
        this.feeRateNQTPerFXT = l5;
        if (holdingType == HoldingType.COIN && l != (long)chain.getId()) {
            throw new IllegalArgumentException("Funding monitor for holding type coin must be run on the chain of the coin.");
        }
        if (holdingType != HoldingType.COIN && l == (long)FxtChain.FXT.getId()) {
            throw new IllegalArgumentException("Only funding monitors for Ardor can be run on the Ardor chain");
        }
    }

    public HoldingType getHoldingType() {
        return this.holdingType;
    }

    public long getHoldingId() {
        return this.holdingId;
    }

    public Chain getChain() {
        return this.chain;
    }

    public String getProperty() {
        return this.property;
    }

    public long getAmount() {
        return this.amount;
    }

    public long getThreshold() {
        return this.threshold;
    }

    public int getInterval() {
        return this.interval;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public long getFeeRateNQTPerFXT() {
        return this.feeRateNQTPerFXT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FundingMonitor startMonitor(Chain chain, HoldingType holdingType, long l, String string, long l2, long l3, int n, String string2, long l4) {
        FundingMonitor.init();
        long l5 = Account.getId(Crypto.getPublicKey(string2));
        FundingMonitor fundingMonitor = new FundingMonitor(chain, holdingType, l, string, l2, l3, n, l5, string2, l4);
        Nxt.getBlockchain().readLock();
        try {
            ArrayList<MonitoredAccount> arrayList = new ArrayList<MonitoredAccount>();
            try (Iterable<Object> iterable = Account.getProperties(0L, l5, string, 0, Integer.MAX_VALUE);){
                while (((DbIterator)iterable).hasNext()) {
                    Account.AccountProperty accountProperty = ((DbIterator)iterable).next();
                    MonitoredAccount monitoredAccount2 = FundingMonitor.createMonitoredAccount(accountProperty.getRecipientId(), fundingMonitor, accountProperty.getValue());
                    arrayList.add(monitoredAccount2);
                }
            }
            iterable = monitors;
            synchronized (iterable) {
                block23: {
                    if (monitors.size() > MAX_MONITORS) {
                        throw new RuntimeException("Maximum of " + MAX_MONITORS + " monitors already started");
                    }
                    if (!monitors.contains(fundingMonitor)) break block23;
                    Logger.logDebugMessage(String.format("%s monitor already started for account %s, property '%s', holding %s, chain %s", holdingType.name(), fundingMonitor.accountName, string, Long.toUnsignedString(l), chain.getName()));
                    var18_13 = null;
                    return var18_13;
                }
                arrayList.forEach(monitoredAccount -> {
                    List list = accounts.computeIfAbsent(((MonitoredAccount)monitoredAccount).accountId, l -> new ArrayList());
                    list.add(monitoredAccount);
                    pendingEvents.add((MonitoredAccount)monitoredAccount);
                    Logger.logDebugMessage(String.format("Created %s monitor for target account %s, property '%s', holding %s, amount %d, threshold %d, interval %d, chain %s", holdingType.name(), ((MonitoredAccount)monitoredAccount).accountName, fundingMonitor.property, Long.toUnsignedString(fundingMonitor.holdingId), ((MonitoredAccount)monitoredAccount).amount, ((MonitoredAccount)monitoredAccount).threshold, ((MonitoredAccount)monitoredAccount).interval, chain.getName()));
                });
                monitors.add(fundingMonitor);
                Logger.logInfoMessage(String.format("%s monitor started for funding account %s, property '%s', holding %s, chain %s", holdingType.name(), fundingMonitor.accountName, fundingMonitor.property, Long.toUnsignedString(fundingMonitor.holdingId), chain.getName()));
            }
        }
        finally {
            Nxt.getBlockchain().readUnlock();
        }
        return fundingMonitor;
    }

    private static MonitoredAccount createMonitoredAccount(long l, FundingMonitor fundingMonitor, String string) {
        long l2 = fundingMonitor.amount;
        long l3 = fundingMonitor.threshold;
        int n = fundingMonitor.interval;
        if (string != null && !string.isEmpty()) {
            try {
                Object object = JSONValue.parseWithException((String)string);
                if (!(object instanceof JSONObject)) {
                    throw new IllegalArgumentException("Property value is not a JSON object");
                }
                JSONObject jSONObject = (JSONObject)object;
                l2 = FundingMonitor.getValue(jSONObject.get((Object)"amount"), l2);
                l3 = FundingMonitor.getValue(jSONObject.get((Object)"threshold"), l3);
                n = (int)FundingMonitor.getValue(jSONObject.get((Object)"interval"), n);
            }
            catch (IllegalArgumentException | ParseException throwable) {
                String string2 = String.format("Account %s, property '%s', value '%s' is not valid", Convert.rsAccount(l), fundingMonitor.property, string);
                throw new IllegalArgumentException(string2, throwable);
            }
        }
        return new MonitoredAccount(l, fundingMonitor, l2, l3, n);
    }

    private static long getValue(Object object, long l) {
        if (object == null) {
            return l;
        }
        return Convert.parseLong(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int stopAllMonitors() {
        int n;
        List<FundingMonitor> list = monitors;
        synchronized (list) {
            n = monitors.size();
            monitors.clear();
            accounts.clear();
        }
        Logger.logInfoMessage("All monitors stopped");
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean stopMonitor(Chain chain, HoldingType holdingType, long l, String string, long l2) {
        FundingMonitor fundingMonitor = null;
        boolean bl = false;
        List<FundingMonitor> list = monitors;
        synchronized (list) {
            Iterator<FundingMonitor> iterator = monitors.iterator();
            while (iterator.hasNext()) {
                fundingMonitor = iterator.next();
                if (fundingMonitor.holdingType != holdingType || !fundingMonitor.property.equals(string) || fundingMonitor.holdingId != l || fundingMonitor.chain != chain || fundingMonitor.accountId != l2) continue;
                iterator.remove();
                bl = true;
                break;
            }
            if (bl) {
                Iterator<List<MonitoredAccount>> iterator2 = accounts.values().iterator();
                block4: while (iterator2.hasNext()) {
                    List<MonitoredAccount> list2 = iterator2.next();
                    Iterator<MonitoredAccount> iterator3 = list2.iterator();
                    while (iterator3.hasNext()) {
                        MonitoredAccount monitoredAccount = iterator3.next();
                        if (monitoredAccount.monitor != fundingMonitor) continue;
                        iterator3.remove();
                        if (!list2.isEmpty()) continue block4;
                        iterator2.remove();
                        continue block4;
                    }
                }
                Logger.logInfoMessage(String.format("%s monitor stopped for fund account %s, property '%s', holding %d, chain %s", holdingType.name(), fundingMonitor.accountName, fundingMonitor.property, fundingMonitor.holdingId, fundingMonitor.chain.getName()));
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FundingMonitor> getMonitors(Filter<FundingMonitor> filter) {
        ArrayList<FundingMonitor> arrayList = new ArrayList<FundingMonitor>();
        List<FundingMonitor> list = monitors;
        synchronized (list) {
            monitors.forEach(fundingMonitor -> {
                if (filter.ok((FundingMonitor)fundingMonitor)) {
                    arrayList.add((FundingMonitor)fundingMonitor);
                }
            });
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FundingMonitor> getAllMonitors() {
        ArrayList<FundingMonitor> arrayList;
        List<FundingMonitor> list = monitors;
        synchronized (list) {
            arrayList = new ArrayList<FundingMonitor>(monitors);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<MonitoredAccount> getMonitoredAccounts(FundingMonitor fundingMonitor) {
        ArrayList<MonitoredAccount> arrayList = new ArrayList<MonitoredAccount>();
        List<FundingMonitor> list = monitors;
        synchronized (list) {
            accounts.values().forEach(list2 -> list2.forEach(monitoredAccount -> {
                if (((MonitoredAccount)monitoredAccount).monitor.equals(fundingMonitor)) {
                    arrayList.add((MonitoredAccount)monitoredAccount);
                }
            }));
        }
        return arrayList;
    }

    private static synchronized void init() {
        if (stopped) {
            throw new RuntimeException("Account monitor processing has been stopped");
        }
        if (started) {
            return;
        }
        try {
            ProcessEvents processEvents = new ProcessEvents();
            processEvents.start();
            BalanceHome.addListener(new BalanceEventHandler(), BalanceHome.Event.BALANCE);
            Account.addAssetListener(new AssetEventHandler(), Account.Event.ASSET_BALANCE);
            Account.addCurrencyListener(new CurrencyEventHandler(), Account.Event.CURRENCY_BALANCE);
            Account.addPropertyListener(new SetPropertyEventHandler(), Account.Event.SET_PROPERTY);
            Account.addPropertyListener(new DeletePropertyEventHandler(), Account.Event.DELETE_PROPERTY);
            Nxt.getBlockchainProcessor().addListener(new BlockEventHandler(), BlockchainProcessor.Event.BLOCK_PUSHED);
            started = true;
            Logger.logDebugMessage("Account monitor initialization completed");
        }
        catch (RuntimeException runtimeException) {
            stopped = true;
            Logger.logErrorMessage("Account monitor initialization failed", runtimeException);
            throw runtimeException;
        }
    }

    public static void shutdown() {
        if (started && !stopped) {
            stopped = true;
            processSemaphore.release();
        }
    }

    public int hashCode() {
        return this.holdingType.hashCode() + (int)this.holdingId + this.property.hashCode() + (int)this.accountId;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof FundingMonitor) {
            FundingMonitor fundingMonitor = (FundingMonitor)object;
            if (this.holdingType == fundingMonitor.holdingType && this.holdingId == fundingMonitor.holdingId && this.chain == fundingMonitor.chain && this.property.equals(fundingMonitor.property) && this.accountId == fundingMonitor.accountId) {
                bl = true;
            }
        }
        return bl;
    }

    private static void processCoinEvent(MonitoredAccount monitoredAccount, Account account, Account account2) throws NxtException {
        FundingMonitor fundingMonitor = monitoredAccount.monitor;
        Chain chain = fundingMonitor.chain;
        BalanceHome balanceHome = chain.getBalanceHome();
        if (balanceHome.getBalance(account.getId()).getBalance() < monitoredAccount.threshold) {
            Attachment.EmptyAttachment emptyAttachment = chain instanceof ChildChain ? PaymentAttachment.INSTANCE : PaymentFxtAttachment.INSTANCE;
            TransactionImpl.BuilderImpl builderImpl = chain.newTransactionBuilder(fundingMonitor.publicKey, monitoredAccount.amount, -1L, (short)15, emptyAttachment);
            builderImpl.recipientId(monitoredAccount.accountId).timestamp(Nxt.getBlockchain().getLastBlockTimestamp());
            if (builderImpl instanceof ChildTransaction.Builder) {
                ((ChildTransaction.Builder)((Object)builderImpl)).feeRateNQTPerFXT(fundingMonitor.feeRateNQTPerFXT);
            }
            Transaction transaction = builderImpl.build(fundingMonitor.secretPhrase);
            if (Math.addExact(monitoredAccount.amount, transaction.getFee()) > balanceHome.getBalance(account2.getId()).getUnconfirmedBalance()) {
                Logger.logWarningMessage(String.format("Funding account %s has insufficient funds; funding transaction discarded", fundingMonitor.accountName));
            } else {
                Nxt.getTransactionProcessor().broadcast(transaction);
                monitoredAccount.height = Nxt.getBlockchain().getHeight();
                Logger.logDebugMessage(String.format("Coin funding transaction %s for %f %s submitted from %s to %s", transaction.getStringId(), (double)monitoredAccount.amount / (double)chain.ONE_COIN, chain.getName(), fundingMonitor.accountName, monitoredAccount.accountName));
            }
        }
    }

    private static void processAssetEvent(MonitoredAccount monitoredAccount, Account account, Account account2) throws NxtException {
        FundingMonitor fundingMonitor = monitoredAccount.monitor;
        Chain chain = fundingMonitor.chain;
        Account.AccountAsset accountAsset = Account.getAccountAsset(account.getId(), fundingMonitor.holdingId);
        Account.AccountAsset accountAsset2 = Account.getAccountAsset(account2.getId(), fundingMonitor.holdingId);
        if (accountAsset2 == null || accountAsset2.getUnconfirmedQuantityQNT() < monitoredAccount.amount) {
            Logger.logWarningMessage(String.format("Funding account %s has insufficient quantity for asset %s; funding transaction discarded", fundingMonitor.accountName, Long.toUnsignedString(fundingMonitor.holdingId)));
        } else if (accountAsset == null || accountAsset.getQuantityQNT() < monitoredAccount.threshold) {
            Transaction transaction;
            AssetTransferAttachment assetTransferAttachment = new AssetTransferAttachment(fundingMonitor.holdingId, monitoredAccount.amount);
            TransactionImpl.BuilderImpl builderImpl = chain.newTransactionBuilder(fundingMonitor.publicKey, 0L, -1L, (short)15, assetTransferAttachment);
            builderImpl.recipientId(monitoredAccount.accountId).timestamp(Nxt.getBlockchain().getLastBlockTimestamp());
            if (builderImpl instanceof ChildTransaction.Builder) {
                ((ChildTransaction.Builder)((Object)builderImpl)).feeRateNQTPerFXT(fundingMonitor.feeRateNQTPerFXT);
            }
            if ((transaction = builderImpl.build(fundingMonitor.secretPhrase)).getFee() > chain.getBalanceHome().getBalance(account2.getId()).getUnconfirmedBalance()) {
                Logger.logWarningMessage(String.format("Funding account %s has insufficient funds on chain %s; funding transaction discarded", fundingMonitor.accountName, chain.getName()));
            } else {
                Nxt.getTransactionProcessor().broadcast(transaction);
                monitoredAccount.height = Nxt.getBlockchain().getHeight();
                Logger.logDebugMessage(String.format("ASSET funding transaction %s submitted for %d units from %s to %s on chain %s", transaction.getStringId(), monitoredAccount.amount, fundingMonitor.accountName, monitoredAccount.accountName, chain.getName()));
            }
        }
    }

    private static void processCurrencyEvent(MonitoredAccount monitoredAccount, Account account, Account account2) throws NxtException {
        FundingMonitor fundingMonitor = monitoredAccount.monitor;
        Chain chain = fundingMonitor.chain;
        Account.AccountCurrency accountCurrency = Account.getAccountCurrency(account.getId(), fundingMonitor.holdingId);
        Account.AccountCurrency accountCurrency2 = Account.getAccountCurrency(account2.getId(), fundingMonitor.holdingId);
        if (accountCurrency2 == null || accountCurrency2.getUnconfirmedUnits() < monitoredAccount.amount) {
            Logger.logWarningMessage(String.format("Funding account %s has insufficient quantity for currency %s; funding transaction discarded", fundingMonitor.accountName, Long.toUnsignedString(fundingMonitor.holdingId)));
        } else if (accountCurrency == null || accountCurrency.getUnits() < monitoredAccount.threshold) {
            Transaction transaction;
            CurrencyTransferAttachment currencyTransferAttachment = new CurrencyTransferAttachment(fundingMonitor.holdingId, monitoredAccount.amount);
            TransactionImpl.BuilderImpl builderImpl = chain.newTransactionBuilder(fundingMonitor.publicKey, 0L, -1L, (short)15, currencyTransferAttachment);
            builderImpl.recipientId(monitoredAccount.accountId).timestamp(Nxt.getBlockchain().getLastBlockTimestamp());
            if (builderImpl instanceof ChildTransaction.Builder) {
                ((ChildTransaction.Builder)((Object)builderImpl)).feeRateNQTPerFXT(fundingMonitor.feeRateNQTPerFXT);
            }
            if ((transaction = builderImpl.build(fundingMonitor.secretPhrase)).getFee() > chain.getBalanceHome().getBalance(account2.getId()).getUnconfirmedBalance()) {
                Logger.logWarningMessage(String.format("Funding account %s has insufficient funds on chain %s; funding transaction discarded", fundingMonitor.accountName, chain.getName()));
            } else {
                Nxt.getTransactionProcessor().broadcast(transaction);
                monitoredAccount.height = Nxt.getBlockchain().getHeight();
                Logger.logDebugMessage(String.format("CURRENCY funding transaction %s submitted for %d units from %s to %s on chain %s", transaction.getStringId(), monitoredAccount.amount, fundingMonitor.accountName, monitoredAccount.accountName, chain.getName()));
            }
        }
    }

    private static final class BlockEventHandler
    implements Listener<Block> {
        private BlockEventHandler() {
        }

        @Override
        public void notify(Block block) {
            if (!stopped && !pendingEvents.isEmpty()) {
                processSemaphore.release();
            }
        }
    }

    private static final class DeletePropertyEventHandler
    implements Listener<Account.AccountProperty> {
        private DeletePropertyEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notify(Account.AccountProperty accountProperty) {
            if (stopped) {
                return;
            }
            long l = accountProperty.getRecipientId();
            List list = monitors;
            synchronized (list) {
                List list2 = (List)accounts.get(l);
                if (list2 != null) {
                    Iterator iterator = list2.iterator();
                    while (iterator.hasNext()) {
                        MonitoredAccount monitoredAccount = (MonitoredAccount)iterator.next();
                        if (!monitoredAccount.monitor.property.equals(accountProperty.getProperty())) continue;
                        iterator.remove();
                        Logger.logDebugMessage(String.format("Deleted %s monitor for account %s, property '%s', holding %s", monitoredAccount.monitor.holdingType.name(), monitoredAccount.accountName, accountProperty.getProperty(), Long.toUnsignedString(monitoredAccount.monitor.holdingId)));
                    }
                    if (list2.isEmpty()) {
                        accounts.remove(l);
                    }
                }
            }
        }
    }

    private static final class SetPropertyEventHandler
    implements Listener<Account.AccountProperty> {
        private SetPropertyEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notify(Account.AccountProperty accountProperty) {
            if (stopped) {
                return;
            }
            long l2 = accountProperty.getRecipientId();
            try {
                boolean bl = true;
                List list = monitors;
                synchronized (list) {
                    MonitoredAccount monitoredAccount;
                    List list2 = (List)accounts.get(l2);
                    if (list2 != null) {
                        for (Object object : list2) {
                            if (!((MonitoredAccount)object).monitor.property.equals(accountProperty.getProperty())) continue;
                            bl = false;
                            monitoredAccount = FundingMonitor.createMonitoredAccount(l2, ((MonitoredAccount)object).monitor, accountProperty.getValue());
                            ((MonitoredAccount)object).amount = monitoredAccount.amount;
                            ((MonitoredAccount)object).threshold = monitoredAccount.threshold;
                            ((MonitoredAccount)object).interval = monitoredAccount.interval;
                            pendingEvents.add(object);
                            Logger.logDebugMessage(String.format("Updated %s monitor for account %s, property '%s', holding %s, amount %d, threshold %d, interval %d", ((MonitoredAccount)object).monitor.holdingType.name(), ((MonitoredAccount)object).accountName, accountProperty.getProperty(), Long.toUnsignedString(((MonitoredAccount)object).monitor.holdingId), ((MonitoredAccount)object).amount, ((MonitoredAccount)object).threshold, ((MonitoredAccount)object).interval));
                        }
                    }
                    if (bl) {
                        for (Object object : monitors) {
                            if (!((FundingMonitor)object).property.equals(accountProperty.getProperty())) continue;
                            monitoredAccount = FundingMonitor.createMonitoredAccount(l2, (FundingMonitor)object, accountProperty.getValue());
                            list2 = accounts.computeIfAbsent(l2, l -> new ArrayList());
                            list2.add(monitoredAccount);
                            pendingEvents.add(monitoredAccount);
                            Logger.logDebugMessage(String.format("Created %s monitor for account %s, property '%s', holding %s, amount %d, threshold %d, interval %d", ((FundingMonitor)object).holdingType.name(), monitoredAccount.accountName, accountProperty.getProperty(), Long.toUnsignedString(((FundingMonitor)object).holdingId), monitoredAccount.amount, monitoredAccount.threshold, monitoredAccount.interval));
                        }
                    }
                }
            }
            catch (Exception exception) {
                Logger.logErrorMessage("Unable to process SET_PROPERTY event for account " + Convert.rsAccount(l2), exception);
            }
        }
    }

    private static final class CurrencyEventHandler
    implements Listener<Account.AccountCurrency> {
        private CurrencyEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notify(Account.AccountCurrency accountCurrency) {
            if (stopped) {
                return;
            }
            long l = accountCurrency.getUnits();
            long l2 = accountCurrency.getCurrencyId();
            List list = monitors;
            synchronized (list) {
                List list2 = (List)accounts.get(accountCurrency.getAccountId());
                if (list2 != null) {
                    list2.forEach(monitoredAccount -> {
                        if (((MonitoredAccount)monitoredAccount).monitor.holdingType == HoldingType.CURRENCY && ((MonitoredAccount)monitoredAccount).monitor.holdingId == l2 && l < ((MonitoredAccount)monitoredAccount).threshold && !pendingEvents.contains(monitoredAccount)) {
                            pendingEvents.add(monitoredAccount);
                        }
                    });
                }
            }
        }
    }

    private static final class AssetEventHandler
    implements Listener<Account.AccountAsset> {
        private AssetEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notify(Account.AccountAsset accountAsset) {
            if (stopped) {
                return;
            }
            long l = accountAsset.getQuantityQNT();
            long l2 = accountAsset.getAssetId();
            List list = monitors;
            synchronized (list) {
                List list2 = (List)accounts.get(accountAsset.getAccountId());
                if (list2 != null) {
                    list2.forEach(monitoredAccount -> {
                        if (((MonitoredAccount)monitoredAccount).monitor.holdingType == HoldingType.ASSET && ((MonitoredAccount)monitoredAccount).monitor.holdingId == l2 && l < ((MonitoredAccount)monitoredAccount).threshold && !pendingEvents.contains(monitoredAccount)) {
                            pendingEvents.add(monitoredAccount);
                        }
                    });
                }
            }
        }
    }

    private static final class BalanceEventHandler
    implements Listener<BalanceHome.Balance> {
        private BalanceEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notify(BalanceHome.Balance balance) {
            if (stopped) {
                return;
            }
            List list = monitors;
            synchronized (list) {
                List list2 = (List)accounts.get(balance.getAccountId());
                if (list2 != null) {
                    list2.forEach(monitoredAccount -> {
                        if (((MonitoredAccount)monitoredAccount).monitor.holdingType == HoldingType.COIN && ((MonitoredAccount)monitoredAccount).monitor.holdingId == (long)balance.getChain().getId() && balance.getBalance() < ((MonitoredAccount)monitoredAccount).threshold && !pendingEvents.contains(monitoredAccount)) {
                            pendingEvents.add(monitoredAccount);
                        }
                    });
                }
            }
        }
    }

    public static final class MonitoredAccount {
        private final long accountId;
        private final String accountName;
        private final FundingMonitor monitor;
        private long amount;
        private long threshold;
        private int interval;
        private int height;

        private MonitoredAccount(long l, FundingMonitor fundingMonitor, long l2, long l3, int n) {
            if (l2 < 1L) {
                throw new IllegalArgumentException("Minimum fund amount is 1");
            }
            if (l3 < 1L) {
                throw new IllegalArgumentException("Minimum fund threshold is 1");
            }
            if (n < 10) {
                throw new IllegalArgumentException("Minimum fund interval is 10");
            }
            this.accountId = l;
            this.accountName = Convert.rsAccount(l);
            this.monitor = fundingMonitor;
            this.amount = l2;
            this.threshold = l3;
            this.interval = n;
        }

        public long getAccountId() {
            return this.accountId;
        }

        public String getAccountName() {
            return this.accountName;
        }

        public long getAmount() {
            return this.amount;
        }

        public long getThreshold() {
            return this.threshold;
        }

        public int getInterval() {
            return this.interval;
        }
    }

    private static class ProcessEvents
    extends Thread {
        private ProcessEvents() {
        }

        @Override
        public void run() {
            Logger.logDebugMessage("Account monitor thread started");
            ArrayList<MonitoredAccount> arrayList = new ArrayList<MonitoredAccount>();
            try {
                while (true) {
                    MonitoredAccount monitoredAccount;
                    processSemaphore.acquire();
                    if (stopped) {
                        Logger.logDebugMessage("Account monitor thread stopped");
                        break;
                    }
                    while ((monitoredAccount = (MonitoredAccount)pendingEvents.poll()) != null) {
                        try {
                            Account account = Account.getAccount(monitoredAccount.accountId);
                            Account account2 = Account.getAccount(monitoredAccount.monitor.accountId);
                            if (Nxt.getBlockchain().getHeight() - monitoredAccount.height < monitoredAccount.interval) {
                                if (arrayList.contains(monitoredAccount)) continue;
                                arrayList.add(monitoredAccount);
                                continue;
                            }
                            if (account == null) {
                                Logger.logErrorMessage(String.format("Monitored account %s no longer exists", monitoredAccount.accountName));
                                continue;
                            }
                            if (account2 == null) {
                                Logger.logErrorMessage(String.format("Funding account %s no longer exists", monitoredAccount.monitor.accountName));
                                continue;
                            }
                            switch (monitoredAccount.monitor.holdingType) {
                                case COIN: {
                                    FundingMonitor.processCoinEvent(monitoredAccount, account, account2);
                                    break;
                                }
                                case ASSET: {
                                    FundingMonitor.processAssetEvent(monitoredAccount, account, account2);
                                    break;
                                }
                                case CURRENCY: {
                                    FundingMonitor.processCurrencyEvent(monitoredAccount, account, account2);
                                }
                            }
                        }
                        catch (Exception exception) {
                            Logger.logErrorMessage(String.format("Unable to process %s event for account %s, property '%s', holding %s", monitoredAccount.monitor.holdingType.name(), monitoredAccount.accountName, monitoredAccount.monitor.property, Long.toUnsignedString(monitoredAccount.monitor.holdingId)), exception);
                        }
                    }
                    if (arrayList.isEmpty()) continue;
                    pendingEvents.addAll(arrayList);
                    arrayList.clear();
                }
            }
            catch (InterruptedException interruptedException) {
                Logger.logDebugMessage("Account monitor thread interrupted");
            }
            catch (Throwable throwable) {
                Logger.logErrorMessage("Account monitor thread terminated", throwable);
            }
        }
    }
}

