/*
 * Decompiled with CFR 0.152.
 */
package nxt.account;

import java.nio.ByteBuffer;
import nxt.NxtException;
import nxt.account.Account;
import nxt.account.AccountLedger;
import nxt.account.PaymentFxtAttachment;
import nxt.blockchain.Attachment;
import nxt.blockchain.FxtTransactionImpl;
import nxt.blockchain.FxtTransactionType;
import nxt.blockchain.TransactionType;
import org.json.simple.JSONObject;

public abstract class PaymentFxtTransactionType
extends FxtTransactionType {
    public static final TransactionType ORDINARY = new PaymentFxtTransactionType(){

        @Override
        public final byte getSubtype() {
            return 0;
        }

        @Override
        public final AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.FXT_PAYMENT;
        }

        @Override
        public String getName() {
            return "FxtPayment";
        }

        @Override
        public Attachment.EmptyAttachment parseAttachment(ByteBuffer byteBuffer) {
            return PaymentFxtAttachment.INSTANCE;
        }

        @Override
        public Attachment.EmptyAttachment parseAttachment(JSONObject jSONObject) {
            return PaymentFxtAttachment.INSTANCE;
        }

        @Override
        protected void validateAttachment(FxtTransactionImpl fxtTransactionImpl) throws NxtException.ValidationException {
            if (fxtTransactionImpl.getAmount() <= 0L || fxtTransactionImpl.getAmount() >= 100000000000000000L) {
                throw new NxtException.NotValidException("Invalid ordinary payment");
            }
        }
    };

    private PaymentFxtTransactionType() {
    }

    @Override
    public final byte getType() {
        return -2;
    }

    @Override
    protected final boolean applyAttachmentUnconfirmed(FxtTransactionImpl fxtTransactionImpl, Account account) {
        return true;
    }

    @Override
    protected final void applyAttachment(FxtTransactionImpl fxtTransactionImpl, Account account, Account account2) {
    }

    @Override
    protected final void undoAttachmentUnconfirmed(FxtTransactionImpl fxtTransactionImpl, Account account) {
    }

    @Override
    public final boolean canHaveRecipient() {
        return true;
    }
}

