/*
 * Decompiled with CFR 0.152.
 */
package nxt.account;

import java.util.Arrays;
import nxt.Nxt;
import nxt.account.Account;
import nxt.crypto.Crypto;
import nxt.util.Convert;

public final class Token {
    private final byte[] publicKey;
    private final int timestamp;
    private final boolean isValid;

    public static String generateToken(String string, String string2) {
        return Token.generateToken(string, Convert.toBytes(string2));
    }

    public static String generateToken(String string, byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + 32 + 4];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        System.arraycopy(Crypto.getPublicKey(string), 0, byArray2, byArray.length, 32);
        int n = Nxt.getEpochTime();
        byArray2[byArray.length + 32] = (byte)n;
        byArray2[byArray.length + 32 + 1] = (byte)(n >> 8);
        byArray2[byArray.length + 32 + 2] = (byte)(n >> 16);
        byArray2[byArray.length + 32 + 3] = (byte)(n >> 24);
        byte[] byArray3 = new byte[100];
        System.arraycopy(byArray2, byArray.length, byArray3, 0, 36);
        System.arraycopy(Crypto.sign(byArray2, string), 0, byArray3, 36, 64);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 100; i += 5) {
            long l = (long)(byArray3[i] & 0xFF) | (long)(byArray3[i + 1] & 0xFF) << 8 | (long)(byArray3[i + 2] & 0xFF) << 16 | (long)(byArray3[i + 3] & 0xFF) << 24 | (long)(byArray3[i + 4] & 0xFF) << 32;
            if (l < 32L) {
                stringBuilder.append("0000000");
            } else if (l < 1024L) {
                stringBuilder.append("000000");
            } else if (l < 32768L) {
                stringBuilder.append("00000");
            } else if (l < 0x100000L) {
                stringBuilder.append("0000");
            } else if (l < 0x2000000L) {
                stringBuilder.append("000");
            } else if (l < 0x40000000L) {
                stringBuilder.append("00");
            } else if (l < 0x800000000L) {
                stringBuilder.append("0");
            }
            stringBuilder.append(Long.toString(l, 32));
        }
        return stringBuilder.toString();
    }

    public static Token parseToken(String string, String string2) {
        return Token.parseToken(string, Convert.toBytes(string2));
    }

    public static Token parseToken(String string, byte[] byArray) {
        byte[] byArray2 = new byte[100];
        int n = 0;
        int n2 = 0;
        while (n < string.length()) {
            long l = Long.parseLong(string.substring(n, n + 8), 32);
            byArray2[n2] = (byte)l;
            byArray2[n2 + 1] = (byte)(l >> 8);
            byArray2[n2 + 2] = (byte)(l >> 16);
            byArray2[n2 + 3] = (byte)(l >> 24);
            byArray2[n2 + 4] = (byte)(l >> 32);
            n += 8;
            n2 += 5;
        }
        if (n != 160) {
            throw new IllegalArgumentException(String.format("Invalid token length %d, token must be composed of 160 characters hex string", n));
        }
        byte[] byArray3 = new byte[32];
        System.arraycopy(byArray2, 0, byArray3, 0, 32);
        int n3 = byArray2[32] & 0xFF | (byArray2[33] & 0xFF) << 8 | (byArray2[34] & 0xFF) << 16 | (byArray2[35] & 0xFF) << 24;
        byte[] byArray4 = new byte[64];
        System.arraycopy(byArray2, 36, byArray4, 0, 64);
        byte[] byArray5 = new byte[byArray.length + 36];
        System.arraycopy(byArray, 0, byArray5, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray5, byArray.length, 36);
        byte[] byArray6 = Account.getPublicKey(Account.getId(byArray3));
        boolean bl = Crypto.verify(byArray4, byArray5, byArray3) && (byArray6 == null || Arrays.equals(byArray3, byArray6));
        return new Token(byArray3, n3, bl);
    }

    private Token(byte[] byArray, int n, boolean bl) {
        this.publicKey = byArray;
        this.timestamp = n;
        this.isValid = bl;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public boolean isValid() {
        return this.isValid;
    }
}

