/*
 * Decompiled with CFR 0.152.
 */
package nxt.addons;

import java.security.AccessController;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nxt.Constants;
import nxt.Nxt;
import nxt.addons.AddOn;
import nxt.env.RuntimeEnvironment;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.util.Logger;
import nxt.util.security.BlockchainSecurityProvider;

public final class AddOns {
    private static final List<AddOn> addOns;

    public static void init() {
    }

    public static void shutdown() {
        addOns.forEach(addOn -> {
            Logger.logShutdownMessage("Shutting down " + addOn.getClass().getName());
            addOn.shutdown();
        });
    }

    public static void registerAPIRequestHandlers(Map<String, APIServlet.APIRequestHandler> map) {
        for (AddOn addOn : addOns) {
            Map<String, APIServlet.APIRequestHandler> map2 = addOn.getAPIRequests();
            APIServlet.APIRequestHandler aPIRequestHandler = addOn.getAPIRequestHandler();
            String string = addOn.getAPIRequestType();
            if (aPIRequestHandler != null && string != null) {
                if (map2 == null) {
                    map2 = new HashMap<String, APIServlet.APIRequestHandler>();
                }
                map2.put(string, aPIRequestHandler);
            }
            if (map2 == null) continue;
            for (Map.Entry<String, APIServlet.APIRequestHandler> entry : map2.entrySet()) {
                aPIRequestHandler = entry.getValue();
                if (!aPIRequestHandler.getAPITags().contains((Object)APITag.ADDONS)) {
                    Logger.logErrorMessage("Add-on " + addOn.getClass().getName() + " attempted to register request handler which is not tagged as APITag.ADDONS, skipping");
                    continue;
                }
                String string2 = entry.getKey();
                if (string2 == null) {
                    Logger.logErrorMessage("Add-on " + addOn.getClass().getName() + " requestType not defined");
                    continue;
                }
                if (map.get(string2) != null) {
                    Logger.logErrorMessage("Add-on " + addOn.getClass().getName() + " attempted to override requestType " + string2 + ", skipping");
                    continue;
                }
                Logger.logMessage("Add-on " + addOn.getClass().getName() + " registered new API: " + string2);
                map.put(string2, aPIRequestHandler);
            }
        }
    }

    public static AddOn getAddOn(Class<? extends AddOn> clazz) {
        return addOns.stream().filter(clazz::isInstance).findFirst().orElse(null);
    }

    private AddOns() {
    }

    static {
        ArrayList arrayList = new ArrayList();
        Nxt.getStringListProperty("nxt.addOns").forEach(string -> {
            try {
                if (string.indexOf(46) == -1) {
                    string = "nxt.addons." + string;
                }
                arrayList.add((AddOn)Class.forName(string).getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                Logger.logErrorMessage(reflectiveOperationException.getMessage(), reflectiveOperationException);
            }
        });
        addOns = Collections.unmodifiableList(arrayList);
        if (!addOns.isEmpty() && !Nxt.getBooleanProperty("nxt.disableSecurityPolicy")) {
            Logger.logMessage("Creating Jelurida security provider");
            BlockchainSecurityProvider blockchainSecurityProvider = new BlockchainSecurityProvider();
            Security.addProvider(blockchainSecurityProvider);
            if (System.getProperty("java.security.policy") == null) {
                System.setProperty("java.security.policy", RuntimeEnvironment.isDesktopApplicationEnabled() ? "ardordesktop.policy" : "ardor.policy");
            }
            Logger.logMessage("Setting security manager with policy " + System.getProperty("java.security.policy"));
            System.setSecurityManager(new SecurityManager(){

                @Override
                public void checkConnect(String string, int n) {
                }

                @Override
                public void checkConnect(String string, int n, Object object) {
                }
            });
        }
        addOns.forEach(addOn -> {
            Logger.logInfoMessage("Initializing " + addOn.getClass().getName());
            try {
                if (Constants.isAutomatedTest) {
                    AccessController.doPrivileged(() -> {
                        addOn.init();
                        return null;
                    });
                } else {
                    addOn.init();
                }
            }
            catch (Throwable throwable) {
                Logger.logErrorMessage("Initialization failed for addOn " + addOn.getClass().getName(), throwable);
            }
        });
    }
}

