/*
 * Decompiled with CFR 0.152.
 */
package nxt.addons;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.security.Security;
import java.security.SignatureException;
import java.security.Timestamp;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.jar.JarInputStream;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import nxt.Nxt;
import nxt.addons.AbstractContract;
import nxt.addons.BlockContext;
import nxt.addons.Contract;
import nxt.addons.ContractAndSetupParameters;
import nxt.addons.ContractParametersProvider;
import nxt.addons.JO;
import nxt.addons.RequestContext;
import nxt.addons.TransactionContext;
import nxt.blockchain.Chain;
import nxt.blockchain.ChainTransactionId;
import nxt.blockchain.ChildChain;
import nxt.blockchain.Transaction;
import nxt.crypto.Crypto;
import nxt.lightcontracts.ContractReference;
import nxt.taggeddata.TaggedDataAttachment;
import nxt.taggeddata.TaggedDataHome;
import nxt.taggeddata.TaggedDataTransactionType;
import nxt.util.Convert;
import nxt.util.Logger;
import nxt.util.security.BlockchainCertPathParameters;
import nxt.util.security.BlockchainCertificate;
import nxt.util.security.BlockchainPublicKey;
import nxt.util.security.TransactionPrincipal;

public class ContractLoader {
    private static URL codeSourceUrl;
    private static final NullContract NULL_CONTRACT;
    public static final String CLASS_FILE_MIME_TYPE = "application/java-vm";
    public static final String JAR_FILE_MIME_TYPE = "application/java-archive";

    static void loadContract(ContractReference contractReference, Map<String, ContractAndSetupParameters> map, Map<String, ContractReference> map2) {
        ContractAndSetupParameters contractAndSetupParameters = ContractLoader.loadContractAndSetupParameters(contractReference);
        if (contractAndSetupParameters.getContract() != NULL_CONTRACT) {
            map.put(contractReference.getContractName(), contractAndSetupParameters);
            map2.put(contractReference.getContractName(), contractReference);
        }
    }

    public static ContractAndSetupParameters loadContractAndSetupParameters(ContractReference contractReference) {
        ChainTransactionId chainTransactionId = contractReference.getContractId();
        JO jO = ContractLoader.getContractSetupParams(contractReference);
        Contract contract = ContractLoader.loadContract(chainTransactionId);
        return new ContractAndSetupParameters(contract, jO);
    }

    private static Contract loadContract(ChainTransactionId chainTransactionId) {
        String string;
        Chain chain = chainTransactionId.getChain();
        if (!(chain instanceof ChildChain)) {
            throw new IllegalArgumentException(String.format("Cannot load contract, chain %s is not a child chain", chain));
        }
        ChildChain childChain = (ChildChain)chain;
        TaggedDataHome taggedDataHome = childChain.getTaggedDataHome();
        byte[] byArray = chainTransactionId.getFullHash();
        TaggedDataHome.TaggedData taggedData = taggedDataHome.getData(byArray);
        Transaction transaction = Nxt.getBlockchain().getTransaction(chain, byArray);
        if (taggedData == null) {
            if (transaction != null && transaction.getType() != TaggedDataTransactionType.TAGGED_DATA_UPLOAD) {
                Logger.logInfoMessage(String.format("Cannot load contract, referenced transaction of type %s is not a tagged data transaction", transaction.getType()));
                return NULL_CONTRACT;
            }
            try {
                transaction = Nxt.getBlockchainProcessor().restorePrunedTransaction(childChain, byArray);
                if (transaction == null) {
                    Logger.logInfoMessage(String.format("Cannot load contract, contract %d:%s was pruned and cannot be restored", chain.getId(), Convert.toHexString(byArray)));
                    return NULL_CONTRACT;
                }
                taggedData = taggedDataHome.getData(byArray);
                if (taggedData == null) {
                    Logger.logInfoMessage(String.format("Cannot load contract, tagged data %d:%s restored but is still unavailable (should never happen)", chain.getId(), Convert.toHexString(byArray)));
                    return NULL_CONTRACT;
                }
            }
            catch (Exception exception) {
                Logger.logInfoMessage(String.format("Cannot load contract, contract %d:%s was never deployed or has been pruned, %s", chain.getId(), Convert.toHexString(byArray), exception.getMessage()));
                return NULL_CONTRACT;
            }
        }
        if ((string = taggedData.getName()) == null) {
            throw new IllegalArgumentException(String.format("Tagged data transaction does not specify contract class name, chain %s full hash %s", chain.getName(), Convert.toHexString(byArray)));
        }
        byte[] byArray2 = taggedData.getData();
        if (byArray2 == null) {
            throw new IllegalArgumentException(String.format("Tagged data transaction does not store contract class data, chain %s full hash %s", chain.getName(), Convert.toHexString(byArray)));
        }
        CodeSigner[] codeSignerArray = null;
        if (System.getSecurityManager() != null) {
            codeSignerArray = ContractLoader.getCodeSigners(transaction);
        }
        Principal[] principalArray = new Principal[]{new TransactionPrincipal(Convert.toHexString(transaction.getFullHash())), new TransactionPrincipal(Convert.toHexString(((TaggedDataAttachment)transaction.getAttachment()).getHash())), new TransactionPrincipal(Convert.toHexString(Crypto.sha256().digest(byArray2)))};
        switch (taggedData.getType()) {
            case "application/java-vm": {
                return ContractLoader.loadContract(string, byArray2, codeSignerArray, principalArray);
            }
            case "application/java-archive": {
                return ContractLoader.loadContractFromJar(string, byArray2, codeSignerArray, principalArray);
            }
        }
        throw new IllegalArgumentException(String.format("Tagged data mime type %s does not represent an executable contract, chain %s full hash %s", taggedData.getType(), chain.getName(), Convert.toHexString(byArray)));
    }

    private static CodeSigner[] getCodeSigners(Transaction transaction) {
        CodeSigner[] codeSignerArray = new CodeSigner[1];
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("Blockchain", Security.getProvider("Jelurida"));
            Certificate certificate = certificateFactory.generateCertificate(new ByteArrayInputStream(transaction.getBytes()));
            try {
                certificate.verify(new BlockchainPublicKey(transaction.getSenderPublicKey()));
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException generalSecurityException) {
                throw new IllegalStateException(generalSecurityException);
            }
            CertPathBuilder certPathBuilder = CertPathBuilder.getInstance("Blockchain", "Jelurida");
            BlockchainCertPathParameters blockchainCertPathParameters = new BlockchainCertPathParameters((BlockchainCertificate)certificate);
            CertPathBuilderResult certPathBuilderResult = certPathBuilder.build(blockchainCertPathParameters);
            Timestamp timestamp = new Timestamp(new Date(Convert.fromEpochTime(transaction.getTimestamp())), certPathBuilderResult.getCertPath());
            codeSignerArray[0] = new CodeSigner(certPathBuilderResult.getCertPath(), timestamp);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException | CertPathBuilderException | CertificateException generalSecurityException) {
            throw new IllegalArgumentException("Cannot create code signer", generalSecurityException);
        }
        return codeSignerArray;
    }

    private static Contract loadContract(String string, byte[] byArray, CodeSigner[] codeSignerArray, Principal[] principalArray) {
        return AccessController.doPrivileged(() -> {
            CloudDataClassLoader cloudDataClassLoader = new CloudDataClassLoader();
            return ContractLoader.loadContract(cloudDataClassLoader, string, byArray, codeSignerArray, principalArray);
        });
    }

    private static Contract loadContractFromJar(String string, byte[] byArray, CodeSigner[] codeSignerArray, Principal[] principalArray) {
        return AccessController.doPrivileged(() -> {
            CloudDataClassLoader cloudDataClassLoader = new CloudDataClassLoader();
            return ContractLoader.loadContractFromJar(cloudDataClassLoader, string, byArray, codeSignerArray, principalArray);
        });
    }

    public static Contract loadContract(ClassLoader classLoader, String string, byte[] byArray, CodeSigner[] codeSignerArray, Principal[] principalArray) {
        Object obj;
        Class<?> clazz;
        Object object;
        ProtectionDomain protectionDomain = new ProtectionDomain(new CodeSource(codeSourceUrl, codeSignerArray), null, classLoader, principalArray);
        try {
            object = (CloudDataClassLoader)classLoader;
            ((CloudDataClassLoader)object).setProtectionDomain(protectionDomain);
            ((CloudDataClassLoader)object).setClassBytes(byArray);
            clazz = ((CloudDataClassLoader)object).findClass(string);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            obj = constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoClassDefFoundError | NoSuchMethodException | InvocationTargetException throwable) {
            Logger.logErrorMessage(String.format("Error loading contract %s - %s", string, throwable.getMessage()), throwable);
            return NULL_CONTRACT;
        }
        if (!(obj instanceof Contract)) {
            throw new IllegalArgumentException("Class " + clazz.getCanonicalName() + " not of type " + Contract.class.getCanonicalName());
        }
        object = ((Contract)obj).minProductVersion();
        if (ContractLoader.compareVersions((String)object, "2.2.6") > 0) {
            throw new IllegalArgumentException(String.format("Class " + clazz.getCanonicalName() + " minimum version %s higher than existing product version %s", object, "2.2.6"));
        }
        return (Contract)obj;
    }

    public static Contract loadContractFromJar(ClassLoader classLoader, String string, byte[] byArray, CodeSigner[] codeSignerArray, Principal[] principalArray) {
        return ContractLoader.loadContractFromJar(classLoader, string, byArray, codeSignerArray, principalArray, null);
    }

    public static Contract loadContractFromJar(ClassLoader classLoader, String string2, byte[] byArray, CodeSigner[] codeSignerArray, Principal[] principalArray, Map<String, byte[]> map) {
        if (map == null) {
            map = new HashMap<String, byte[]>();
        }
        try {
            Object object;
            String string3;
            Object object2;
            Object object3 = new JarInputStream(new ByteArrayInputStream(byArray));
            Object object4 = null;
            try {
                Object object5;
                while ((object5 = ((JarInputStream)object3).getNextJarEntry()) != null) {
                    int n = (int)((ZipEntry)object5).getSize();
                    object2 = new byte[n > 0 ? n : 1024];
                    int n2 = 0;
                    int n3 = ((FilterInputStream)object3).read((byte[])object2);
                    while (n3 > 0) {
                        if (((byte[])object2).length == (n2 += n3)) {
                            object2 = Arrays.copyOf((byte[])object2, ((byte[])object2).length * 2);
                        }
                        n3 = ((JarInputStream)object3).read((byte[])object2, n2, ((byte[])object2).length - n2);
                    }
                    if (n2 != ((byte[])object2).length) {
                        object2 = Arrays.copyOf((byte[])object2, n2);
                    }
                    if (!(string3 = (object = ((ZipEntry)object5).getName().split("/"))[((String[])object).length - 1]).endsWith(".class")) continue;
                    String string4 = Arrays.stream(object).filter(string -> !string.endsWith(".class")).map(String::toLowerCase).collect(Collectors.joining("."));
                    String string5 = string4 + "." + string3.split("[.]")[0];
                    map.put(string5, (byte[])object2);
                }
            }
            catch (Throwable throwable) {
                object4 = throwable;
                throw throwable;
            }
            finally {
                if (object3 != null) {
                    if (object4 != null) {
                        try {
                            ((ZipInputStream)object3).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object4).addSuppressed(throwable);
                        }
                    } else {
                        ((ZipInputStream)object3).close();
                    }
                }
            }
            object3 = new ProtectionDomain(new CodeSource(codeSourceUrl, codeSignerArray), null, classLoader, principalArray);
            object4 = null;
            for (String string6 : map.keySet()) {
                object2 = (CloudDataClassLoader)classLoader;
                ((CloudDataClassLoader)object2).setProtectionDomain((ProtectionDomain)object3);
                ((CloudDataClassLoader)object2).setClassBytes(map.get(string6));
                Class<?> clazz = ((CloudDataClassLoader)object2).findClass(string6);
                if (!clazz.getName().equals(string2) || !((string3 = ((Constructor)(object = clazz.getConstructor(new Class[0]))).newInstance(new Object[0])) instanceof Contract)) continue;
                object4 = (Contract)((Object)string3);
            }
            if (object4 == null) {
                throw new IllegalStateException("Contract " + string2 + " not found in contract Jar file");
            }
            return object4;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    static JO getContractSetupParams(ContractReference contractReference) {
        String string = contractReference.getContractParams();
        if (string != null && string.length() > 0) {
            return JO.parse(string);
        }
        return new JO();
    }

    public static Class<?> getParametersProvider(Contract contract) {
        Class<?>[] classArray = contract.getClass().getDeclaredClasses();
        return Arrays.stream(classArray).filter(clazz -> clazz.getAnnotation(ContractParametersProvider.class) != null).findFirst().orElse(null);
    }

    public static int compareVersions(String string, String string2) {
        Scanner scanner = new Scanner(string);
        scanner.useDelimiter("\\.");
        Scanner scanner2 = new Scanner(string2);
        scanner2.useDelimiter("\\.");
        while (scanner.hasNext() && scanner2.hasNext()) {
            int n;
            int n2;
            String string3 = scanner.next();
            if (string3.endsWith("e")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            int n3 = Integer.parseInt(string3);
            String string4 = scanner2.next();
            if (string4.endsWith("e")) {
                string4 = string4.substring(0, string4.length() - 1);
            }
            if ((n2 = Integer.compare(n3, n = Integer.parseInt(string4))) == 0) continue;
            return n2;
        }
        if (scanner.hasNext()) {
            return 1;
        }
        if (scanner2.hasNext()) {
            return -1;
        }
        return 0;
    }

    static {
        try {
            codeSourceUrl = new URL("file://untrustedContractCode");
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalStateException(malformedURLException);
        }
        NULL_CONTRACT = new NullContract();
    }

    private static class NullContract
    extends AbstractContract {
        private NullContract() {
        }

        @Override
        public JO processBlock(BlockContext blockContext) {
            return null;
        }

        @Override
        public JO processTransaction(TransactionContext transactionContext) {
            return null;
        }

        @Override
        public JO processRequest(RequestContext requestContext) {
            return null;
        }
    }

    public static class CloudDataClassLoader
    extends SecureClassLoader {
        byte[] classBytes;
        ProtectionDomain protectionDomain;

        public void setClassBytes(byte[] byArray) {
            this.classBytes = byArray;
        }

        public void setProtectionDomain(ProtectionDomain protectionDomain) {
            this.protectionDomain = protectionDomain;
        }

        @Override
        protected Class<?> findClass(String string) {
            Class<?> clazz;
            int n;
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null && (n = string.lastIndexOf(46)) >= 0) {
                securityManager.checkPackageDefinition(string.substring(0, n));
            }
            if ((clazz = this.findLoadedClass(string)) != null) {
                return clazz;
            }
            return this.defineClass(string, this.classBytes, 0, this.classBytes.length, this.protectionDomain);
        }

        @Override
        protected PermissionCollection getPermissions(CodeSource codeSource) {
            return Policy.getPolicy().getPermissions(codeSource);
        }
    }
}

