/*
 * Decompiled with CFR 0.152.
 */
package nxt.addons;

import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.NxtException;
import nxt.addons.Contract;
import nxt.addons.ContractAndSetupParameters;
import nxt.addons.ContractLoader;
import nxt.addons.ContractRunner;
import nxt.addons.ContractRunnerConfig;
import nxt.addons.JA;
import nxt.addons.JO;
import nxt.addons.NullContractRunnerConfig;
import nxt.addons.RequestContext;
import nxt.addons.VoucherContext;
import nxt.blockchain.Block;
import nxt.blockchain.Chain;
import nxt.blockchain.ChainTransactionId;
import nxt.blockchain.ChildTransaction;
import nxt.blockchain.Transaction;
import nxt.http.API;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.lightcontracts.ContractReference;
import nxt.util.Convert;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

class ContractRunnerAPIs {
    ContractRunnerAPIs() {
    }

    private static JO runnerNotInitializedResponse(String string) {
        JO jO = new JO();
        jO.put("errorCode", (Object)1000);
        jO.put("errorDescription", string);
        return jO;
    }

    public static class UploadContractRunnerConfigurationAPI
    extends APIServlet.APIRequestHandler {
        private final ContractRunner contractRunner;

        UploadContractRunnerConfigurationAPI(ContractRunner contractRunner, String string, APITag[] aPITagArray, String ... stringArray) {
            super(string, aPITagArray, stringArray);
            this.contractRunner = contractRunner;
        }

        @Override
        protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
            API.verifyPassword(httpServletRequest);
            ParameterParser.FileData fileData = ParameterParser.getFileData(httpServletRequest, "config", true);
            if (fileData == null) {
                return JSONResponses.INCORRECT_FILE;
            }
            byte[] byArray = fileData.getData();
            return this.contractRunner.parseConfig(new StringReader(new String(byArray, StandardCharsets.UTF_8)));
        }

        @Override
        protected boolean isChainSpecific() {
            return false;
        }

        @Override
        protected boolean requireFullClient() {
            return true;
        }
    }

    public static class GetSupportedContractsAPI
    extends APIServlet.APIRequestHandler {
        private final ContractRunner contractRunner;

        GetSupportedContractsAPI(ContractRunner contractRunner, APITag[] aPITagArray) {
            super(aPITagArray, new String[0]);
            this.contractRunner = contractRunner;
        }

        @Override
        protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
            Object object;
            ContractRunnerConfig contractRunnerConfig = this.contractRunner.getConfig();
            if (contractRunnerConfig instanceof NullContractRunnerConfig) {
                return ContractRunnerAPIs.runnerNotInitializedResponse(contractRunnerConfig.getStatus()).toJSONObject();
            }
            JO jO = new JO();
            jO.put("status", contractRunnerConfig.getStatus());
            jO.put("contractRunnerAccount", contractRunnerConfig.getAccount());
            jO.put("contractRunnerAccountRS", contractRunnerConfig.getAccountRs());
            jO.put("hasSecretPhrase", (Object)(contractRunnerConfig.getSecretPhrase() != null ? 1 : 0));
            jO.put("isValidator", (Object)contractRunnerConfig.isValidator());
            jO.put("hasValidatorSecretPhrase", (Object)(contractRunnerConfig.getValidatorSecretPhrase() != null ? 1 : 0));
            jO.put("hasRandomSeed", (Object)(!Arrays.equals(contractRunnerConfig.getRunnerSeed(), contractRunnerConfig.getPublicKey()) ? 1 : 0));
            jO.put("autoFeeRate", (Object)contractRunnerConfig.isAutoFeeRate());
            jO.put("minBundlerBalanceFXT", Long.toUnsignedString(contractRunnerConfig.getMinBundlerBalanceFXT()));
            jO.put("minBundlerFeeLimitFQT", Long.toUnsignedString(contractRunnerConfig.getMinBundlerFeeLimitFQT()));
            int n = 1;
            while ((object = Chain.getChain(n)) != null) {
                long l = contractRunnerConfig.getFeeRateNQTPerFXT(n);
                if (l != -1L) {
                    jO.put("feeRateNQTPerFXT." + ((Chain)object).getName(), Long.toUnsignedString(l));
                }
                ++n;
            }
            object = new JA();
            for (String string : this.contractRunner.getSupportedContractNames()) {
                JO jO2 = new JO();
                jO2.put("name", string);
                ContractAndSetupParameters contractAndSetupParameters = this.contractRunner.getContract(string);
                jO2.put("setupParams", contractAndSetupParameters.getParams().toJSONObject());
                ContractReference contractReference = this.contractRunner.getSupportedContractReference(string);
                jO2.put("contractReference", JSONData.contractReference(contractReference, false));
                jO2.put("contract", JSONData.contract(contractAndSetupParameters.getContract()));
                ChainTransactionId chainTransactionId = contractReference.getContractId();
                ChildTransaction childTransaction = chainTransactionId.getChildTransaction();
                jO2.put("uploadTransaction", JSONData.transaction(childTransaction));
                ((JA)object).add(jO2);
            }
            jO.put("supportedContracts", object);
            return jO.toJSONObject();
        }

        @Override
        protected boolean isChainSpecific() {
            return false;
        }
    }

    public static final class TriggerContractByVoucherAPI
    extends APIServlet.APIRequestHandler {
        private final ContractRunner contractRunner;

        TriggerContractByVoucherAPI(ContractRunner contractRunner, String string, APITag[] aPITagArray, String ... stringArray) {
            super(string, aPITagArray, stringArray);
            this.contractRunner = contractRunner;
        }

        @Override
        protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
            ContractRunnerConfig contractRunnerConfig = this.contractRunner.getConfig();
            if (contractRunnerConfig instanceof NullContractRunnerConfig) {
                return ContractRunnerAPIs.runnerNotInitializedResponse(contractRunnerConfig.getStatus()).toJSONObject();
            }
            ParameterParser.FileData fileData = ParameterParser.getFileData(httpServletRequest, "voucher", true);
            if (fileData == null) {
                return JSONResponses.INCORRECT_FILE;
            }
            byte[] byArray = fileData.getData();
            String string = httpServletRequest.getParameter("contractName");
            JSONObject jSONObject = ParameterParser.parseVoucher(byArray);
            ContractAndSetupParameters contractAndSetupParameters = this.contractRunner.getContract(string);
            Contract contract = contractAndSetupParameters.getContract();
            VoucherContext voucherContext = new VoucherContext(new JO(jSONObject), contractRunnerConfig, string);
            JO jO = this.contractRunner.process(contractAndSetupParameters, voucherContext, ContractRunner.INVOCATION_TYPE.VOUCHER);
            if (jO == null) {
                return this.contractRunner.generateErrorResponse(1003, "Contract %s with class %s invoked by account %s returned no response", string, contract.getClass().getCanonicalName(), contractRunnerConfig.getAccountRs()).toJSONObject();
            }
            if (jO.isExist("transactions")) {
                jO.put("submitContractTransactionsResponse", this.contractRunner.submitContractTransactions(contract, jO.getJoList("transactions")));
            }
            return jO.toJSONObject();
        }

        @Override
        protected boolean isChainSpecific() {
            return false;
        }
    }

    public static class TriggerContractByRequestAPI
    extends APIServlet.APIRequestHandler {
        private final ContractRunner contractRunner;

        TriggerContractByRequestAPI(ContractRunner contractRunner, APITag[] aPITagArray, String ... stringArray) {
            super(aPITagArray, stringArray);
            this.contractRunner = contractRunner;
        }

        @Override
        protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
            RequestContext requestContext;
            API.verifyPassword(httpServletRequest);
            ContractRunnerConfig contractRunnerConfig = this.contractRunner.getConfig();
            if (contractRunnerConfig instanceof NullContractRunnerConfig) {
                return ContractRunnerAPIs.runnerNotInitializedResponse(contractRunnerConfig.getStatus()).toJSONObject();
            }
            String string = httpServletRequest.getParameter("contractName");
            ContractReference contractReference = ContractReference.getContractReference(contractRunnerConfig.getAccountId(), string);
            if (contractReference == null) {
                return this.contractRunner.generateErrorResponse(1002, "Contract %s not found", string).toJSONObject();
            }
            ContractAndSetupParameters contractAndSetupParameters = ContractLoader.loadContractAndSetupParameters(contractReference);
            JO jO = this.contractRunner.process(contractAndSetupParameters, requestContext = new RequestContext(httpServletRequest, contractRunnerConfig, string), ContractRunner.INVOCATION_TYPE.REQUEST);
            if (jO == null) {
                return this.contractRunner.generateErrorResponse(1002, "Contract %s class %s returned no response", string, contractAndSetupParameters.getClass().getCanonicalName()).toJSONObject();
            }
            return jO.toJSONObject();
        }

        @Override
        protected boolean isChainSpecific() {
            return false;
        }
    }

    public static class TriggerContractByHeightAPI
    extends APIServlet.APIRequestHandler {
        private final ContractRunner contractRunner;

        TriggerContractByHeightAPI(ContractRunner contractRunner, APITag[] aPITagArray, String ... stringArray) {
            super(aPITagArray, stringArray);
            this.contractRunner = contractRunner;
        }

        @Override
        protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
            API.verifyPassword(httpServletRequest);
            int n = ParameterParser.getHeight(httpServletRequest);
            String string = httpServletRequest.getParameter("contractName");
            boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("apply"));
            Block block = Nxt.getBlockchain().getBlockAtHeight(n);
            JO jO = this.contractRunner.processBlockContract(block, string, bl, false, null);
            if (jO == null) {
                return null;
            }
            return jO.toJSONObject();
        }

        @Override
        protected boolean isChainSpecific() {
            return false;
        }
    }

    public static class TriggerContractByTransactionAPI
    extends APIServlet.APIRequestHandler {
        private final ContractRunner contractRunner;

        TriggerContractByTransactionAPI(ContractRunner contractRunner, APITag[] aPITagArray, String ... stringArray) {
            super(aPITagArray, stringArray);
            this.contractRunner = contractRunner;
        }

        @Override
        protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
            API.verifyPassword(httpServletRequest);
            byte[] byArray = ParameterParser.getBytes(httpServletRequest, "triggerFullHash", true);
            Chain chain = ParameterParser.getChain(httpServletRequest);
            boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("apply"));
            boolean bl2 = "true".equalsIgnoreCase(httpServletRequest.getParameter("validate"));
            Transaction transaction = Nxt.getBlockchain().getTransaction(chain, byArray);
            if (transaction != null) {
                return this.contractRunner.processTransaction(transaction, bl, bl2).toJSONObject();
            }
            return this.contractRunner.generateErrorResponse(1001, "Unknown transaction %d:%s", chain.getId(), Convert.toHexString(byArray)).toJSONObject();
        }
    }
}

