/*
 * Decompiled with CFR 0.152.
 */
package nxt.addons;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nxt.Nxt;
import nxt.account.Account;
import nxt.account.BalanceHome;
import nxt.ae.AskOrderPlacementAttachment;
import nxt.ae.Asset;
import nxt.ae.AssetDeleteAttachment;
import nxt.ae.AssetIssuanceAttachment;
import nxt.ae.AssetTransferAttachment;
import nxt.ae.DividendPaymentAttachment;
import nxt.ae.OrderCancellationAttachment;
import nxt.ae.OrderHome;
import nxt.ae.OrderPlacementAttachment;
import nxt.ae.TradeHome;
import nxt.blockchain.Attachment;
import nxt.blockchain.Block;
import nxt.blockchain.BlockDb;
import nxt.blockchain.BlockchainProcessor;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildChain;
import nxt.blockchain.FxtTransaction;
import nxt.blockchain.FxtTransactionImpl;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionImpl;
import nxt.blockchain.TransactionProcessor;
import nxt.db.DbIterator;
import nxt.dgs.DeliveryAttachment;
import nxt.dgs.DigitalGoodsHome;
import nxt.dgs.PurchaseAttachment;
import nxt.dgs.RefundAttachment;
import nxt.messaging.MessageAttachment;
import nxt.ms.Currency;
import nxt.ms.CurrencyFounderHome;
import nxt.ms.CurrencyIssuanceAttachment;
import nxt.ms.CurrencyMint;
import nxt.ms.CurrencyTransferAttachment;
import nxt.ms.CurrencyType;
import nxt.ms.ExchangeHome;
import nxt.ms.PublishExchangeOfferAttachment;
import nxt.ms.ReserveClaimAttachment;
import nxt.ms.ReserveIncreaseAttachment;
import nxt.shuffling.ShufflingHome;
import nxt.util.Convert;
import nxt.util.Logger;

public final class DebugTrace {
    public static final String QUOTE = Nxt.getStringProperty("nxt.debugTraceQuote", "\"");
    public static final String SEPARATOR = Nxt.getStringProperty("nxt.debugTraceSeparator", "\t");
    public static final boolean LOG_UNCONFIRMED = Nxt.getBooleanProperty("nxt.debugLogUnconfirmed");
    private static final String[] columns = new String[]{"height", "event", "account", "asset", "currency", "balance", "unconfirmed balance", "asset balance", "unconfirmed asset balance", "currency balance", "unconfirmed currency balance", "transaction amount", "transaction fee", "generation fee", "effective balance", "dividend", "order", "order price", "order quantity", "order cost", "offer", "buy rate", "sell rate", "buy units", "sell units", "buy cost", "sell cost", "trade price", "trade quantity", "trade cost", "exchange rate", "exchange quantity", "exchange cost", "currency cost", "crowdfunding", "claim", "mint", "asset quantity", "currency units", "transaction", "lessee", "lessor guaranteed balance", "purchase", "purchase price", "purchase quantity", "purchase cost", "discount", "refund", "shuffling", "sender", "recipient", "block", "timestamp"};
    private static final Map<String, String> headers = new HashMap<String, String>();
    private final Set<Long> accountIds;
    private final String logName;
    private PrintWriter log;

    public static void init() {
        List<String> list = Nxt.getStringListProperty("nxt.debugTraceAccounts");
        String string = Nxt.getStringProperty("nxt.debugTraceLog");
        if (list.isEmpty() || string == null) {
            return;
        }
        HashSet<Long> hashSet = new HashSet<Long>();
        for (String string2 : list) {
            if ("*".equals(string2)) {
                hashSet.clear();
                break;
            }
            hashSet.add(Convert.parseAccountId(string2));
        }
        DebugTrace debugTrace = DebugTrace.addDebugTrace(hashSet, string);
        Nxt.getBlockchainProcessor().addListener(block -> debugTrace.resetLog(), BlockchainProcessor.Event.RESCAN_BEGIN);
        Logger.logDebugMessage("Debug tracing of " + (list.contains("*") ? "ALL" : String.valueOf(hashSet.size())) + " accounts enabled");
    }

    public static DebugTrace addDebugTrace(Set<Long> set, String string) {
        DebugTrace debugTrace = new DebugTrace(set, string);
        ShufflingHome.addListener(debugTrace::traceShufflingDistribute, ShufflingHome.Event.SHUFFLING_DONE);
        ShufflingHome.addListener(debugTrace::traceShufflingCancel, ShufflingHome.Event.SHUFFLING_CANCELLED);
        TradeHome.addListener(debugTrace::trace, TradeHome.Event.TRADE);
        ExchangeHome.addListener(debugTrace::trace, ExchangeHome.Event.EXCHANGE);
        Currency.addListener(debugTrace::crowdfunding, Currency.Event.BEFORE_DISTRIBUTE_CROWDFUNDING);
        Currency.addListener(debugTrace::undoCrowdfunding, Currency.Event.BEFORE_UNDO_CROWDFUNDING);
        Currency.addListener(debugTrace::delete, Currency.Event.BEFORE_DELETE);
        CurrencyMint.addListener(debugTrace::currencyMint, CurrencyMint.Event.CURRENCY_MINT);
        BalanceHome.addListener(balance -> debugTrace.trace((BalanceHome.Balance)balance, false), BalanceHome.Event.BALANCE);
        if (LOG_UNCONFIRMED) {
            BalanceHome.addListener(balance -> debugTrace.trace((BalanceHome.Balance)balance, true), BalanceHome.Event.UNCONFIRMED_BALANCE);
        }
        Account.addAssetListener(accountAsset -> debugTrace.trace((Account.AccountAsset)accountAsset, false), Account.Event.ASSET_BALANCE);
        if (LOG_UNCONFIRMED) {
            Account.addAssetListener(accountAsset -> debugTrace.trace((Account.AccountAsset)accountAsset, true), Account.Event.UNCONFIRMED_ASSET_BALANCE);
        }
        Account.addCurrencyListener(accountCurrency -> debugTrace.trace((Account.AccountCurrency)accountCurrency, false), Account.Event.CURRENCY_BALANCE);
        if (LOG_UNCONFIRMED) {
            Account.addCurrencyListener(accountCurrency -> debugTrace.trace((Account.AccountCurrency)accountCurrency, true), Account.Event.UNCONFIRMED_CURRENCY_BALANCE);
        }
        Account.addLeaseListener(accountLease -> debugTrace.trace((Account.AccountLease)accountLease, true), Account.Event.LEASE_STARTED);
        Account.addLeaseListener(accountLease -> debugTrace.trace((Account.AccountLease)accountLease, false), Account.Event.LEASE_ENDED);
        Nxt.getBlockchainProcessor().addListener(debugTrace::traceBeforeAccept, BlockchainProcessor.Event.BEFORE_BLOCK_ACCEPT);
        Nxt.getBlockchainProcessor().addListener(debugTrace::trace, BlockchainProcessor.Event.BEFORE_BLOCK_APPLY);
        Nxt.getTransactionProcessor().addListener(list -> debugTrace.traceRelease((Transaction)list.get(0)), TransactionProcessor.Event.RELEASE_PHASED_TRANSACTION);
        return debugTrace;
    }

    private DebugTrace(Set<Long> set, String string) {
        this.accountIds = set;
        this.logName = string;
        this.resetLog();
    }

    public void resetLog() {
        if (this.log != null) {
            this.log.close();
        }
        try {
            this.log = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.logName))), true);
        }
        catch (IOException iOException) {
            Logger.logDebugMessage("Debug tracing to " + this.logName + " not possible", iOException);
            throw new RuntimeException(iOException);
        }
        this.log(headers);
    }

    private boolean include(long l) {
        return l != 0L && (this.accountIds.isEmpty() || this.accountIds.contains(l));
    }

    private void trace(TradeHome.Trade trade) {
        OrderHome orderHome = trade.getChildChain().getOrderHome();
        long l = orderHome.getAskOrder(trade.getAskOrderId()).getAccountId();
        long l2 = orderHome.getBidOrder(trade.getBidOrderId()).getAccountId();
        if (this.include(l)) {
            this.log(this.getValues(l, trade, true));
        }
        if (this.include(l2)) {
            this.log(this.getValues(l2, trade, false));
        }
    }

    private void trace(ExchangeHome.Exchange exchange) {
        long l = exchange.getSellerId();
        long l2 = exchange.getBuyerId();
        if (this.include(l)) {
            this.log(this.getValues(l, exchange, true));
        }
        if (this.include(l2)) {
            this.log(this.getValues(l2, exchange, false));
        }
    }

    private void trace(BalanceHome.Balance balance, boolean bl) {
        if (this.include(balance.getAccountId())) {
            this.log(this.getValues(balance, bl));
        }
    }

    private void trace(Account.AccountAsset accountAsset, boolean bl) {
        if (!this.include(accountAsset.getAccountId())) {
            return;
        }
        this.log(this.getValues(accountAsset.getAccountId(), accountAsset, bl));
    }

    private void trace(Account.AccountCurrency accountCurrency, boolean bl) {
        if (!this.include(accountCurrency.getAccountId())) {
            return;
        }
        this.log(this.getValues(accountCurrency.getAccountId(), accountCurrency, bl));
    }

    private void trace(Account.AccountLease accountLease, boolean bl) {
        if (!this.include(accountLease.getCurrentLesseeId()) && !this.include(accountLease.getLessorId())) {
            return;
        }
        this.log(this.getValues(accountLease.getLessorId(), accountLease, bl));
    }

    private void traceBeforeAccept(Block block) {
        long l = block.getGeneratorId();
        if (this.include(l)) {
            this.log(this.getValues(l, block));
        }
        for (long l2 : this.accountIds) {
            Account account = Account.getAccount(l2);
            if (account == null) continue;
            DbIterator<Account> dbIterator = account.getLessors();
            Throwable throwable = null;
            try {
                while (dbIterator.hasNext()) {
                    this.log(this.lessorGuaranteedBalance(dbIterator.next(), l2));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dbIterator == null) continue;
                if (throwable != null) {
                    try {
                        dbIterator.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dbIterator.close();
            }
        }
    }

    private void trace(Block block) {
        for (Transaction transaction : block.getFxtTransactions()) {
            long l;
            long l2 = transaction.getSenderId();
            if (((TransactionImpl)transaction).attachmentIsPhased()) {
                if (!this.include(l2)) continue;
                this.log(this.getValues(l2, transaction, false, true, false));
                continue;
            }
            if (this.include(l2)) {
                this.log(this.getValues(l2, transaction, false, true, true));
                this.log(this.getValues(l2, transaction, transaction.getAttachment(), false));
            }
            if (!this.include(l = transaction.getRecipientId())) continue;
            this.log(this.getValues(l, transaction, true, true, true));
            this.log(this.getValues(l, transaction, transaction.getAttachment(), true));
        }
    }

    private void traceRelease(Transaction transaction) {
        long l;
        long l2 = transaction.getSenderId();
        if (this.include(l2)) {
            this.log(this.getValues(l2, transaction, false, false, true));
            this.log(this.getValues(l2, transaction, transaction.getAttachment(), false));
        }
        if (this.include(l = transaction.getRecipientId())) {
            this.log(this.getValues(l, transaction, true, false, true));
            this.log(this.getValues(l, transaction, transaction.getAttachment(), true));
        }
    }

    private void traceShufflingDistribute(ShufflingHome.Shuffling shuffling) {
        shuffling.getShufflingParticipantHome().getParticipants(shuffling.getFullHash()).forEach(shufflingParticipant -> {
            if (this.include(shufflingParticipant.getAccountId())) {
                this.log(this.getValues(shufflingParticipant.getAccountId(), shuffling, false));
            }
        });
        for (byte[] byArray : shuffling.getRecipientPublicKeys()) {
            long l = Account.getId(byArray);
            if (!this.include(l)) continue;
            this.log(this.getValues(l, shuffling, true));
        }
    }

    private void traceShufflingCancel(ShufflingHome.Shuffling shuffling) {
        ChildChain childChain = shuffling.getChildChain();
        long l = shuffling.getAssigneeAccountId();
        if (l != 0L && this.include(l)) {
            Map<String, String> map = this.getValues(l, false);
            map.put("transaction fee", String.valueOf(-childChain.SHUFFLING_DEPOSIT_NQT));
            map.put("event", "shuffling blame");
            this.log(map);
            long l2 = childChain.SHUFFLING_DEPOSIT_NQT / 4L;
            int n = Nxt.getBlockchain().getHeight();
            for (int i = 0; i < 3; ++i) {
                long l3 = BlockDb.findBlockAtHeight(n - i - 1).getGeneratorId();
                if (!this.include(l3)) continue;
                Map<String, String> map2 = this.getValues(l3, false);
                map2.put("generation fee", String.valueOf(l2));
                map2.put("event", "shuffling blame");
                this.log(map2);
            }
            l2 = childChain.SHUFFLING_DEPOSIT_NQT - 3L * l2;
            long l4 = Nxt.getBlockchain().getLastBlock().getGeneratorId();
            if (this.include(l4)) {
                Map<String, String> map3 = this.getValues(l4, false);
                map3.put("generation fee", String.valueOf(l2));
                map3.put("event", "shuffling blame");
                this.log(map3);
            }
        }
    }

    private Map<String, String> lessorGuaranteedBalance(Account account, long l) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("account", Long.toUnsignedString(account.getId()));
        hashMap.put("lessor guaranteed balance", String.valueOf(account.getGuaranteedBalanceFQT()));
        hashMap.put("lessee", Long.toUnsignedString(l));
        hashMap.put("timestamp", String.valueOf(Nxt.getBlockchain().getLastBlock().getTimestamp()));
        hashMap.put("height", String.valueOf(Nxt.getBlockchain().getHeight()));
        hashMap.put("event", "lessor guaranteed balance");
        return hashMap;
    }

    private void crowdfunding(Currency currency) {
        Object object;
        long l = 0L;
        long l2 = 0L;
        long l3 = currency.getReserveSupplyQNT() - currency.getInitialSupplyQNT();
        ArrayList<CurrencyFounderHome.CurrencyFounder> arrayList = new ArrayList<CurrencyFounderHome.CurrencyFounder>();
        ChildChain childChain = ChildChain.IGNIS;
        Serializable serializable = null;
        try (Object object2 = childChain.getCurrencyFounderHome().getCurrencyFounders(currency.getId(), 0, Integer.MAX_VALUE);){
            object = ((DbIterator)object2).iterator();
            while (object.hasNext()) {
                CurrencyFounderHome.CurrencyFounder currencyFounder = object.next();
                l += currencyFounder.getAmountPerUnitNQT();
                arrayList.add(currencyFounder);
            }
        }
        catch (Throwable throwable) {
            serializable = throwable;
            throw throwable;
        }
        object2 = new BigDecimal(l3, MathContext.DECIMAL128).movePointLeft(currency.getDecimals());
        serializable = new BigDecimal(l, MathContext.DECIMAL128).movePointLeft(childChain.getDecimals());
        for (CurrencyFounderHome.CurrencyFounder currencyFounder : arrayList) {
            long l4 = ((BigDecimal)object2).multiply(new BigDecimal(currencyFounder.getAmountPerUnitNQT(), MathContext.DECIMAL128).movePointLeft(childChain.getDecimals()).divide((BigDecimal)serializable, MathContext.DECIMAL128)).movePointRight(currency.getDecimals()).longValue();
            Map<String, String> map = this.getValues(currencyFounder.getAccountId(), false);
            map.put("currency", Long.toUnsignedString(currency.getId()));
            map.put("currency units", String.valueOf(l4));
            map.put("event", "distribution");
            this.log(map);
            l2 += l4;
        }
        object = this.getValues(currency.getAccountId(), false);
        object.put("currency", Long.toUnsignedString(currency.getId()));
        object.put("crowdfunding", String.valueOf(currency.getReserveSupplyQNT()));
        object.put("currency units", String.valueOf(l3 - l2));
        if (!currency.is(CurrencyType.CLAIMABLE)) {
            long l5 = Convert.unitRateToAmount(currency.getReserveSupplyQNT(), currency.getDecimals(), currency.getCurrentReservePerUnitNQT(), childChain.getDecimals());
            object.put("currency cost", String.valueOf(l5));
        }
        object.put("event", "crowdfunding");
        this.log((Map<String, String>)object);
    }

    private void undoCrowdfunding(Currency currency) {
        ChildChain childChain = ChildChain.IGNIS;
        try (Object object = childChain.getCurrencyFounderHome().getCurrencyFounders(currency.getId(), 0, Integer.MAX_VALUE);){
            Iterator<CurrencyFounderHome.CurrencyFounder> iterator = ((DbIterator)object).iterator();
            while (iterator.hasNext()) {
                CurrencyFounderHome.CurrencyFounder currencyFounder = iterator.next();
                Map<String, String> map = this.getValues(currencyFounder.getAccountId(), false);
                map.put("currency", Long.toUnsignedString(currency.getId()));
                map.put("currency cost", String.valueOf(currencyFounder.getAmountNQT()));
                map.put("event", "undo distribution");
                this.log(map);
            }
        }
        object = this.getValues(currency.getAccountId(), false);
        object.put("currency", Long.toUnsignedString(currency.getId()));
        object.put("currency units", String.valueOf(-currency.getInitialSupplyQNT()));
        object.put("event", "undo crowdfunding");
        this.log((Map<String, String>)object);
    }

    private void delete(Currency currency) {
        Object object;
        Object object2;
        long l;
        long l2;
        ChildChain childChain;
        block33: {
            childChain = ChildChain.IGNIS;
            if (!currency.isActive()) {
                l2 = currency.getAccountId();
                l = currency.getCurrentSupplyQNT();
            } else {
                object2 = Account.getCurrencyAccounts(currency.getId(), 0, -1);
                Throwable throwable = null;
                try {
                    if (((DbIterator)object2).hasNext()) {
                        object = (Account.AccountCurrency)((DbIterator)object2).next();
                        l2 = ((Account.AccountCurrency)object).getAccountId();
                        l = ((Account.AccountCurrency)object).getUnits();
                        break block33;
                    }
                    return;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object2 != null) {
                        if (throwable != null) {
                            try {
                                ((DbIterator)object2).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((DbIterator)object2).close();
                        }
                    }
                }
            }
        }
        object2 = this.getValues(l2, false);
        object2.put("currency", Long.toUnsignedString(currency.getId()));
        if (currency.is(CurrencyType.RESERVABLE)) {
            if (currency.is(CurrencyType.CLAIMABLE) && currency.isActive()) {
                long l3 = Convert.unitRateToAmount(l, currency.getDecimals(), currency.getCurrentReservePerUnitNQT(), childChain.getDecimals());
                object2.put("currency cost", String.valueOf(l3));
            }
            if (!currency.isActive()) {
                DbIterator<CurrencyFounderHome.CurrencyFounder> dbIterator = childChain.getCurrencyFounderHome().getCurrencyFounders(currency.getId(), 0, Integer.MAX_VALUE);
                object = null;
                try {
                    for (CurrencyFounderHome.CurrencyFounder currencyFounder : dbIterator) {
                        Map<String, String> map = this.getValues(currencyFounder.getAccountId(), false);
                        map.put("currency", Long.toUnsignedString(currency.getId()));
                        map.put("currency cost", String.valueOf(currencyFounder.getAmountNQT()));
                        map.put("event", "undo distribution");
                        this.log(map);
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (dbIterator != null) {
                        if (object != null) {
                            try {
                                dbIterator.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            dbIterator.close();
                        }
                    }
                }
            }
        }
        object2.put("currency units", String.valueOf(-l));
        object2.put("event", "currency delete");
        this.log((Map<String, String>)object2);
    }

    private void currencyMint(CurrencyMint.Mint mint) {
        if (!this.include(mint.accountId)) {
            return;
        }
        Map<String, String> map = this.getValues(mint.accountId, false);
        map.put("currency", Long.toUnsignedString(mint.currencyId));
        map.put("currency units", String.valueOf(mint.unitsQNT));
        map.put("event", "currency mint");
        this.log(map);
    }

    private Map<String, String> getValues(long l, boolean bl) {
        ChildChain childChain = ChildChain.IGNIS;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("account", Long.toUnsignedString(l));
        hashMap.put("balance", String.valueOf(childChain.getBalanceHome().getBalance(l).getBalance()));
        hashMap.put("unconfirmed balance", String.valueOf(childChain.getBalanceHome().getBalance(l).getUnconfirmedBalance()));
        hashMap.put("timestamp", String.valueOf(Nxt.getBlockchain().getLastBlock().getTimestamp()));
        hashMap.put("height", String.valueOf(Nxt.getBlockchain().getHeight()));
        hashMap.put("event", bl ? "unconfirmed balance" : "balance");
        return hashMap;
    }

    private Map<String, String> getValues(BalanceHome.Balance balance, boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("account", Long.toUnsignedString(balance.getAccountId()));
        hashMap.put("balance", String.valueOf(balance.getBalance()));
        hashMap.put("unconfirmed balance", String.valueOf(balance.getUnconfirmedBalance()));
        hashMap.put("timestamp", String.valueOf(Nxt.getBlockchain().getLastBlock().getTimestamp()));
        hashMap.put("height", String.valueOf(Nxt.getBlockchain().getHeight()));
        hashMap.put("event", bl ? "unconfirmed balance" : "balance");
        return hashMap;
    }

    private Map<String, String> getValues(long l, TradeHome.Trade trade, boolean bl) {
        ChildChain childChain = trade.getChildChain();
        Asset asset = Asset.getAsset(trade.getAssetId());
        Map<String, String> map = this.getValues(l, false);
        map.put("asset", Long.toUnsignedString(trade.getAssetId()));
        map.put("trade quantity", String.valueOf(bl ? -trade.getQuantityQNT() : trade.getQuantityQNT()));
        map.put("trade price", String.valueOf(trade.getPriceNQT()));
        long l2 = Convert.unitRateToAmount(trade.getQuantityQNT(), asset.getDecimals(), trade.getPriceNQT(), childChain.getDecimals());
        map.put("trade cost", String.valueOf(bl ? l2 : -l2));
        map.put("event", "trade");
        return map;
    }

    private Map<String, String> getValues(long l, ExchangeHome.Exchange exchange, boolean bl) {
        ChildChain childChain = exchange.getChildChain();
        Currency currency = Currency.getCurrency(exchange.getCurrencyId());
        Map<String, String> map = this.getValues(l, false);
        map.put("currency", Long.toUnsignedString(exchange.getCurrencyId()));
        map.put("exchange quantity", String.valueOf(bl ? -exchange.getUnitsQNT() : exchange.getUnitsQNT()));
        map.put("exchange rate", String.valueOf(exchange.getRateNQT()));
        long l2 = Convert.unitRateToAmount(exchange.getUnitsQNT(), currency.getDecimals(), exchange.getRateNQT(), childChain.getDecimals());
        map.put("exchange cost", String.valueOf(bl ? l2 : -l2));
        map.put("event", "exchange");
        return map;
    }

    private Map<String, String> getValues(long l, ShufflingHome.Shuffling shuffling, boolean bl) {
        ChildChain childChain = shuffling.getChildChain();
        Map<String, String> map = this.getValues(l, false);
        map.put("shuffling", Long.toUnsignedString(shuffling.getId()));
        String string = String.valueOf(bl ? shuffling.getAmount() : -shuffling.getAmount());
        String string2 = String.valueOf(bl ? childChain.SHUFFLING_DEPOSIT_NQT : -childChain.SHUFFLING_DEPOSIT_NQT);
        switch (shuffling.getHoldingType()) {
            case COIN: {
                map.put("transaction amount", string);
                break;
            }
            case ASSET: {
                map.put("asset quantity", string);
                map.put("asset", Long.toUnsignedString(shuffling.getHoldingId()));
                map.put("transaction amount", string2);
                break;
            }
            case CURRENCY: {
                map.put("currency units", string);
                map.put("currency", Long.toUnsignedString(shuffling.getHoldingId()));
                map.put("transaction amount", string2);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported holding type " + (Object)((Object)shuffling.getHoldingType()));
            }
        }
        map.put("event", "shuffling distribute");
        return map;
    }

    private Map<String, String> getValues(long l, Transaction transaction, boolean bl, boolean bl2, boolean bl3) {
        long l2 = transaction.getAmount();
        long l3 = transaction.getFee();
        if (bl) {
            l3 = 0L;
        } else {
            l2 = -l2;
            l3 = -l3;
        }
        if (l3 == 0L && l2 == 0L) {
            return Collections.emptyMap();
        }
        Map<String, String> map = this.getValues(l, false);
        if (bl3) {
            map.put("transaction amount", String.valueOf(l2));
        }
        if (bl2) {
            map.put("transaction fee", String.valueOf(l3));
        }
        map.put("transaction", Long.toUnsignedString(transaction.getId()));
        if (bl) {
            map.put("sender", Long.toUnsignedString(transaction.getSenderId()));
        } else {
            map.put("recipient", Long.toUnsignedString(transaction.getRecipientId()));
        }
        map.put("event", "transaction");
        return map;
    }

    private Map<String, String> getValues(long l, Block block) {
        Object object;
        long l2 = block.getTotalFeeFQT();
        if (l2 == 0L) {
            return Collections.emptyMap();
        }
        long l3 = 0L;
        if (block.getHeight() > 3) {
            object = new long[3];
            for (FxtTransaction fxtTransaction : block.getFxtTransactions()) {
                long[] lArray = ((FxtTransactionImpl)fxtTransaction).getBackFees();
                for (int i = 0; i < lArray.length; ++i) {
                    Object object2 = object;
                    int n = i;
                    object2[n] = object2[n] + lArray[i];
                }
            }
            for (int i = 0; i < ((Object)object).length && object[i] != 0L; ++i) {
                l3 += object[i];
                long l4 = BlockDb.findBlockAtHeight(block.getHeight() - i - 1).getGeneratorId();
                if (!this.include(l4)) continue;
                Map<String, String> map = this.getValues(l4, false);
                map.put("effective balance", String.valueOf(Account.getAccount(l4).getEffectiveBalanceFXT()));
                map.put("generation fee", String.valueOf((long)object[i]));
                map.put("block", block.getStringId());
                map.put("event", "block");
                map.put("timestamp", String.valueOf(block.getTimestamp()));
                map.put("height", String.valueOf(block.getHeight()));
                this.log(map);
            }
        }
        object = this.getValues(l, false);
        object.put("effective balance", String.valueOf(Account.getAccount(l).getEffectiveBalanceFXT()));
        object.put("generation fee", String.valueOf(l2 - l3));
        object.put("block", block.getStringId());
        object.put("event", "block");
        object.put("timestamp", String.valueOf(block.getTimestamp()));
        object.put("height", String.valueOf(block.getHeight()));
        return object;
    }

    private Map<String, String> getValues(long l, Account.AccountAsset accountAsset, boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("account", Long.toUnsignedString(l));
        hashMap.put("asset", Long.toUnsignedString(accountAsset.getAssetId()));
        if (bl) {
            hashMap.put("unconfirmed asset balance", String.valueOf(accountAsset.getUnconfirmedQuantityQNT()));
        } else {
            hashMap.put("asset balance", String.valueOf(accountAsset.getQuantityQNT()));
        }
        hashMap.put("timestamp", String.valueOf(Nxt.getBlockchain().getLastBlock().getTimestamp()));
        hashMap.put("height", String.valueOf(Nxt.getBlockchain().getHeight()));
        hashMap.put("event", "asset balance");
        return hashMap;
    }

    private Map<String, String> getValues(long l, Account.AccountCurrency accountCurrency, boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("account", Long.toUnsignedString(l));
        hashMap.put("currency", Long.toUnsignedString(accountCurrency.getCurrencyId()));
        if (bl) {
            hashMap.put("unconfirmed currency balance", String.valueOf(accountCurrency.getUnconfirmedUnits()));
        } else {
            hashMap.put("currency balance", String.valueOf(accountCurrency.getUnits()));
        }
        hashMap.put("timestamp", String.valueOf(Nxt.getBlockchain().getLastBlock().getTimestamp()));
        hashMap.put("height", String.valueOf(Nxt.getBlockchain().getHeight()));
        hashMap.put("event", "currency balance");
        return hashMap;
    }

    private Map<String, String> getValues(long l, Account.AccountLease accountLease, boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("account", Long.toUnsignedString(l));
        hashMap.put("event", bl ? "lease begin" : "lease end");
        hashMap.put("timestamp", String.valueOf(Nxt.getBlockchain().getLastBlock().getTimestamp()));
        hashMap.put("height", String.valueOf(Nxt.getBlockchain().getHeight()));
        hashMap.put("lessee", Long.toUnsignedString(accountLease.getCurrentLesseeId()));
        return hashMap;
    }

    private Map<String, String> getValues(long l, Transaction transaction, Attachment attachment, boolean bl) {
        Map<String, String> map = this.getValues(l, false);
        Chain chain = transaction.getChain();
        if (attachment instanceof OrderPlacementAttachment) {
            if (bl) {
                return Collections.emptyMap();
            }
            OrderPlacementAttachment orderPlacementAttachment = (OrderPlacementAttachment)attachment;
            boolean bl2 = orderPlacementAttachment instanceof AskOrderPlacementAttachment;
            Asset asset = Asset.getAsset(orderPlacementAttachment.getAssetId());
            map.put("asset", Long.toUnsignedString(orderPlacementAttachment.getAssetId()));
            map.put("order", Long.toUnsignedString(transaction.getId()));
            map.put("order price", String.valueOf(orderPlacementAttachment.getPriceNQT()));
            long l2 = orderPlacementAttachment.getQuantityQNT();
            if (bl2) {
                l2 = -l2;
            }
            map.put("order quantity", String.valueOf(l2));
            long l3 = Convert.unitRateToAmount(orderPlacementAttachment.getQuantityQNT(), asset.getDecimals(), orderPlacementAttachment.getPriceNQT(), chain.getDecimals());
            if (!bl2) {
                l3 = -l3;
            }
            map.put("order cost", Long.toString(l3));
            String string = (bl2 ? "ask" : "bid") + " order";
            map.put("event", string);
        } else if (attachment instanceof AssetIssuanceAttachment) {
            if (bl) {
                return Collections.emptyMap();
            }
            AssetIssuanceAttachment assetIssuanceAttachment = (AssetIssuanceAttachment)attachment;
            map.put("asset", Long.toUnsignedString(transaction.getId()));
            map.put("asset quantity", String.valueOf(assetIssuanceAttachment.getQuantityQNT()));
            map.put("event", "asset issuance");
        } else if (attachment instanceof AssetTransferAttachment) {
            AssetTransferAttachment assetTransferAttachment = (AssetTransferAttachment)attachment;
            map.put("asset", Long.toUnsignedString(assetTransferAttachment.getAssetId()));
            long l4 = assetTransferAttachment.getQuantityQNT();
            if (!bl) {
                l4 = -l4;
            }
            map.put("asset quantity", String.valueOf(l4));
            map.put("event", "asset transfer");
        } else if (attachment instanceof AssetDeleteAttachment) {
            if (bl) {
                return Collections.emptyMap();
            }
            AssetDeleteAttachment assetDeleteAttachment = (AssetDeleteAttachment)attachment;
            map.put("asset", Long.toUnsignedString(assetDeleteAttachment.getAssetId()));
            long l5 = assetDeleteAttachment.getQuantityQNT();
            map.put("asset quantity", String.valueOf(-l5));
            map.put("event", "asset delete");
        } else if (attachment instanceof OrderCancellationAttachment) {
            OrderCancellationAttachment orderCancellationAttachment = (OrderCancellationAttachment)attachment;
            map.put("order", Long.toUnsignedString(orderCancellationAttachment.getOrderId()));
            map.put("event", "order cancel");
        } else if (attachment instanceof PurchaseAttachment) {
            PurchaseAttachment purchaseAttachment = (PurchaseAttachment)transaction.getAttachment();
            if (bl) {
                map = this.getValues(((ChildChain)transaction.getChain()).getDigitalGoodsHome().getGoods(purchaseAttachment.getGoodsId()).getSellerId(), false);
            }
            map.put("event", "purchase");
            map.put("purchase", Long.toUnsignedString(transaction.getId()));
        } else if (attachment instanceof DeliveryAttachment) {
            DeliveryAttachment deliveryAttachment = (DeliveryAttachment)transaction.getAttachment();
            DigitalGoodsHome.Purchase purchase = ((ChildChain)transaction.getChain()).getDigitalGoodsHome().getPurchase(deliveryAttachment.getPurchaseId());
            if (bl) {
                map = this.getValues(purchase.getBuyerId(), false);
            }
            map.put("event", "delivery");
            map.put("purchase", Long.toUnsignedString(deliveryAttachment.getPurchaseId()));
            long l6 = deliveryAttachment.getDiscountNQT();
            map.put("purchase price", String.valueOf(purchase.getPriceNQT()));
            map.put("purchase quantity", String.valueOf(purchase.getQuantity()));
            long l7 = Math.multiplyExact(purchase.getPriceNQT(), (long)purchase.getQuantity());
            if (bl) {
                l7 = -l7;
            }
            map.put("purchase cost", String.valueOf(l7));
            if (!bl) {
                l6 = -l6;
            }
            map.put("discount", String.valueOf(l6));
        } else if (attachment instanceof RefundAttachment) {
            RefundAttachment refundAttachment = (RefundAttachment)transaction.getAttachment();
            if (bl) {
                map = this.getValues(((ChildChain)transaction.getChain()).getDigitalGoodsHome().getPurchase(refundAttachment.getPurchaseId()).getBuyerId(), false);
            }
            map.put("event", "refund");
            map.put("purchase", Long.toUnsignedString(refundAttachment.getPurchaseId()));
            long l8 = refundAttachment.getRefundNQT();
            if (!bl) {
                l8 = -l8;
            }
            map.put("refund", String.valueOf(l8));
        } else if (attachment == MessageAttachment.INSTANCE) {
            map = new HashMap<String, String>();
            map.put("account", Long.toUnsignedString(l));
            map.put("timestamp", String.valueOf(Nxt.getBlockchain().getLastBlock().getTimestamp()));
            map.put("height", String.valueOf(Nxt.getBlockchain().getHeight()));
            map.put("event", attachment == MessageAttachment.INSTANCE ? "message" : "encrypted message");
            if (bl) {
                map.put("sender", Long.toUnsignedString(transaction.getSenderId()));
            } else {
                map.put("recipient", Long.toUnsignedString(transaction.getRecipientId()));
            }
        } else if (attachment instanceof PublishExchangeOfferAttachment) {
            PublishExchangeOfferAttachment publishExchangeOfferAttachment = (PublishExchangeOfferAttachment)attachment;
            Currency currency = Currency.getCurrency(publishExchangeOfferAttachment.getCurrencyId());
            map.put("currency", Long.toUnsignedString(publishExchangeOfferAttachment.getCurrencyId()));
            map.put("offer", Long.toUnsignedString(transaction.getId()));
            map.put("buy rate", String.valueOf(publishExchangeOfferAttachment.getBuyRateNQT()));
            map.put("sell rate", String.valueOf(publishExchangeOfferAttachment.getSellRateNQT()));
            long l9 = publishExchangeOfferAttachment.getInitialBuySupplyQNT();
            map.put("buy units", String.valueOf(l9));
            long l10 = publishExchangeOfferAttachment.getInitialSellSupplyQNT();
            map.put("sell units", String.valueOf(l10));
            long l11 = Convert.unitRateToAmount(l9, currency.getDecimals(), publishExchangeOfferAttachment.getBuyRateNQT(), chain.getDecimals());
            map.put("buy cost", Long.toString(l11));
            long l12 = Convert.unitRateToAmount(l10, currency.getDecimals(), publishExchangeOfferAttachment.getSellRateNQT(), chain.getDecimals());
            map.put("sell cost", Long.toString(l12));
            map.put("event", "offer");
        } else if (attachment instanceof CurrencyIssuanceAttachment) {
            CurrencyIssuanceAttachment currencyIssuanceAttachment = (CurrencyIssuanceAttachment)attachment;
            map.put("currency", Long.toUnsignedString(transaction.getId()));
            map.put("currency units", String.valueOf(currencyIssuanceAttachment.getInitialSupplyQNT()));
            map.put("event", "currency issuance");
        } else if (attachment instanceof CurrencyTransferAttachment) {
            CurrencyTransferAttachment currencyTransferAttachment = (CurrencyTransferAttachment)attachment;
            map.put("currency", Long.toUnsignedString(currencyTransferAttachment.getCurrencyId()));
            long l13 = currencyTransferAttachment.getUnitsQNT();
            if (!bl) {
                l13 = -l13;
            }
            map.put("currency units", String.valueOf(l13));
            map.put("event", "currency transfer");
        } else if (attachment instanceof ReserveClaimAttachment) {
            ReserveClaimAttachment reserveClaimAttachment = (ReserveClaimAttachment)attachment;
            Currency currency = Currency.getCurrency(reserveClaimAttachment.getCurrencyId());
            map.put("currency", Long.toUnsignedString(reserveClaimAttachment.getCurrencyId()));
            map.put("currency units", String.valueOf(-reserveClaimAttachment.getUnitsQNT()));
            long l14 = Convert.unitRateToAmount(reserveClaimAttachment.getUnitsQNT(), currency.getDecimals(), currency.getCurrentReservePerUnitNQT(), chain.getDecimals());
            map.put("currency cost", Long.toString(l14));
            map.put("event", "currency claim");
        } else if (attachment instanceof ReserveIncreaseAttachment) {
            ReserveIncreaseAttachment reserveIncreaseAttachment = (ReserveIncreaseAttachment)attachment;
            map.put("currency", Long.toUnsignedString(reserveIncreaseAttachment.getCurrencyId()));
            Currency currency = Currency.getCurrency(reserveIncreaseAttachment.getCurrencyId());
            long l15 = Convert.unitRateToAmount(currency.getReserveSupplyQNT(), currency.getDecimals(), reserveIncreaseAttachment.getAmountPerUnitNQT(), chain.getDecimals());
            map.put("currency cost", Long.toString(l15));
            map.put("event", "currency reserve");
        } else if (attachment instanceof DividendPaymentAttachment) {
            DividendPaymentAttachment dividendPaymentAttachment = (DividendPaymentAttachment)attachment;
            Asset asset = Asset.getAsset(dividendPaymentAttachment.getAssetId());
            BigDecimal bigDecimal = new BigDecimal(dividendPaymentAttachment.getAmountNQT(), MathContext.DECIMAL128).movePointLeft(chain.getDecimals());
            long l16 = 0L;
            String string = Long.toUnsignedString(dividendPaymentAttachment.getAssetId());
            try (DbIterator<Account.AccountAsset> dbIterator = Account.getAssetAccounts(dividendPaymentAttachment.getAssetId(), dividendPaymentAttachment.getHeight(), 0, -1);){
                while (dbIterator.hasNext()) {
                    long l17;
                    Account.AccountAsset accountAsset = dbIterator.next();
                    if (accountAsset.getAccountId() == l || accountAsset.getQuantityQNT() == 0L || (l17 = new BigDecimal(accountAsset.getQuantityQNT(), MathContext.DECIMAL128).movePointLeft(asset.getDecimals()).multiply(bigDecimal).movePointRight(chain.getDecimals()).longValue()) <= 0L) continue;
                    Map<String, String> map2 = this.getValues(accountAsset.getAccountId(), false);
                    map2.put("dividend", String.valueOf(l17));
                    map2.put("asset", string);
                    map2.put("event", "dividend");
                    l16 += l17;
                    this.log(map2);
                }
            }
            map.put("dividend", String.valueOf(-l16));
            map.put("asset", string);
            map.put("event", "dividend");
        } else {
            return Collections.emptyMap();
        }
        return map;
    }

    private void log(Map<String, String> map) {
        if (map.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : columns) {
            if (!LOG_UNCONFIRMED && string.startsWith("unconfirmed")) continue;
            String string2 = map.get(string);
            if (string2 != null) {
                stringBuilder.append(QUOTE).append(string2).append(QUOTE);
            }
            stringBuilder.append(SEPARATOR);
        }
        this.log.println(stringBuilder.toString());
    }

    static {
        for (String string : columns) {
            headers.put(string, string);
        }
    }
}

