/*
 * Decompiled with CFR 0.152.
 */
package nxt.addons;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import nxt.Nxt;
import nxt.addons.AddOn;
import nxt.blockchain.Block;
import nxt.blockchain.BlockchainProcessor;
import nxt.util.Listener;
import nxt.util.Logger;

public final class DownloadTimer
implements AddOn {
    private PrintWriter writer = null;

    @Override
    public void init() {
        try {
            this.writer = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(new FileOutputStream("downloadtime.csv"))), true);
            this.writer.println("height,time,dtime,bps,transations,dtransactions,tps");
            Nxt.getBlockchainProcessor().addListener(new Listener<Block>(){
                private final int interval = 10000;
                private final long startTime = System.currentTimeMillis();
                private long previousTime = 0L;
                private long transactions = 0L;
                private long dtransactions = 0L;

                @Override
                public void notify(Block block) {
                    int n = block.getFxtTransactions().size();
                    this.transactions += (long)n;
                    this.dtransactions += (long)n;
                    int n2 = block.getHeight();
                    if (n2 % 10000 == 0) {
                        long l = System.currentTimeMillis() - this.startTime;
                        DownloadTimer.this.writer.print(n2);
                        DownloadTimer.this.writer.print(',');
                        DownloadTimer.this.writer.print(l / 1000L);
                        DownloadTimer.this.writer.print(',');
                        long l2 = (l - this.previousTime) / 1000L;
                        DownloadTimer.this.writer.print(l2);
                        DownloadTimer.this.writer.print(',');
                        DownloadTimer.this.writer.print(10000L / l2);
                        DownloadTimer.this.writer.print(',');
                        DownloadTimer.this.writer.print(this.transactions);
                        DownloadTimer.this.writer.print(',');
                        DownloadTimer.this.writer.print(this.dtransactions);
                        DownloadTimer.this.writer.print(',');
                        long l3 = this.dtransactions / l2;
                        DownloadTimer.this.writer.println(l3);
                        this.previousTime = l;
                        this.dtransactions = 0L;
                    }
                }
            }, BlockchainProcessor.Event.BLOCK_PUSHED);
        }
        catch (IOException iOException) {
            Logger.logErrorMessage(iOException.getMessage(), iOException);
        }
    }

    @Override
    public void shutdown() {
        if (this.writer != null) {
            this.writer.flush();
            this.writer.close();
        }
    }
}

