/*
 * Decompiled with CFR 0.152.
 */
package nxt.addons;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.account.Account;
import nxt.account.HoldingType;
import nxt.addons.AddOn;
import nxt.addons.StandbyShuffler;
import nxt.ae.Asset;
import nxt.blockchain.ChildChain;
import nxt.crypto.Crypto;
import nxt.http.API;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.ms.Currency;
import nxt.util.Convert;
import nxt.util.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class StandbyShuffling
implements AddOn {
    private Map<String, APIServlet.APIRequestHandler> apiRequests = new HashMap<String, APIServlet.APIRequestHandler>();

    @Override
    public void init() {
        this.apiRequests.put("startStandbyShuffler", new StartStandbyShuffler());
        this.apiRequests.put("stopStandbyShuffler", new StopStandbyShuffler());
        this.apiRequests.put("getStandbyShufflers", new GetStandbyShufflers());
    }

    @Override
    public Map<String, APIServlet.APIRequestHandler> getAPIRequests() {
        return this.apiRequests;
    }

    public static class GetStandbyShufflers
    extends BaseAPIRequestHandler {
        public GetStandbyShufflers() {
            super("secretPhrase", "holdingType", "holding", "account", "includeHoldingInfo", "adminPassword");
        }

        @Override
        protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
            List<StandbyShuffler> list;
            Object object;
            ChildChain childChain = ParameterParser.getChildChain(httpServletRequest, false);
            String string = ParameterParser.getSecretPhrase(httpServletRequest, false);
            long l = ParameterParser.getAccountId(httpServletRequest, false);
            boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeHoldingInfo"));
            if (string == null) {
                API.verifyPassword(httpServletRequest);
            }
            if (string != null || l != 0L) {
                if (string != null) {
                    if (l != 0L) {
                        if (Account.getId(Crypto.getPublicKey(string)) != l) {
                            return JSONResponses.INCORRECT_ACCOUNT;
                        }
                    } else {
                        l = Account.getId(Crypto.getPublicKey(string));
                    }
                }
                if (httpServletRequest.getParameter("holdingType") != null && httpServletRequest.getParameter("holding") != null) {
                    object = ParameterParser.getHoldingType(httpServletRequest);
                    long l2 = ParameterParser.getHoldingId(httpServletRequest);
                    StandbyShuffler standbyShuffler2 = StandbyShuffler.get(childChain, l, (HoldingType)((Object)object), l2);
                    list = Collections.singletonList(standbyShuffler2);
                } else {
                    long l3 = l;
                    list = childChain == null ? StandbyShuffler.get(standbyShuffler -> standbyShuffler.getAccountId() == l3) : StandbyShuffler.get(standbyShuffler -> standbyShuffler.getAccountId() == l3 && standbyShuffler.getChain() == childChain);
                }
            } else {
                list = childChain != null ? StandbyShuffler.get(standbyShuffler -> standbyShuffler.getChain() == childChain) : StandbyShuffler.get(standbyShuffler -> true);
            }
            object = new JSONObject();
            JSONArray jSONArray = new JSONArray();
            list.forEach(standbyShuffler -> jSONArray.add((Object)JSONData.standbyShuffler(standbyShuffler, bl)));
            object.put((Object)"standbyShufflers", (Object)jSONArray);
            return object;
        }

        @Override
        protected boolean requirePost() {
            return false;
        }
    }

    public static class StopStandbyShuffler
    extends BaseAPIRequestHandler {
        public StopStandbyShuffler() {
            super("secretPhrase", "holdingType", "holding", "account", "adminPassword");
        }

        @Override
        protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
            String string = ParameterParser.getSecretPhrase(httpServletRequest, false);
            long l = ParameterParser.getAccountId(httpServletRequest, false);
            if (string == null) {
                API.verifyPassword(httpServletRequest);
            }
            JSONObject jSONObject = new JSONObject();
            if (string != null || l != 0L) {
                if (string != null) {
                    if (l != 0L) {
                        if (Account.getId(Crypto.getPublicKey(string)) != l) {
                            return JSONResponses.INCORRECT_ACCOUNT;
                        }
                    } else {
                        l = Account.getId(Crypto.getPublicKey(string));
                    }
                }
                HoldingType holdingType = ParameterParser.getHoldingType(httpServletRequest);
                long l2 = ParameterParser.getHoldingId(httpServletRequest);
                ChildChain childChain = ParameterParser.getChildChain(httpServletRequest);
                boolean bl = StandbyShuffler.stop(childChain, l, holdingType, l2);
                jSONObject.put((Object)"stopped", (Object)(bl ? 1 : 0));
            } else {
                int n = StandbyShuffler.stopAll();
                jSONObject.put((Object)"stopped", (Object)n);
            }
            return jSONObject;
        }
    }

    public static class StartStandbyShuffler
    extends BaseAPIRequestHandler {
        public StartStandbyShuffler() {
            super("secretPhrase", "holdingType", "holding", "minAmount", "maxAmount", "minParticipants", "feeRateNQTPerFXT", "recipientPublicKeys");
        }

        @Override
        protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
            Object object;
            Object object2;
            Object object3;
            ChildChain childChain = ParameterParser.getChildChain(httpServletRequest);
            HoldingType holdingType = ParameterParser.getHoldingType(httpServletRequest);
            long l = ParameterParser.getHoldingId(httpServletRequest);
            switch (holdingType) {
                case ASSET: {
                    object3 = Asset.getAsset(l);
                    if (object3 != null) break;
                    return JSONResponses.UNKNOWN_ASSET;
                }
                case CURRENCY: {
                    object2 = Currency.getCurrency(l);
                    if (object2 != null) break;
                    return JSONResponses.UNKNOWN_CURRENCY;
                }
                case COIN: {
                    if (l == (long)childChain.getId()) break;
                    return JSONResponses.INCORRECT_CHAIN;
                }
            }
            object3 = ParameterParser.getSecretPhrase(httpServletRequest, true);
            object2 = Account.getAccount(Crypto.getPublicKey((String)object3));
            if (object2 == null) {
                return JSONResponses.UNKNOWN_ACCOUNT;
            }
            long l2 = ParameterParser.getLong(httpServletRequest, "minAmount", 0L, Long.MAX_VALUE, 0L);
            long l3 = ParameterParser.getLong(httpServletRequest, "maxAmount", 0L, Long.MAX_VALUE, 0L);
            byte by = ParameterParser.getByte(httpServletRequest, "minParticipants", (byte)3, (byte)30, (byte)3, false);
            long l4 = ParameterParser.getLong(httpServletRequest, "feeRateNQTPerFXT", 0L, 100000000000000000L, true);
            List<byte[]> list = ParameterParser.getPublicKeys(httpServletRequest, "recipientPublicKeys");
            for (int i = list.size() - 1; i >= 0; --i) {
                object = list.get(i);
                if (Account.getAccount(object) == null) continue;
                list.remove(i);
                Logger.logWarningMessage("Ignored already used recipient account: " + Convert.toHexString(object));
            }
            if (list.isEmpty()) {
                return JSONResponses.INCORRECT_RECIPIENTS_PUBLIC_KEY;
            }
            StandbyShuffler standbyShuffler = StandbyShuffler.start(childChain, (String)object3, holdingType, l, l2, l3, by, l4, list);
            object = new JSONObject();
            object.put((Object)"started", (Object)(standbyShuffler != null ? 1 : 0));
            if (standbyShuffler != null) {
                object.put((Object)"standbyShuffler", (Object)JSONData.standbyShuffler(standbyShuffler, false));
            }
            return object;
        }

        @Override
        protected boolean isTextArea(String string) {
            return "recipientPublicKeys".equals(string);
        }
    }

    public static abstract class BaseAPIRequestHandler
    extends APIServlet.APIRequestHandler {
        BaseAPIRequestHandler(String ... stringArray) {
            super(new APITag[]{APITag.SHUFFLING, APITag.ADDONS}, stringArray);
        }

        @Override
        protected boolean requirePost() {
            return true;
        }

        @Override
        protected boolean allowRequiredBlockParameters() {
            return false;
        }

        @Override
        protected boolean requireFullClient() {
            return true;
        }
    }
}

