/*
 * Decompiled with CFR 0.152.
 */
package nxt.ae;

import java.nio.ByteBuffer;
import nxt.NxtException;
import nxt.ae.AssetExchangeTransactionType;
import nxt.blockchain.Attachment;
import nxt.blockchain.TransactionType;
import nxt.util.Convert;
import nxt.util.bbh.LengthRwPrimitiveType;
import nxt.util.bbh.StringRw;
import org.json.simple.JSONObject;

public final class AssetIssuanceAttachment
extends Attachment.AbstractAttachment {
    public static final StringRw NAME_RW = new StringRw(LengthRwPrimitiveType.BYTE, 10);
    public static final StringRw DESCRIPTION_RW = new StringRw(LengthRwPrimitiveType.SHORT, 1000);
    private final String name;
    private final String description;
    private final long quantityQNT;
    private final byte decimals;

    AssetIssuanceAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
        super(byteBuffer);
        this.name = NAME_RW.readFromBuffer(byteBuffer);
        this.description = DESCRIPTION_RW.readFromBuffer(byteBuffer);
        this.quantityQNT = byteBuffer.getLong();
        this.decimals = byteBuffer.get();
    }

    AssetIssuanceAttachment(JSONObject jSONObject) {
        super(jSONObject);
        this.name = (String)jSONObject.get((Object)"name");
        this.description = Convert.nullToEmpty((String)jSONObject.get((Object)"description"));
        this.quantityQNT = Convert.parseLong(jSONObject.get((Object)"quantityQNT"));
        this.decimals = ((Long)jSONObject.get((Object)"decimals")).byteValue();
    }

    public AssetIssuanceAttachment(String string, String string2, long l, byte by) {
        this.name = string;
        this.description = Convert.nullToEmpty(string2);
        this.quantityQNT = l;
        this.decimals = by;
    }

    @Override
    protected int getMySize() {
        return NAME_RW.getSize(this.name) + DESCRIPTION_RW.getSize(this.description) + 8 + 1;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        NAME_RW.writeToBuffer(this.name, byteBuffer);
        DESCRIPTION_RW.writeToBuffer(this.description, byteBuffer);
        byteBuffer.putLong(this.quantityQNT);
        byteBuffer.put(this.decimals);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"name", (Object)this.name);
        jSONObject.put((Object)"description", (Object)this.description);
        jSONObject.put((Object)"quantityQNT", (Object)this.quantityQNT);
        jSONObject.put((Object)"decimals", (Object)this.decimals);
    }

    @Override
    public TransactionType getTransactionType() {
        return AssetExchangeTransactionType.ASSET_ISSUANCE;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public long getQuantityQNT() {
        return this.quantityQNT;
    }

    public byte getDecimals() {
        return this.decimals;
    }
}

