/*
 * Decompiled with CFR 0.152.
 */
package nxt.ae;

import java.nio.ByteBuffer;
import nxt.account.HoldingType;
import nxt.ae.AssetExchangeTransactionType;
import nxt.blockchain.Attachment;
import nxt.blockchain.TransactionType;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public final class DividendPaymentAttachment
extends Attachment.AbstractAttachment {
    private final long assetId;
    private final int height;
    private final long amountNQT;
    private final long holdingId;
    private final HoldingType holdingType;

    DividendPaymentAttachment(ByteBuffer byteBuffer) {
        super(byteBuffer);
        this.holdingId = byteBuffer.getLong();
        this.holdingType = HoldingType.get(byteBuffer.get());
        this.assetId = byteBuffer.getLong();
        this.height = byteBuffer.getInt();
        this.amountNQT = byteBuffer.getLong();
    }

    DividendPaymentAttachment(JSONObject jSONObject) {
        super(jSONObject);
        this.assetId = Convert.parseUnsignedLong((String)jSONObject.get((Object)"asset"));
        this.height = ((Long)jSONObject.get((Object)"height")).intValue();
        this.amountNQT = Convert.parseLong(jSONObject.get((Object)"amountNQTPerShare"));
        this.holdingId = Convert.parseUnsignedLong((String)jSONObject.get((Object)"holding"));
        this.holdingType = HoldingType.get(((Long)jSONObject.get((Object)"holdingType")).byteValue());
    }

    public DividendPaymentAttachment(long l, HoldingType holdingType, long l2, int n, long l3) {
        this.holdingId = l;
        this.holdingType = holdingType;
        this.assetId = l2;
        this.height = n;
        this.amountNQT = l3;
    }

    @Override
    protected int getMySize() {
        return 29;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byteBuffer.putLong(this.holdingId);
        byteBuffer.put(this.holdingType.getCode());
        byteBuffer.putLong(this.assetId);
        byteBuffer.putInt(this.height);
        byteBuffer.putLong(this.amountNQT);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"asset", (Object)Long.toUnsignedString(this.assetId));
        jSONObject.put((Object)"height", (Object)this.height);
        jSONObject.put((Object)"amountNQTPerShare", (Object)this.amountNQT);
        jSONObject.put((Object)"holding", (Object)Long.toUnsignedString(this.holdingId));
        jSONObject.put((Object)"holdingType", (Object)this.holdingType.getCode());
    }

    @Override
    public TransactionType getTransactionType() {
        return AssetExchangeTransactionType.DIVIDEND_PAYMENT;
    }

    public long getAssetId() {
        return this.assetId;
    }

    public int getHeight() {
        return this.height;
    }

    public long getAmountNQT() {
        return this.amountNQT;
    }

    public long getHoldingId() {
        return this.holdingId;
    }

    public HoldingType getHoldingType() {
        return this.holdingType;
    }
}

