/*
 * Decompiled with CFR 0.152.
 */
package nxt.ae;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import nxt.Nxt;
import nxt.account.Account;
import nxt.account.AccountLedger;
import nxt.account.BalanceHome;
import nxt.ae.AskOrderPlacementAttachment;
import nxt.ae.Asset;
import nxt.ae.BidOrderPlacementAttachment;
import nxt.ae.OrderPlacementAttachment;
import nxt.ae.TradeHome;
import nxt.blockchain.ChildChain;
import nxt.blockchain.Transaction;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.VersionedEntityDbTable;
import nxt.util.Convert;

public final class OrderHome {
    private final ChildChain childChain;
    private final TradeHome tradeHome;
    private final DbKey.LongKeyFactory<Ask> askOrderDbKeyFactory;
    private final VersionedEntityDbTable<Ask> askOrderTable;
    private final DbKey.LongKeyFactory<Bid> bidOrderDbKeyFactory;
    private final VersionedEntityDbTable<Bid> bidOrderTable;

    public static OrderHome forChain(ChildChain childChain) {
        if (childChain.getOrderHome() != null) {
            throw new IllegalStateException("already set");
        }
        return new OrderHome(childChain);
    }

    private OrderHome(ChildChain childChain) {
        this.childChain = childChain;
        this.tradeHome = childChain.getTradeHome();
        this.askOrderDbKeyFactory = new DbKey.LongKeyFactory<Ask>("id"){

            @Override
            public DbKey newKey(Ask ask) {
                return ask.dbKey;
            }
        };
        this.askOrderTable = new VersionedEntityDbTable<Ask>(childChain.getSchemaTable("ask_order"), this.askOrderDbKeyFactory){

            @Override
            protected Ask load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
                return new Ask(resultSet, dbKey);
            }

            @Override
            protected void save(Connection connection, Ask ask) throws SQLException {
                ask.save(connection, this.schemaTable);
            }

            @Override
            protected String defaultSort() {
                return " ORDER BY creation_height DESC ";
            }
        };
        this.bidOrderDbKeyFactory = new DbKey.LongKeyFactory<Bid>("id"){

            @Override
            public DbKey newKey(Bid bid) {
                return bid.dbKey;
            }
        };
        this.bidOrderTable = new VersionedEntityDbTable<Bid>(childChain.getSchemaTable("bid_order"), this.bidOrderDbKeyFactory){

            @Override
            protected Bid load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
                return new Bid(resultSet, dbKey);
            }

            @Override
            protected void save(Connection connection, Bid bid) throws SQLException {
                bid.save(connection, this.schemaTable);
            }

            @Override
            protected String defaultSort() {
                return " ORDER BY creation_height DESC ";
            }
        };
    }

    public int getAskCount() {
        return this.askOrderTable.getCount();
    }

    public Ask getAskOrder(long l) {
        return (Ask)this.askOrderTable.get(this.askOrderDbKeyFactory.newKey(l));
    }

    public DbIterator<Ask> getAllAskOrders(int n, int n2) {
        return this.askOrderTable.getAll(n, n2);
    }

    public DbIterator<Ask> getAskOrdersByAccount(long l, int n, int n2) {
        return this.askOrderTable.getManyBy(new DbClause.LongClause("account_id", l), n, n2);
    }

    public DbIterator<Ask> getAskOrdersByAsset(long l, int n, int n2) {
        return this.askOrderTable.getManyBy(new DbClause.LongClause("asset_id", l), n, n2);
    }

    public DbIterator<Ask> getAskOrdersByAccountAsset(long l, long l2, int n, int n2) {
        DbClause dbClause = new DbClause.LongClause("account_id", l).and(new DbClause.LongClause("asset_id", l2));
        return this.askOrderTable.getManyBy(dbClause, n, n2);
    }

    public DbIterator<Ask> getSortedAskOrders(long l, int n, int n2) {
        return this.askOrderTable.getManyBy((DbClause)new DbClause.LongClause("asset_id", l), n, n2, " ORDER BY price ASC, creation_height ASC, transaction_height ASC, transaction_index ASC ");
    }

    /*
     * Exception decompiling
     */
    private Ask getNextAskOrder(long var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void addAskOrder(Transaction transaction, AskOrderPlacementAttachment askOrderPlacementAttachment) {
        Ask ask = new Ask(transaction, askOrderPlacementAttachment);
        this.askOrderTable.insert(ask);
        this.matchOrders(askOrderPlacementAttachment.getAssetId());
    }

    void removeAskOrder(long l) {
        this.askOrderTable.delete(this.getAskOrder(l));
    }

    public int getBidCount() {
        return this.bidOrderTable.getCount();
    }

    public Bid getBidOrder(long l) {
        return (Bid)this.bidOrderTable.get(this.bidOrderDbKeyFactory.newKey(l));
    }

    public DbIterator<Bid> getAllBidOrders(int n, int n2) {
        return this.bidOrderTable.getAll(n, n2);
    }

    public DbIterator<Bid> getBidOrdersByAccount(long l, int n, int n2) {
        return this.bidOrderTable.getManyBy(new DbClause.LongClause("account_id", l), n, n2);
    }

    public DbIterator<Bid> getBidOrdersByAsset(long l, int n, int n2) {
        return this.bidOrderTable.getManyBy(new DbClause.LongClause("asset_id", l), n, n2);
    }

    public DbIterator<Bid> getBidOrdersByAccountAsset(long l, long l2, int n, int n2) {
        DbClause dbClause = new DbClause.LongClause("account_id", l).and(new DbClause.LongClause("asset_id", l2));
        return this.bidOrderTable.getManyBy(dbClause, n, n2);
    }

    public DbIterator<Bid> getSortedBidOrders(long l, int n, int n2) {
        return this.bidOrderTable.getManyBy((DbClause)new DbClause.LongClause("asset_id", l), n, n2, " ORDER BY price DESC, creation_height ASC, transaction_height ASC, transaction_index ASC ");
    }

    /*
     * Exception decompiling
     */
    private Bid getNextBidOrder(long var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void addBidOrder(Transaction transaction, BidOrderPlacementAttachment bidOrderPlacementAttachment) {
        Bid bid = new Bid(transaction, bidOrderPlacementAttachment);
        this.bidOrderTable.insert(bid);
        this.matchOrders(bidOrderPlacementAttachment.getAssetId());
    }

    void removeBidOrder(long l) {
        this.bidOrderTable.delete(this.getBidOrder(l));
    }

    private void matchOrders(long l) {
        Bid bid;
        Ask ask;
        Asset asset = Asset.getAsset(l);
        while ((ask = this.getNextAskOrder(l)) != null && (bid = this.getNextBidOrder(l)) != null && ask.getPriceNQT() <= bid.getPriceNQT()) {
            Object object;
            long l2;
            long l3;
            boolean bl = ask.getHeight() < bid.getHeight() || ask.getHeight() == bid.getHeight() && (ask.getTransactionHeight() < bid.getTransactionHeight() || ask.getTransactionHeight() == bid.getTransactionHeight() && ask.getTransactionIndex() < bid.getTransactionIndex());
            long l4 = bl ? ask.getPriceNQT() : bid.getPriceNQT();
            long l5 = Math.min(ask.getQuantityQNT(), bid.getQuantityQNT());
            long l6 = Convert.unitRateToAmount(l5, asset.getDecimals(), l4, this.childChain.getDecimals());
            if (l6 == 0L) {
                l5 = 0L;
            }
            boolean bl2 = false;
            long l7 = ask.getQuantityQNT() - l5;
            if (l7 > 0L && (l3 = Convert.unitRateToAmount(l7, asset.getDecimals(), ask.getPriceNQT(), this.childChain.getDecimals())) == 0L) {
                bl2 = true;
            }
            l3 = bid.getQuantityQNT() - l5;
            long l8 = bid.getAmountNQT() - l6;
            if (l8 == 0L) {
                l3 = 0L;
            } else if (l3 > 0L && (l2 = Convert.unitRateToAmount(l3, asset.getDecimals(), bid.getPriceNQT(), this.childChain.getDecimals())) == 0L) {
                l3 = 0L;
            }
            if (l6 > 0L) {
                this.tradeHome.addTrade(l, ask, bid, l5, l4, bl);
            }
            ask.updateQuantityQNT(bl2 ? 0L : l7);
            Account account = Account.getAccount(ask.getAccountId());
            AccountLedger.LedgerEventId ledgerEventId = AccountLedger.newEventId(ask.getId(), ask.getFullHash(), this.childChain);
            if (l6 > 0L) {
                object = this.childChain.getBalanceHome().getBalance(ask.getAccountId());
                ((BalanceHome.Balance)object).addToBalanceAndUnconfirmedBalance(AccountLedger.LedgerEvent.ASSET_TRADE, ledgerEventId, l6);
                account.addToAssetBalanceQNT(AccountLedger.LedgerEvent.ASSET_TRADE, ledgerEventId, l, -l5);
            }
            if (bl2) {
                account.addToUnconfirmedAssetBalanceQNT(AccountLedger.LedgerEvent.ASSET_TRADE, ledgerEventId, l, l7);
            }
            bid.updateQuantityQNT(l3, l8);
            object = Account.getAccount(bid.getAccountId());
            AccountLedger.LedgerEventId ledgerEventId2 = AccountLedger.newEventId(bid.getId(), bid.getFullHash(), this.childChain);
            BalanceHome.Balance balance = this.childChain.getBalanceHome().getBalance(bid.getAccountId());
            if (l6 > 0L) {
                ((Account)object).addToAssetAndUnconfirmedAssetBalanceQNT(AccountLedger.LedgerEvent.ASSET_TRADE, ledgerEventId2, l, l5);
                balance.addToBalance(AccountLedger.LedgerEvent.ASSET_TRADE, ledgerEventId2, -l6);
            }
            if (l3 != 0L || l8 == 0L) continue;
            balance.addToUnconfirmedBalance(AccountLedger.LedgerEvent.ASSET_TRADE, ledgerEventId2, l8);
        }
    }

    public final class Bid
    extends Order {
        private final DbKey dbKey;
        private long amountNQT;

        private Bid(Transaction transaction, BidOrderPlacementAttachment bidOrderPlacementAttachment) {
            super(transaction, bidOrderPlacementAttachment);
            this.dbKey = OrderHome.this.bidOrderDbKeyFactory.newKey(((Order)this).id);
            Asset asset = Asset.getAsset(this.getAssetId());
            this.amountNQT = Convert.unitRateToAmount(this.getQuantityQNT(), asset.getDecimals(), this.getPriceNQT(), OrderHome.this.childChain.getDecimals());
        }

        private Bid(ResultSet resultSet, DbKey dbKey) throws SQLException {
            super(resultSet);
            this.amountNQT = resultSet.getLong("amount");
            this.dbKey = dbKey;
        }

        private void save(Connection connection, String string) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO " + string + " (id, full_hash, account_id, asset_id, price, quantity, amount, creation_height, transaction_index, transaction_height, height, latest) KEY (id, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, TRUE)");){
                int n = 0;
                preparedStatement.setLong(++n, this.getId());
                preparedStatement.setBytes(++n, this.getFullHash());
                preparedStatement.setLong(++n, this.getAccountId());
                preparedStatement.setLong(++n, this.getAssetId());
                preparedStatement.setLong(++n, this.getPriceNQT());
                preparedStatement.setLong(++n, this.getQuantityQNT());
                preparedStatement.setLong(++n, this.amountNQT);
                preparedStatement.setInt(++n, this.getHeight());
                preparedStatement.setShort(++n, (short)this.getTransactionIndex());
                preparedStatement.setInt(++n, this.getTransactionHeight());
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }

        public long getAmountNQT() {
            return this.amountNQT;
        }

        private void updateQuantityQNT(long l, long l2) {
            ((Order)this).setQuantityQNT(l);
            this.amountNQT = l2;
            if (l > 0L) {
                OrderHome.this.bidOrderTable.insert(this);
            } else if (l == 0L) {
                OrderHome.this.bidOrderTable.delete(this);
            } else {
                throw new IllegalArgumentException("Negative quantity: " + l + " for order: " + Long.toUnsignedString(this.getId()));
            }
        }

        @Override
        public void cancelOrder(AccountLedger.LedgerEventId ledgerEventId) {
            ChildChain childChain = this.getChildChain();
            childChain.getOrderHome().removeBidOrder(this.getId());
            Account.getAccount(this.getAccountId()).addToUnconfirmedBalance(childChain, AccountLedger.LedgerEvent.ASSET_BID_ORDER_CANCELLATION, ledgerEventId, this.getAmountNQT());
        }
    }

    public final class Ask
    extends Order {
        private final DbKey dbKey;

        private Ask(Transaction transaction, AskOrderPlacementAttachment askOrderPlacementAttachment) {
            super(transaction, askOrderPlacementAttachment);
            this.dbKey = OrderHome.this.askOrderDbKeyFactory.newKey(((Order)this).id);
        }

        private Ask(ResultSet resultSet, DbKey dbKey) throws SQLException {
            super(resultSet);
            this.dbKey = dbKey;
        }

        private void save(Connection connection, String string) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO " + string + " (id, full_hash, account_id, asset_id, price, quantity, creation_height, transaction_index, transaction_height, height, latest) KEY (id, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, TRUE)");){
                int n = 0;
                preparedStatement.setLong(++n, this.getId());
                preparedStatement.setBytes(++n, this.getFullHash());
                preparedStatement.setLong(++n, this.getAccountId());
                preparedStatement.setLong(++n, this.getAssetId());
                preparedStatement.setLong(++n, this.getPriceNQT());
                preparedStatement.setLong(++n, this.getQuantityQNT());
                preparedStatement.setInt(++n, this.getHeight());
                preparedStatement.setShort(++n, (short)this.getTransactionIndex());
                preparedStatement.setInt(++n, this.getTransactionHeight());
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }

        private void updateQuantityQNT(long l) {
            ((Order)this).setQuantityQNT(l);
            if (l > 0L) {
                OrderHome.this.askOrderTable.insert(this);
            } else if (l == 0L) {
                OrderHome.this.askOrderTable.delete(this);
            } else {
                throw new IllegalArgumentException("Negative quantity: " + l + " for order: " + Long.toUnsignedString(this.getId()));
            }
        }

        @Override
        public void cancelOrder(AccountLedger.LedgerEventId ledgerEventId) {
            this.getChildChain().getOrderHome().removeAskOrder(this.getId());
            Account.getAccount(this.getAccountId()).addToUnconfirmedAssetBalanceQNT(AccountLedger.LedgerEvent.ASSET_ASK_ORDER_CANCELLATION, ledgerEventId, this.getAssetId(), this.getQuantityQNT());
        }
    }

    public abstract class Order {
        private final long id;
        private final byte[] hash;
        private final long accountId;
        private final long assetId;
        private final long priceNQT;
        private final int creationHeight;
        private final short transactionIndex;
        private final int transactionHeight;
        private long quantityQNT;

        private Order(Transaction transaction, OrderPlacementAttachment orderPlacementAttachment) {
            this.id = transaction.getId();
            this.hash = transaction.getFullHash();
            this.accountId = transaction.getSenderId();
            this.assetId = orderPlacementAttachment.getAssetId();
            this.quantityQNT = orderPlacementAttachment.getQuantityQNT();
            this.priceNQT = orderPlacementAttachment.getPriceNQT();
            this.creationHeight = Nxt.getBlockchain().getHeight();
            this.transactionIndex = transaction.getIndex();
            this.transactionHeight = transaction.getHeight();
        }

        private Order(ResultSet resultSet) throws SQLException {
            this.id = resultSet.getLong("id");
            this.hash = resultSet.getBytes("full_hash");
            this.accountId = resultSet.getLong("account_id");
            this.assetId = resultSet.getLong("asset_id");
            this.priceNQT = resultSet.getLong("price");
            this.quantityQNT = resultSet.getLong("quantity");
            this.creationHeight = resultSet.getInt("creation_height");
            this.transactionIndex = resultSet.getShort("transaction_index");
            this.transactionHeight = resultSet.getInt("transaction_height");
        }

        public final ChildChain getChildChain() {
            return OrderHome.this.childChain;
        }

        public final long getId() {
            return this.id;
        }

        public final byte[] getFullHash() {
            return this.hash;
        }

        public final long getAccountId() {
            return this.accountId;
        }

        public final long getAssetId() {
            return this.assetId;
        }

        public final long getPriceNQT() {
            return this.priceNQT;
        }

        public final long getQuantityQNT() {
            return this.quantityQNT;
        }

        public final int getHeight() {
            return this.creationHeight;
        }

        public final int getTransactionIndex() {
            return this.transactionIndex;
        }

        public final int getTransactionHeight() {
            return this.transactionHeight;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " id: " + Long.toUnsignedString(this.id) + " account: " + Long.toUnsignedString(this.accountId) + " asset: " + Long.toUnsignedString(this.assetId) + " price: " + this.priceNQT + " quantity: " + this.quantityQNT + " height: " + this.creationHeight + " transactionIndex: " + this.transactionIndex + " transactionHeight: " + this.transactionHeight;
        }

        private void setQuantityQNT(long l) {
            this.quantityQNT = l;
        }

        public abstract void cancelOrder(AccountLedger.LedgerEventId var1);
    }
}

