/*
 * Decompiled with CFR 0.152.
 */
package nxt.ae;

import java.nio.ByteBuffer;
import nxt.NxtException;
import nxt.ae.AssetExchangeTransactionType;
import nxt.blockchain.Attachment;
import nxt.blockchain.TransactionType;
import nxt.util.Convert;
import nxt.voting.PhasingParams;
import org.json.simple.JSONObject;

public class SetPhasingAssetControlAttachment
extends Attachment.AbstractAttachment {
    private final long assetId;
    private final PhasingParams phasingParams;

    SetPhasingAssetControlAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
        super(byteBuffer);
        this.assetId = byteBuffer.getLong();
        this.phasingParams = new PhasingParams(byteBuffer);
    }

    SetPhasingAssetControlAttachment(JSONObject jSONObject) {
        super(jSONObject);
        this.assetId = Convert.parseUnsignedLong((String)jSONObject.get((Object)"asset"));
        JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"phasingControlParams");
        this.phasingParams = new PhasingParams(jSONObject2);
    }

    public SetPhasingAssetControlAttachment(long l, PhasingParams phasingParams) {
        this.assetId = l;
        this.phasingParams = phasingParams;
    }

    @Override
    protected int getMySize() {
        return 8 + this.phasingParams.getMySize();
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byteBuffer.putLong(this.assetId);
        this.phasingParams.putMyBytes(byteBuffer);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"asset", (Object)Long.toUnsignedString(this.assetId));
        JSONObject jSONObject2 = new JSONObject();
        this.phasingParams.putMyJSON(jSONObject2);
        jSONObject.put((Object)"phasingControlParams", (Object)jSONObject2);
    }

    @Override
    public TransactionType getTransactionType() {
        return AssetExchangeTransactionType.SET_PHASING_CONTROL;
    }

    public long getAssetId() {
        return this.assetId;
    }

    public PhasingParams getPhasingParams() {
        return this.phasingParams;
    }
}

