/*
 * Decompiled with CFR 0.152.
 */
package nxt.aliases;

import java.nio.ByteBuffer;
import nxt.NxtException;
import nxt.aliases.AliasAssignmentAttachment;
import nxt.aliases.AliasTransactionType;
import nxt.blockchain.Attachment;
import nxt.blockchain.TransactionType;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public final class AliasSellAttachment
extends Attachment.AbstractAttachment {
    private final String aliasName;
    private final long priceNQT;

    AliasSellAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
        super(byteBuffer);
        this.aliasName = AliasAssignmentAttachment.ALIAS_NAME_RW.readFromBuffer(byteBuffer);
        this.priceNQT = byteBuffer.getLong();
    }

    AliasSellAttachment(JSONObject jSONObject) {
        super(jSONObject);
        this.aliasName = Convert.nullToEmpty((String)jSONObject.get((Object)"alias"));
        this.priceNQT = Convert.parseLong(jSONObject.get((Object)"priceNQT"));
    }

    public AliasSellAttachment(String string, long l) {
        this.aliasName = string;
        this.priceNQT = l;
    }

    @Override
    public TransactionType getTransactionType() {
        return AliasTransactionType.ALIAS_SELL;
    }

    @Override
    protected int getMySize() {
        return AliasAssignmentAttachment.ALIAS_NAME_RW.getSize(this.aliasName) + 8;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        AliasAssignmentAttachment.ALIAS_NAME_RW.writeToBuffer(this.aliasName, byteBuffer);
        byteBuffer.putLong(this.priceNQT);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"alias", (Object)this.aliasName);
        jSONObject.put((Object)"priceNQT", (Object)this.priceNQT);
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public long getPriceNQT() {
        return this.priceNQT;
    }
}

