/*
 * Decompiled with CFR 0.152.
 */
package nxt.blockchain;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import nxt.Constants;
import nxt.Nxt;
import nxt.NxtException;
import nxt.blockchain.Block;
import nxt.blockchain.BlockDb;
import nxt.blockchain.BlockImpl;
import nxt.blockchain.Blockchain;
import nxt.blockchain.BlockchainProcessorImpl;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildChain;
import nxt.blockchain.ChildTransaction;
import nxt.blockchain.ChildTransactionImpl;
import nxt.blockchain.FxtChain;
import nxt.blockchain.FxtTransaction;
import nxt.blockchain.FxtTransactionImpl;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionHome;
import nxt.blockchain.TransactionImpl;
import nxt.blockchain.TransactionType;
import nxt.db.DbIterator;
import nxt.db.DbUtils;
import nxt.dbschema.Db;
import nxt.util.Convert;
import nxt.util.Filter;
import nxt.util.ReadWriteUpdateLock;
import nxt.util.security.BlockchainPermission;
import nxt.voting.PhasingPollHome;

public final class BlockchainImpl
implements Blockchain {
    private static final BlockchainImpl instance = new BlockchainImpl();
    private static final BlockchainPermission blockchainPermission = new BlockchainPermission("getBlockchain");
    private final ReadWriteUpdateLock lock = new ReadWriteUpdateLock();
    private final AtomicReference<BlockImpl> lastBlock = new AtomicReference();

    public static BlockchainImpl getInstance() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(blockchainPermission);
        }
        return instance;
    }

    private BlockchainImpl() {
    }

    @Override
    public void readLock() {
        this.lock.readLock().lock();
    }

    @Override
    public void readUnlock() {
        this.lock.readLock().unlock();
    }

    @Override
    public void updateLock() {
        this.lock.updateLock().lock();
    }

    @Override
    public void updateUnlock() {
        this.lock.updateLock().unlock();
    }

    public void writeLock() {
        this.lock.writeLock().lock();
    }

    public void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    @Override
    public BlockImpl getLastBlock() {
        return this.lastBlock.get();
    }

    void setLastBlock(BlockImpl blockImpl) {
        this.lastBlock.set(blockImpl);
    }

    @Override
    public int getHeight() {
        BlockImpl blockImpl = this.lastBlock.get();
        return blockImpl == null ? 0 : blockImpl.getHeight();
    }

    @Override
    public int getLastBlockTimestamp() {
        BlockImpl blockImpl = this.lastBlock.get();
        return blockImpl == null ? 0 : blockImpl.getTimestamp();
    }

    @Override
    public BlockImpl getLastBlock(int n) {
        BlockImpl blockImpl = this.lastBlock.get();
        if (n >= blockImpl.getTimestamp()) {
            return blockImpl;
        }
        return BlockDb.findLastBlock(n);
    }

    @Override
    public BlockImpl getBlock(long l) {
        return this.getBlock(l, false);
    }

    @Override
    public BlockImpl getBlock(long l, boolean bl) {
        BlockImpl blockImpl = this.lastBlock.get();
        if (blockImpl.getId() == l) {
            return blockImpl;
        }
        return BlockDb.findBlock(l, bl);
    }

    @Override
    public boolean hasBlock(long l) {
        return this.lastBlock.get().getId() == l || BlockDb.hasBlock(l);
    }

    public DbIterator<BlockImpl> getAllBlocks() {
        Connection connection = null;
        this.readLock();
        try {
            connection = BlockDb.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM block ORDER BY db_id ASC");
            DbIterator<BlockImpl> dbIterator = this.getBlocks(connection, preparedStatement);
            return dbIterator;
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
        finally {
            this.readUnlock();
        }
    }

    public DbIterator<BlockImpl> getBlocks(int n, int n2) {
        Connection connection = null;
        this.readLock();
        try {
            connection = BlockDb.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM block WHERE height <= ? AND height >= ? ORDER BY height DESC");
            int n3 = this.getHeight();
            preparedStatement.setInt(1, n3 - n);
            preparedStatement.setInt(2, n3 - n2);
            DbIterator<BlockImpl> dbIterator = this.getBlocks(connection, preparedStatement);
            return dbIterator;
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
        finally {
            this.readUnlock();
        }
    }

    public DbIterator<BlockImpl> getBlocks(long l, int n) {
        return this.getBlocks(l, n, 0, -1);
    }

    public DbIterator<BlockImpl> getBlocks(long l, int n, int n2, int n3) {
        Connection connection = null;
        this.readLock();
        try {
            connection = BlockDb.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM block WHERE generator_id = ? " + (n > 0 ? " AND timestamp >= ? " : " ") + "ORDER BY height DESC" + DbUtils.limitsClause(n2, n3));
            int n4 = 0;
            preparedStatement.setLong(++n4, l);
            if (n > 0) {
                preparedStatement.setInt(++n4, n);
            }
            DbUtils.setLimits(++n4, preparedStatement, n2, n3);
            DbIterator<BlockImpl> dbIterator = this.getBlocks(connection, preparedStatement);
            return dbIterator;
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public int getBlockCount(long var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public DbIterator<BlockImpl> getBlocks(Connection connection, PreparedStatement preparedStatement) {
        return new DbIterator<BlockImpl>(connection, preparedStatement, BlockDb::loadBlock);
    }

    @Override
    public List<Long> getBlockIdsAfter(long l, int n) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        try (Connection connection = BlockDb.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("SELECT id FROM block WHERE db_id > IFNULL ((SELECT db_id FROM block WHERE id = ?), 9223372036854775807) ORDER BY db_id ASC LIMIT ?");){
            preparedStatement.setLong(1, l);
            preparedStatement.setInt(2, n);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    arrayList.add(resultSet.getLong("id"));
                }
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
        return arrayList;
    }

    public List<BlockImpl> getBlocksAfter(long l, int n) {
        if (n <= 0) {
            return Collections.emptyList();
        }
        ArrayList<BlockImpl> arrayList = new ArrayList<BlockImpl>();
        this.readLock();
        try (Connection connection = BlockDb.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM block WHERE db_id > IFNULL ((SELECT db_id FROM block WHERE id = ?), 9223372036854775807) ORDER BY db_id ASC LIMIT ?");){
            preparedStatement.setLong(1, l);
            preparedStatement.setInt(2, n);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    arrayList.add(BlockDb.loadBlock(connection, resultSet, true));
                }
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
        finally {
            this.readUnlock();
        }
        return arrayList;
    }

    public List<BlockImpl> getBlocksAfter(long l, List<Long> list) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BlockImpl> arrayList = new ArrayList<BlockImpl>();
        this.readLock();
        try (Connection connection = BlockDb.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM block WHERE db_id > IFNULL ((SELECT db_id FROM block WHERE id = ?), 9223372036854775807) ORDER BY db_id ASC LIMIT ?");){
            preparedStatement.setLong(1, l);
            preparedStatement.setInt(2, list.size());
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                int n = 0;
                while (resultSet.next()) {
                    BlockImpl blockImpl = BlockDb.loadBlock(connection, resultSet, true);
                    if (blockImpl.getId() != list.get(n++).longValue()) {
                        break;
                    }
                    arrayList.add(blockImpl);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
        finally {
            this.readUnlock();
        }
        return arrayList;
    }

    @Override
    public long getBlockIdAtHeight(int n) {
        Block block = this.lastBlock.get();
        if (n > block.getHeight()) {
            throw new IllegalArgumentException("Invalid height " + n + ", current blockchain is at " + block.getHeight());
        }
        if (n == block.getHeight()) {
            return block.getId();
        }
        return BlockDb.findBlockIdAtHeight(n);
    }

    @Override
    public BlockImpl getBlockAtHeight(int n) {
        BlockImpl blockImpl = this.lastBlock.get();
        if (n > blockImpl.getHeight()) {
            throw new IllegalArgumentException("Invalid height " + n + ", current blockchain is at " + blockImpl.getHeight());
        }
        if (n == blockImpl.getHeight()) {
            return blockImpl;
        }
        return BlockDb.findBlockAtHeight(n);
    }

    @Override
    public BlockImpl getECBlock(int n) {
        BlockImpl blockImpl = this.getLastBlock(n);
        if (blockImpl == null) {
            return this.getBlockAtHeight(0);
        }
        return BlockDb.findBlockAtHeight(Math.max(blockImpl.getHeight() - 720, 0));
    }

    @Override
    public TransactionImpl getTransaction(Chain chain, byte[] byArray) {
        return chain.getTransactionHome().findTransaction(byArray);
    }

    @Override
    public boolean hasTransaction(Chain chain, byte[] byArray) {
        return chain.getTransactionHome().hasTransaction(byArray);
    }

    @Override
    public FxtTransactionImpl getFxtTransaction(long l) {
        return TransactionHome.findFxtTransaction(l);
    }

    @Override
    public boolean hasFxtTransaction(long l) {
        return TransactionHome.hasFxtTransaction(l);
    }

    @Override
    public int getTransactionCount(Chain chain) {
        return chain.getTransactionHome().getTransactionCount();
    }

    public DbIterator<ChildTransactionImpl> getTransactions(ChildChain childChain, long l, byte by, byte by2, int n, boolean bl) {
        return this.getTransactions(childChain, l, 0, by, by2, n, false, false, false, 0, -1, bl, false);
    }

    public DbIterator<ChildTransactionImpl> getTransactions(ChildChain childChain, long l, int n, byte by, byte by2, int n2, boolean bl, boolean bl2, boolean bl3, int n3, int n4, boolean bl4, boolean bl5) {
        int n5;
        if (bl2 && bl3) {
            throw new IllegalArgumentException("At least one of phasedOnly or nonPhasedOnly must be false");
        }
        int n6 = n5 = n > 0 ? this.getHeight() - n : Integer.MAX_VALUE;
        if (n5 < 0) {
            throw new IllegalArgumentException("Number of confirmations required " + n + " exceeds current blockchain height " + this.getHeight());
        }
        Connection connection = null;
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SELECT transaction.* FROM transaction ");
            if (bl5 && !bl3) {
                stringBuilder.append(" LEFT JOIN phasing_poll_result ON transaction.id = phasing_poll_result.id ");
                stringBuilder.append(" AND transaction.full_hash = phasing_poll_result.full_hash ");
            }
            stringBuilder.append("WHERE recipient_id = ? AND sender_id <> ? ");
            if (n2 > 0) {
                stringBuilder.append("AND block_timestamp >= ? ");
            }
            if (by >= 0) {
                stringBuilder.append("AND type = ? ");
                if (by2 >= 0) {
                    stringBuilder.append("AND subtype = ? ");
                }
            }
            if (n5 < Integer.MAX_VALUE) {
                stringBuilder.append("AND transaction.height <= ? ");
            }
            if (bl) {
                stringBuilder.append("AND (has_message = TRUE OR has_encrypted_message = TRUE ");
                stringBuilder.append("OR ((has_prunable_message = TRUE OR has_prunable_encrypted_message = TRUE) AND timestamp > ?)) ");
            }
            if (bl2) {
                stringBuilder.append("AND phased = TRUE ");
            } else if (bl3) {
                stringBuilder.append("AND phased = FALSE ");
            }
            if (bl5 && !bl3) {
                stringBuilder.append("AND (phased = FALSE OR approved = TRUE) ");
            }
            stringBuilder.append("UNION ALL SELECT transaction.* FROM transaction ");
            if (bl5 && !bl3) {
                stringBuilder.append(" LEFT JOIN phasing_poll_result ON transaction.id = phasing_poll_result.id ");
                stringBuilder.append(" AND transaction.full_hash = phasing_poll_result.full_hash ");
            }
            stringBuilder.append("WHERE sender_id = ? ");
            if (n2 > 0) {
                stringBuilder.append("AND block_timestamp >= ? ");
            }
            if (by >= 0) {
                stringBuilder.append("AND type = ? ");
                if (by2 >= 0) {
                    stringBuilder.append("AND subtype = ? ");
                }
            }
            if (n5 < Integer.MAX_VALUE) {
                stringBuilder.append("AND transaction.height <= ? ");
            }
            if (bl) {
                stringBuilder.append("AND (has_message = TRUE OR has_encrypted_message = TRUE OR has_encrypttoself_message = TRUE ");
                stringBuilder.append("OR ((has_prunable_message = TRUE OR has_prunable_encrypted_message = TRUE) AND timestamp > ?)) ");
            }
            if (bl2) {
                stringBuilder.append("AND phased = TRUE ");
            } else if (bl3) {
                stringBuilder.append("AND phased = FALSE ");
            }
            if (bl5 && !bl3) {
                stringBuilder.append("AND (phased = FALSE OR approved = TRUE) ");
            }
            stringBuilder.append("ORDER BY block_timestamp DESC, transaction_index DESC");
            stringBuilder.append(DbUtils.limitsClause(n3, n4));
            connection = Db.db.getConnection(childChain.getDbSchema());
            int n7 = 0;
            PreparedStatement preparedStatement = connection.prepareStatement(stringBuilder.toString());
            preparedStatement.setLong(++n7, l);
            preparedStatement.setLong(++n7, l);
            if (n2 > 0) {
                preparedStatement.setInt(++n7, n2);
            }
            if (by >= 0) {
                preparedStatement.setByte(++n7, by);
                if (by2 >= 0) {
                    preparedStatement.setByte(++n7, by2);
                }
            }
            if (n5 < Integer.MAX_VALUE) {
                preparedStatement.setInt(++n7, n5);
            }
            int n8 = Math.max(0, Constants.INCLUDE_EXPIRED_PRUNABLE && bl4 ? Nxt.getEpochTime() - Constants.MAX_PRUNABLE_LIFETIME : Nxt.getEpochTime() - Constants.MIN_PRUNABLE_LIFETIME);
            if (bl) {
                preparedStatement.setInt(++n7, n8);
            }
            preparedStatement.setLong(++n7, l);
            if (n2 > 0) {
                preparedStatement.setInt(++n7, n2);
            }
            if (by >= 0) {
                preparedStatement.setByte(++n7, by);
                if (by2 >= 0) {
                    preparedStatement.setByte(++n7, by2);
                }
            }
            if (n5 < Integer.MAX_VALUE) {
                preparedStatement.setInt(++n7, n5);
            }
            if (bl) {
                preparedStatement.setInt(++n7, n8);
            }
            DbUtils.setLimits(++n7, preparedStatement, n3, n4);
            return this.getTransactions(childChain, connection, preparedStatement);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public DbIterator<ChildTransactionImpl> getReferencingTransactions(ChildChain childChain, byte[] byArray, int n, int n2) {
        Connection connection = null;
        try {
            connection = Db.db.getConnection(childChain.getDbSchema());
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT transaction.* FROM transaction WHERE referenced_transaction_id = ? AND referenced_transaction_full_hash = ? ORDER BY block_timestamp DESC, transaction_index DESC " + DbUtils.limitsClause(n, n2));
            int n3 = 0;
            preparedStatement.setLong(++n3, Convert.fullHashToId(byArray));
            preparedStatement.setBytes(++n3, byArray);
            DbUtils.setLimits(++n3, preparedStatement, n, n2);
            return this.getTransactions(childChain, connection, preparedStatement);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    @Override
    public DbIterator<? extends FxtTransaction> getTransactions(FxtChain fxtChain, long l, int n, byte by, byte by2, int n2, int n3, int n4) {
        int n5;
        int n6 = n5 = n > 0 ? this.getHeight() - n : Integer.MAX_VALUE;
        if (n5 < 0) {
            throw new IllegalArgumentException("Number of confirmations required " + n + " exceeds current blockchain height " + this.getHeight());
        }
        Connection connection = null;
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SELECT * FROM transaction_fxt WHERE recipient_id = ? AND sender_id <> ? ");
            if (n2 > 0) {
                stringBuilder.append("AND block_timestamp >= ? ");
            }
            if (by < 0) {
                stringBuilder.append("AND type = ? ");
                if (by2 >= 0) {
                    stringBuilder.append("AND subtype = ? ");
                }
            }
            if (n5 < Integer.MAX_VALUE) {
                stringBuilder.append("AND height <= ? ");
            }
            stringBuilder.append("UNION ALL SELECT * FROM transaction_fxt WHERE sender_id = ? ");
            if (n2 > 0) {
                stringBuilder.append("AND block_timestamp >= ? ");
            }
            if (by < 0) {
                stringBuilder.append("AND type = ? ");
                if (by2 >= 0) {
                    stringBuilder.append("AND subtype = ? ");
                }
            }
            if (n5 < Integer.MAX_VALUE) {
                stringBuilder.append("AND height <= ? ");
            }
            stringBuilder.append("ORDER BY block_timestamp DESC, transaction_index DESC");
            stringBuilder.append(DbUtils.limitsClause(n3, n4));
            connection = Db.db.getConnection(FxtChain.FXT.getDbSchema());
            int n7 = 0;
            PreparedStatement preparedStatement = connection.prepareStatement(stringBuilder.toString());
            preparedStatement.setLong(++n7, l);
            preparedStatement.setLong(++n7, l);
            if (n2 > 0) {
                preparedStatement.setInt(++n7, n2);
            }
            if (by < 0) {
                preparedStatement.setByte(++n7, by);
                if (by2 >= 0) {
                    preparedStatement.setByte(++n7, by2);
                }
            }
            if (n5 < Integer.MAX_VALUE) {
                preparedStatement.setInt(++n7, n5);
            }
            preparedStatement.setLong(++n7, l);
            if (n2 > 0) {
                preparedStatement.setInt(++n7, n2);
            }
            if (by < 0) {
                preparedStatement.setByte(++n7, by);
                if (by2 >= 0) {
                    preparedStatement.setByte(++n7, by2);
                }
            }
            if (n5 < Integer.MAX_VALUE) {
                preparedStatement.setInt(++n7, n5);
            }
            DbUtils.setLimits(++n7, preparedStatement, n3, n4);
            return this.getTransactions(fxtChain, connection, preparedStatement);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public DbIterator<FxtTransactionImpl> getTransactions(final FxtChain fxtChain, Connection connection, PreparedStatement preparedStatement) {
        return new DbIterator<FxtTransactionImpl>(connection, preparedStatement, new DbIterator.ResultSetReader<FxtTransactionImpl>(){

            @Override
            public FxtTransactionImpl get(Connection connection, ResultSet resultSet) throws Exception {
                return (FxtTransactionImpl)TransactionImpl.loadTransaction(fxtChain, resultSet);
            }
        });
    }

    public DbIterator<ChildTransactionImpl> getTransactions(final ChildChain childChain, Connection connection, PreparedStatement preparedStatement) {
        return new DbIterator<ChildTransactionImpl>(connection, preparedStatement, new DbIterator.ResultSetReader<ChildTransactionImpl>(){

            @Override
            public ChildTransactionImpl get(Connection connection, ResultSet resultSet) throws Exception {
                return (ChildTransactionImpl)TransactionImpl.loadTransaction(childChain, resultSet);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TransactionImpl> getExpectedTransactions(Filter<Transaction> filter) {
        HashMap<TransactionType, Map<String, Integer>> hashMap = new HashMap<TransactionType, Map<String, Integer>>();
        BlockchainProcessorImpl blockchainProcessorImpl = BlockchainProcessorImpl.getInstance();
        ArrayList<TransactionImpl> arrayList = new ArrayList<TransactionImpl>();
        this.readLock();
        try {
            for (ChildTransaction childTransaction : PhasingPollHome.getFinishingTransactions(this.getHeight() + 1)) {
                try {
                    childTransaction.validate();
                    if (((ChildTransactionImpl)childTransaction).attachmentIsDuplicate(hashMap, false) || !filter.ok(childTransaction)) continue;
                    arrayList.add((ChildTransactionImpl)childTransaction);
                }
                catch (NxtException.ValidationException validationException) {}
            }
            blockchainProcessorImpl.selectUnconfirmedFxtTransactions(hashMap, this.getLastBlock(), -1).forEach(unconfirmedFxtTransaction -> {
                FxtTransactionImpl fxtTransactionImpl = unconfirmedFxtTransaction.getTransaction();
                if (filter.ok(fxtTransactionImpl)) {
                    arrayList.add(fxtTransactionImpl);
                }
                fxtTransactionImpl.getChildTransactions().forEach(childTransactionImpl -> {
                    if (filter.ok((Transaction)childTransactionImpl)) {
                        arrayList.add((TransactionImpl)childTransactionImpl);
                    }
                });
            });
        }
        finally {
            this.readUnlock();
        }
        return arrayList;
    }

    @Override
    public DbIterator<? extends Transaction> getExecutedTransactions(Chain chain, long l, long l2, byte by, byte by2, int n, int n2, int n3, int n4) {
        Connection connection = null;
        try {
            String string;
            String string2;
            boolean bl = chain instanceof ChildChain;
            if (n > 0) {
                string2 = " AND transaction.block_timestamp = (SELECT timestamp FROM block WHERE height = ? LIMIT 1) ";
                string = " AND phasing_poll_result.height = ? ";
            } else {
                if (l == 0L && l2 == 0L) {
                    throw new IllegalArgumentException("Sender or recipient expected");
                }
                if (n2 > 0) {
                    n = this.getHeight() - n2;
                    if (n < 0) {
                        throw new IllegalArgumentException("Number of confirmations required " + n2 + " exceeds current blockchain height " + this.getHeight());
                    }
                    string2 = " AND transaction.height <= ? ";
                    string = " AND phasing_poll_result.height <= ? ";
                } else {
                    string2 = null;
                    string = null;
                }
            }
            boolean bl2 = bl && by >= 0 || !bl && by < 0;
            StringBuilder stringBuilder = new StringBuilder();
            if (l != 0L) {
                stringBuilder.append(" AND transaction.sender_id = ? ");
            }
            if (l2 != 0L) {
                stringBuilder.append(" AND transaction.recipient_id = ? ");
            }
            if (bl2) {
                stringBuilder.append(" AND transaction.type = ? ");
                if (by2 >= 0) {
                    stringBuilder.append(" AND transaction.subtype = ? ");
                }
            }
            StringBuilder stringBuilder2 = new StringBuilder();
            if (bl) {
                stringBuilder2.append("SELECT transaction.*, transaction.height AS execution_height FROM transaction WHERE transaction.phased = FALSE ").append((CharSequence)stringBuilder);
            } else {
                stringBuilder2.append("SELECT * FROM transaction_fxt AS transaction WHERE TRUE ").append((CharSequence)stringBuilder);
            }
            if (string2 != null) {
                stringBuilder2.append(string2);
            }
            if (bl) {
                stringBuilder2.append("UNION ALL SELECT transaction.*, phasing_poll_result.height AS execution_height FROM transaction ");
                stringBuilder2.append(" JOIN phasing_poll_result ON transaction.id = phasing_poll_result.id ");
                stringBuilder2.append("  AND transaction.full_hash = phasing_poll_result.full_hash ");
                stringBuilder2.append(" WHERE transaction.phased = TRUE AND phasing_poll_result.approved = TRUE ");
                stringBuilder2.append((CharSequence)stringBuilder);
                if (string2 != null) {
                    stringBuilder2.append(string);
                }
                stringBuilder2.append("ORDER BY execution_height DESC, transaction_index DESC");
            } else {
                stringBuilder2.append("ORDER BY block_timestamp DESC, transaction_index DESC");
            }
            stringBuilder2.append(DbUtils.limitsClause(n3, n4));
            connection = Db.db.getConnection(chain.getDbSchema());
            int n5 = 0;
            PreparedStatement preparedStatement = connection.prepareStatement(stringBuilder2.toString());
            boolean bl3 = false;
            do {
                if (l != 0L) {
                    preparedStatement.setLong(++n5, l);
                }
                if (l2 != 0L) {
                    preparedStatement.setLong(++n5, l2);
                }
                if (bl2) {
                    preparedStatement.setByte(++n5, by);
                    if (by2 >= 0) {
                        preparedStatement.setByte(++n5, by2);
                    }
                }
                if (string2 != null) {
                    preparedStatement.setInt(++n5, n);
                }
                if (!bl) continue;
                boolean bl4 = bl3 = !bl3;
            } while (bl3);
            DbUtils.setLimits(++n5, preparedStatement, n3, n4);
            if (bl) {
                return this.getTransactions((ChildChain)chain, connection, preparedStatement);
            }
            return this.getTransactions((FxtChain)chain, connection, preparedStatement);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }
}

