/*
 * Decompiled with CFR 0.152.
 */
package nxt.blockchain;

import java.util.List;
import nxt.NxtException;
import nxt.blockchain.Block;
import nxt.blockchain.BlockImpl;
import nxt.blockchain.Chain;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionImpl;
import nxt.db.DerivedDbTable;
import nxt.peer.Peer;
import nxt.util.JSON;
import nxt.util.Observable;
import org.json.simple.JSONAware;

public interface BlockchainProcessor
extends Observable<Block, Event> {
    public Peer getLastBlockchainFeeder();

    public int getLastBlockchainFeederHeight();

    public boolean isScanning();

    public boolean isDownloading();

    public boolean isProcessingBlock();

    public void suspendDownload(boolean var1);

    public boolean isDownloadSuspended();

    public int getMinRollbackHeight();

    public int getInitialScanHeight();

    public void processPeerBlock(Block var1) throws NxtException;

    public void processPeerBlocks(List<Block> var1) throws NxtException;

    public void fullReset();

    public void scan(int var1, boolean var2);

    public void fullScanWithShutdown();

    public void setGetMoreBlocks(boolean var1);

    public List<? extends Block> popOffTo(int var1);

    public void registerDerivedTable(DerivedDbTable var1);

    public void trimDerivedTables();

    public int restorePrunedData(Chain var1);

    public Transaction restorePrunedTransaction(Chain var1, byte[] var2);

    public long getGenesisBlockId();

    public static class BlockOfLowerDifficultyException
    extends BlockNotAcceptedException {
        public BlockOfLowerDifficultyException(BlockImpl blockImpl) {
            super("Lower cumulative difficulty", blockImpl);
        }

        @Override
        public String getMessage() {
            return "Lower cumulative difficulty block " + ((BlockNotAcceptedException)this).block.getStringId();
        }
    }

    public static class BlockOutOfOrderException
    extends BlockNotAcceptedException {
        public BlockOutOfOrderException(String string, BlockImpl blockImpl) {
            super(string, blockImpl);
        }
    }

    public static class TransactionNotAcceptedException
    extends BlockNotAcceptedException {
        private final TransactionImpl transaction;

        TransactionNotAcceptedException(String string, TransactionImpl transactionImpl) {
            super(string, transactionImpl.getBlock());
            this.transaction = transactionImpl;
        }

        TransactionNotAcceptedException(Throwable throwable, TransactionImpl transactionImpl) {
            super(throwable, transactionImpl.getBlock());
            this.transaction = transactionImpl;
        }

        TransactionImpl getTransaction() {
            return this.transaction;
        }

        @Override
        public String getMessage() {
            return "Invalid transaction " + this.transaction.getStringId() + " " + JSON.toJSONString((JSONAware)this.transaction.getJSONObject()) + ",\n" + super.getMessage();
        }
    }

    public static class BlockNotAcceptedException
    extends NxtException {
        private final BlockImpl block;

        public BlockNotAcceptedException(String string, BlockImpl blockImpl) {
            super(string);
            this.block = blockImpl;
        }

        public BlockNotAcceptedException(Throwable throwable, BlockImpl blockImpl) {
            super(throwable);
            this.block = blockImpl;
        }

        @Override
        public String getMessage() {
            return this.block == null ? super.getMessage() : super.getMessage() + ", block " + this.block.getStringId() + " " + this.block.toString();
        }
    }

    public static enum Event {
        BLOCK_PUSHED,
        BLOCK_POPPED,
        BLOCK_GENERATED,
        BLOCK_SCANNED,
        RESCAN_BEGIN,
        RESCAN_END,
        BEFORE_BLOCK_ACCEPT,
        AFTER_BLOCK_ACCEPT,
        BEFORE_BLOCK_APPLY,
        AFTER_BLOCK_APPLY;

    }
}

