/*
 * Decompiled with CFR 0.152.
 */
package nxt.blockchain;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.List;
import nxt.NxtException;
import nxt.blockchain.Appendix;
import nxt.blockchain.Attachment;
import nxt.blockchain.ChildBlockFxtTransactionType;
import nxt.blockchain.ChildChain;
import nxt.blockchain.ChildTransaction;
import nxt.blockchain.ChildTransactionImpl;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionHome;
import nxt.blockchain.TransactionType;
import nxt.crypto.Crypto;
import nxt.util.Convert;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ChildBlockAttachment
extends Attachment.AbstractAttachment
implements Appendix.Prunable {
    public static final Appendix.Parser appendixParser = new Appendix.Parser(){

        @Override
        public Appendix.AbstractAppendix parse(ByteBuffer byteBuffer) {
            return new ChildBlockAttachment(byteBuffer);
        }

        @Override
        public Appendix.AbstractAppendix parse(JSONObject jSONObject) throws NxtException.NotValidException {
            if (!Appendix.hasAppendix(ChildBlockFxtTransactionType.INSTANCE.getName(), jSONObject)) {
                return null;
            }
            return new ChildBlockAttachment(jSONObject);
        }
    };
    private final int chainId;
    private volatile byte[][] childTransactionFullHashes;
    private final byte[] hash;

    ChildBlockAttachment(ByteBuffer byteBuffer) {
        super(byteBuffer);
        byte by = byteBuffer.get();
        if ((by & 1) != 0) {
            this.chainId = byteBuffer.getInt();
            int n = byteBuffer.getShort() & 0xFFFF;
            this.childTransactionFullHashes = new byte[n][];
            for (int i = 0; i < n; ++i) {
                this.childTransactionFullHashes[i] = new byte[32];
                byteBuffer.get(this.childTransactionFullHashes[i]);
            }
            this.hash = null;
        } else {
            this.chainId = byteBuffer.getInt();
            this.hash = new byte[32];
            byteBuffer.get(this.hash);
            this.childTransactionFullHashes = null;
        }
    }

    ChildBlockAttachment(JSONObject jSONObject) throws NxtException.NotValidException {
        super(jSONObject);
        this.chainId = ((Long)jSONObject.get((Object)"chain")).intValue();
        JSONArray jSONArray = (JSONArray)jSONObject.get((Object)"childTransactionFullHashes");
        if (jSONArray != null) {
            this.childTransactionFullHashes = new byte[jSONArray.size()][];
            for (int i = 0; i < this.childTransactionFullHashes.length; ++i) {
                this.childTransactionFullHashes[i] = Convert.parseHexString((String)jSONArray.get(i));
                if (this.childTransactionFullHashes[i].length == 32) continue;
                throw new NxtException.NotValidException("Invalid child transaction full hash " + Convert.toHexString(this.childTransactionFullHashes[i]));
            }
            this.hash = null;
        } else {
            this.hash = Convert.parseHexString(Convert.emptyToNull((String)jSONObject.get((Object)"hash")));
            this.childTransactionFullHashes = null;
        }
    }

    public ChildBlockAttachment(List<? extends ChildTransaction> list) throws NxtException.NotValidException {
        if (list == null || list.isEmpty()) {
            throw new NxtException.NotValidException("Empty ChildBlockAttachment not allowed");
        }
        this.chainId = list.get(0).getChain().getId();
        this.childTransactionFullHashes = new byte[list.size()][];
        this.hash = null;
        for (int i = 0; i < this.childTransactionFullHashes.length; ++i) {
            ChildTransactionImpl childTransactionImpl = (ChildTransactionImpl)list.get(i);
            this.childTransactionFullHashes[i] = childTransactionImpl.getFullHash();
        }
        Arrays.sort(this.childTransactionFullHashes, Convert.byteArrayComparator);
    }

    @Override
    public int getMyFullSize() {
        if (!this.hasPrunableData()) {
            throw new IllegalStateException("Prunable data not available");
        }
        return 7 + 32 * this.childTransactionFullHashes.length;
    }

    @Override
    protected int getMySize() {
        return 37;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byteBuffer.put((byte)0);
        byteBuffer.putInt(this.chainId);
        byteBuffer.put(this.getHash());
    }

    @Override
    public void putMyPrunableBytes(ByteBuffer byteBuffer) {
        if (!this.hasPrunableData()) {
            throw new IllegalStateException("Prunable data not available");
        }
        byteBuffer.put((byte)1);
        byteBuffer.putInt(this.chainId);
        byteBuffer.putShort((short)this.childTransactionFullHashes.length);
        for (byte[] byArray : this.childTransactionFullHashes) {
            byteBuffer.put(byArray);
        }
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"chain", (Object)this.chainId);
        if (this.childTransactionFullHashes != null) {
            JSONArray jSONArray = new JSONArray();
            jSONObject.put((Object)"childTransactionFullHashes", (Object)jSONArray);
            for (byte[] byArray : this.childTransactionFullHashes) {
                jSONArray.add((Object)Convert.toHexString(byArray));
            }
        }
        jSONObject.put((Object)"hash", (Object)Convert.toHexString(this.getHash()));
    }

    @Override
    public TransactionType getTransactionType() {
        return ChildBlockFxtTransactionType.INSTANCE;
    }

    public int getChainId() {
        return this.chainId;
    }

    public byte[][] getChildTransactionFullHashes() {
        return this.childTransactionFullHashes;
    }

    @Override
    public byte[] getHash() {
        if (this.hash != null) {
            return this.hash;
        }
        if (this.childTransactionFullHashes != null) {
            MessageDigest messageDigest = Crypto.sha256();
            for (byte[] byArray : this.childTransactionFullHashes) {
                messageDigest.update(byArray);
            }
            return messageDigest.digest();
        }
        throw new IllegalStateException("Both hash and childTransactionFullHashes are null");
    }

    @Override
    public void loadPrunable(Transaction transaction, boolean bl) {
        if (this.childTransactionFullHashes == null) {
            TransactionHome transactionHome = ChildChain.getChildChain(this.chainId).getTransactionHome();
            List<byte[]> list = transactionHome.findChildTransactionFullHashes(transaction.getId());
            byte[][] byArray = (byte[][])list.toArray((T[])new byte[list.size()][]);
            Arrays.sort(byArray, Convert.byteArrayComparator);
            this.childTransactionFullHashes = byArray;
        }
    }

    @Override
    public boolean hasPrunableData() {
        return this.childTransactionFullHashes != null;
    }

    @Override
    public void restorePrunableData(Transaction transaction, int n, int n2) {
        throw new UnsupportedOperationException("Pruning of child transactions not yet implemented");
    }
}

