/*
 * Decompiled with CFR 0.152.
 */
package nxt.blockchain;

import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import nxt.Nxt;
import nxt.NxtException;
import nxt.blockchain.BlockImpl;
import nxt.blockchain.BlockchainImpl;
import nxt.blockchain.ChildBlockAttachment;
import nxt.blockchain.ChildBlockFxtTransaction;
import nxt.blockchain.ChildChain;
import nxt.blockchain.ChildTransaction;
import nxt.blockchain.ChildTransactionImpl;
import nxt.blockchain.FxtTransactionImpl;
import nxt.blockchain.TransactionHome;
import nxt.blockchain.TransactionProcessorImpl;
import nxt.blockchain.UnconfirmedTransaction;
import nxt.crypto.Crypto;
import nxt.util.Convert;

final class ChildBlockFxtTransactionImpl
extends FxtTransactionImpl
implements ChildBlockFxtTransaction {
    private volatile List<ChildTransactionImpl> childTransactions;
    private volatile List<ChildTransactionImpl> sortedChildTransactions;

    ChildBlockFxtTransactionImpl(FxtTransactionImpl.BuilderImpl builderImpl, String string, boolean bl) throws NxtException.NotValidException {
        super(builderImpl, string, bl);
    }

    @Override
    public ChildChain getChildChain() {
        return ChildChain.getChildChain(((ChildBlockAttachment)this.attachment).getChainId());
    }

    @Override
    public byte[][] getChildTransactionFullHashes() {
        return ((ChildBlockAttachment)this.getAttachment()).getChildTransactionFullHashes();
    }

    @Override
    void setBlock(BlockImpl blockImpl) {
        super.setBlock(blockImpl);
        if (this.childTransactions != null) {
            short s = this.getIndex();
            for (ChildTransactionImpl childTransactionImpl : this.getSortedChildTransactions()) {
                childTransactionImpl.setFxtTransaction(this);
                s = (short)(s + 1);
                childTransactionImpl.setIndex(s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void unsetBlock() {
        super.unsetBlock();
        this.getChildTransactions().forEach(ChildTransactionImpl::unsetFxtTransaction);
        ChildBlockFxtTransactionImpl childBlockFxtTransactionImpl = this;
        synchronized (childBlockFxtTransactionImpl) {
            this.childTransactions = null;
            this.sortedChildTransactions = null;
        }
    }

    @Override
    public void validate() throws NxtException.ValidationException {
        if (this.getDeadline() > 15) {
            throw new NxtException.NotValidException("ChildBlockTransaction deadline cannot exceed 15 minutes");
        }
        try {
            this.getChildTransactions();
        }
        catch (IllegalStateException illegalStateException) {
            throw new NxtException.NotCurrentlyValidException("Missing or invalid child transaction", illegalStateException);
        }
        super.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ChildTransactionImpl> getChildTransactions() {
        List<ChildTransactionImpl> list;
        Object object;
        List<ChildTransactionImpl> list2 = this.childTransactions;
        if (list2 != null) {
            return list2;
        }
        ChildBlockAttachment childBlockAttachment = (ChildBlockAttachment)this.getAttachment();
        byte[][] byArray = childBlockAttachment.getChildTransactionFullHashes();
        BlockchainImpl.getInstance().writeLock();
        try {
            if (this.getSignature() != null && TransactionHome.hasFxtTransaction(this.getId(), Nxt.getBlockchain().getHeight() + 1)) {
                object = this.getBlock();
                if (object == null) {
                    throw new IllegalStateException(String.format("Block not set for transaction %s", this.getStringId()));
                }
                TransactionHome transactionHome = ChildChain.getChildChain(childBlockAttachment.getChainId()).getTransactionHome();
                List<ChildTransactionImpl> list3 = transactionHome.findChildTransactions(this.getId());
                if (list3.size() > 0 && list3.get(0).getBlockId() != ((BlockImpl)object).getId()) {
                    throw new IllegalStateException(String.format("Transaction %s is now in a different block", this.getStringId()));
                }
                for (ChildTransactionImpl childTransactionImpl : list3) {
                    childTransactionImpl.setBlock((BlockImpl)object);
                }
                list = Collections.unmodifiableList(list3);
                list2 = list;
            } else {
                object = TransactionProcessorImpl.getInstance();
                ArrayList<ChildTransactionImpl> arrayList = new ArrayList<ChildTransactionImpl>(byArray.length);
                for (byte[] byArray2 : byArray) {
                    UnconfirmedTransaction unconfirmedTransaction = ((TransactionProcessorImpl)object).getUnconfirmedTransaction(Convert.fullHashToId(byArray2));
                    if (unconfirmedTransaction == null) {
                        throw new IllegalStateException(String.format("Missing child transaction %s", Convert.toHexString(byArray2)));
                    }
                    if (!Arrays.equals(unconfirmedTransaction.getFullHash(), byArray2)) {
                        throw new IllegalStateException(String.format("Unconfirmed transaction hash mismatch %s %s", Convert.toHexString(byArray2), Convert.toHexString(unconfirmedTransaction.getFullHash())));
                    }
                    arrayList.add((ChildTransactionImpl)unconfirmedTransaction.getTransaction());
                }
                list2 = Collections.unmodifiableList(arrayList);
                list = null;
            }
        }
        finally {
            BlockchainImpl.getInstance().writeUnlock();
        }
        object = this;
        synchronized (object) {
            this.sortedChildTransactions = list;
            this.childTransactions = list2;
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ChildTransactionImpl> getSortedChildTransactions() {
        this.getChildTransactions();
        List<ChildTransactionImpl> list = this.sortedChildTransactions;
        if (list != null) {
            return list;
        }
        BlockImpl blockImpl = this.getBlock();
        if (blockImpl == null || blockImpl.getBlockSignature() == null) {
            throw new IllegalStateException("Can't sort child transactions if not in a signed block yet");
        }
        byte[] byArray = Crypto.sha256().digest(blockImpl.bytes());
        TreeMap treeMap = new TreeMap(Convert.byteArrayComparator);
        this.childTransactions.forEach(childTransactionImpl -> {
            MessageDigest messageDigest = Crypto.sha256();
            messageDigest.update(childTransactionImpl.getFullHash());
            messageDigest.update(byArray);
            treeMap.put(messageDigest.digest(), childTransactionImpl);
        });
        list = Collections.unmodifiableList(new ArrayList(treeMap.values()));
        ChildBlockFxtTransactionImpl childBlockFxtTransactionImpl = this;
        synchronized (childBlockFxtTransactionImpl) {
            this.sortedChildTransactions = list;
            this.childTransactions = this.sortedChildTransactions;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setChildTransactions(List<? extends ChildTransaction> list, byte[] byArray) throws NxtException.NotValidException {
        byte[][] byArray2 = this.getChildTransactionFullHashes();
        if (list.size() != byArray2.length) {
            throw new NxtException.NotValidException(String.format("Child transactions size %d does not match child hashes count %d", list.size(), byArray2.length));
        }
        ArrayList<ChildTransactionImpl> arrayList = new ArrayList<ChildTransactionImpl>();
        byte[] byArray3 = Convert.EMPTY_BYTE;
        for (int i = 0; i < byArray2.length; ++i) {
            ChildTransactionImpl childTransactionImpl = (ChildTransactionImpl)list.get(i);
            if (Arrays.binarySearch(byArray2, childTransactionImpl.getFullHash(), Convert.byteArrayComparator) < 0) {
                throw new NxtException.NotValidException(String.format("Child transaction full hash is not present in the childTransactionFullHashes: %s", Convert.toHexString(childTransactionImpl.getFullHash())));
            }
            MessageDigest messageDigest = Crypto.sha256();
            messageDigest.update(childTransactionImpl.getFullHash());
            messageDigest.update(byArray);
            byte[] byArray4 = messageDigest.digest();
            if (Convert.byteArrayComparator.compare(byArray3, byArray4) >= 0) {
                throw new NxtException.NotValidException(String.format("Child transactions are not correctly sorted for child block %s", this.getStringId()));
            }
            byArray3 = byArray4;
            arrayList.add(childTransactionImpl);
        }
        ChildBlockFxtTransactionImpl childBlockFxtTransactionImpl = this;
        synchronized (childBlockFxtTransactionImpl) {
            this.sortedChildTransactions = Collections.unmodifiableList(arrayList);
            this.childTransactions = this.sortedChildTransactions;
        }
    }

    @Override
    void save(Connection connection, String string) throws SQLException {
        super.save(connection, string);
        ChildBlockAttachment childBlockAttachment = (ChildBlockAttachment)this.getAttachment();
        String string2 = ChildChain.getChildChain(childBlockAttachment.getChainId()).getSchemaTable("transaction");
        if (this.childTransactions == null) {
            throw new IllegalStateException("Child transactions must be loaded first");
        }
        BlockImpl blockImpl = this.getBlock();
        byte[] byArray = Crypto.sha256().digest(blockImpl.bytes());
        byte[] byArray2 = Convert.EMPTY_BYTE;
        short s = this.getIndex();
        for (ChildTransactionImpl childTransactionImpl : this.getSortedChildTransactions()) {
            if (childTransactionImpl.getFxtTransactionId() != this.getId()) {
                throw new IllegalStateException(String.format("Child transaction fxtTransactionId set to %s, must be %s", Long.toUnsignedString(childTransactionImpl.getFxtTransactionId()), Long.toUnsignedString(this.getId())));
            }
            if (childTransactionImpl.getBlockId() != blockImpl.getId()) {
                throw new IllegalStateException(String.format("Child transaction blockId set to %s, must be %s", Long.toUnsignedString(childTransactionImpl.getBlockId()), blockImpl.getStringId()));
            }
            s = (short)(s + 1);
            if (childTransactionImpl.getIndex() != s) {
                throw new IllegalStateException(String.format("Child transaction index set to %d, must be %d", childTransactionImpl.getIndex(), s));
            }
            MessageDigest messageDigest = Crypto.sha256();
            messageDigest.update(childTransactionImpl.getFullHash());
            messageDigest.update(byArray);
            byte[] byArray3 = messageDigest.digest();
            if (Convert.byteArrayComparator.compare(byArray2, byArray3) >= 0) {
                throw new IllegalStateException(String.format("Child transactions are not correctly sorted for child block %s", this.getStringId()));
            }
            byArray2 = byArray3;
            childTransactionImpl.save(connection, string2);
        }
    }

    @Override
    public long[] getBackFees() {
        long l = this.getFee() / 4L;
        return new long[]{l, l, l};
    }

    @Override
    boolean hasAllReferencedTransactions(int n, int n2) {
        try {
            for (ChildTransactionImpl childTransactionImpl : this.getChildTransactions()) {
                if (childTransactionImpl.hasAllReferencedTransactions(n, n2)) continue;
                return false;
            }
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }

    boolean containsAll(Collection<? extends ChildTransaction> collection) {
        byte[][] byArray = this.getChildTransactionFullHashes();
        for (ChildTransaction childTransaction : collection) {
            if (Arrays.binarySearch(byArray, childTransaction.getFullHash(), Convert.byteArrayComparator) >= 0) continue;
            return false;
        }
        return true;
    }
}

