/*
 * Decompiled with CFR 0.152.
 */
package nxt.blockchain;

import java.nio.ByteBuffer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nxt.Constants;
import nxt.Nxt;
import nxt.NxtException;
import nxt.ae.AssetDividendHome;
import nxt.ae.OrderHome;
import nxt.ae.TradeHome;
import nxt.aliases.AliasHome;
import nxt.aliases.AliasTransactionType;
import nxt.blockchain.Appendix;
import nxt.blockchain.Attachment;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildChainLoader;
import nxt.blockchain.ChildTransactionImpl;
import nxt.blockchain.TransactionType;
import nxt.blockchain.UnconfirmedChildTransaction;
import nxt.blockchain.UnconfirmedTransaction;
import nxt.dgs.DigitalGoodsHome;
import nxt.dgs.DigitalGoodsTransactionType;
import nxt.http.APIEnum;
import nxt.http.APITag;
import nxt.ms.CurrencyFounderHome;
import nxt.ms.ExchangeHome;
import nxt.ms.ExchangeOfferHome;
import nxt.ms.ExchangeRequestHome;
import nxt.ms.MonetarySystemTransactionType;
import nxt.shuffling.ShufflingHome;
import nxt.shuffling.ShufflingParticipantHome;
import nxt.shuffling.ShufflingTransactionType;
import nxt.taggeddata.TaggedDataHome;
import nxt.taggeddata.TaggedDataTransactionType;
import nxt.voting.PhasingPollHome;
import nxt.voting.PhasingVoteHome;
import nxt.voting.PollHome;
import nxt.voting.VoteHome;
import org.json.simple.JSONObject;

public class ChildChain
extends Chain {
    private static final Map<String, ChildChain> childChains = new HashMap<String, ChildChain>();
    private static final Map<Integer, ChildChain> childChainsById = new HashMap<Integer, ChildChain>();
    private static final Collection<ChildChain> allChildChains = Collections.unmodifiableCollection(childChains.values());
    public static final ChildChain IGNIS = new ChildChain(2, "IGNIS", 8, Constants.isTestnet ? 99972484729793502L : 99944969459860052L, (Constants.isTestnet ? 7 : 10) * 100000000, Collections.emptySet(), EnumSet.noneOf(APIEnum.class), EnumSet.noneOf(APITag.class));
    public static final ChildChain AEUR = new ChildChain(3, "AEUR", 4, Constants.isTestnet ? 9997248455672L : 100000000000L, 0L, new LinkedHashSet<TransactionType>(Collections.singletonList(ShufflingTransactionType.SHUFFLING_CREATION)), EnumSet.noneOf(APIEnum.class), EnumSet.of(APITag.SHUFFLING));
    public static final ChildChain BITSWIFT = new ChildChain(4, "BITSWIFT", 8, Constants.isTestnet ? 388463474549710L : 388463474539339L, 1000000000L, new LinkedHashSet<TransactionType>(Collections.singletonList(DigitalGoodsTransactionType.LISTING)), EnumSet.noneOf(APIEnum.class), EnumSet.of(APITag.DGS));
    public static final ChildChain MPG = new ChildChain(5, "MPG", 8, 100000000000000000L, 0L, new LinkedHashSet<TransactionType>(Arrays.asList(ShufflingTransactionType.SHUFFLING_CREATION, DigitalGoodsTransactionType.LISTING, MonetarySystemTransactionType.CURRENCY_ISSUANCE, MonetarySystemTransactionType.CURRENCY_DELETION, MonetarySystemTransactionType.CURRENCY_MINTING, MonetarySystemTransactionType.CURRENCY_TRANSFER, MonetarySystemTransactionType.PUBLISH_EXCHANGE_OFFER, MonetarySystemTransactionType.EXCHANGE_BUY, MonetarySystemTransactionType.EXCHANGE_SELL, MonetarySystemTransactionType.RESERVE_INCREASE, MonetarySystemTransactionType.RESERVE_CLAIM, TaggedDataTransactionType.TAGGED_DATA_UPLOAD, AliasTransactionType.ALIAS_ASSIGNMENT)), (EnumSet)EnumSet.noneOf(APIEnum.class), (EnumSet)EnumSet.of(APITag.SHUFFLING, APITag.DGS, APITag.MS, APITag.DATA, APITag.ALIASES)){

        @Override
        public boolean isEnabled() {
            return Nxt.getBlockchain().getHeight() >= Constants.MPG_BLOCK;
        }
    };
    public final long SHUFFLING_DEPOSIT_NQT;
    private final AliasHome aliasHome;
    private final AssetDividendHome assetDividendHome;
    private final CurrencyFounderHome currencyFounderHome;
    private final DigitalGoodsHome digitalGoodsHome;
    private final ExchangeHome exchangeHome;
    private final ExchangeOfferHome exchangeOfferHome;
    private final ExchangeRequestHome exchangeRequestHome;
    private final OrderHome orderHome;
    private final PhasingPollHome phasingPollHome;
    private final PhasingVoteHome phasingVoteHome;
    private final PollHome pollHome;
    private final ShufflingHome shufflingHome;
    private final ShufflingParticipantHome shufflingParticipantHome;
    private final TaggedDataHome taggedDataHome;
    private final TradeHome tradeHome;
    private final VoteHome voteHome;
    private final Set<TransactionType> disabledTransactionTypes;

    public static ChildChain getChildChain(String string) {
        return childChains.get(string);
    }

    public static ChildChain getChildChain(int n) {
        return childChainsById.get(n);
    }

    public static Collection<ChildChain> getAll() {
        return allChildChains;
    }

    public static void init() {
        ChildChainLoader.init();
    }

    private ChildChain(int n, String string, int n2, long l, long l2, Set<TransactionType> set, EnumSet<APIEnum> enumSet, EnumSet<APITag> enumSet2) {
        super(n, string, n2, l, enumSet, enumSet2);
        this.SHUFFLING_DEPOSIT_NQT = l2;
        this.aliasHome = AliasHome.forChain(this);
        this.assetDividendHome = AssetDividendHome.forChain(this);
        this.currencyFounderHome = CurrencyFounderHome.forChain(this);
        this.digitalGoodsHome = DigitalGoodsHome.forChain(this);
        this.exchangeHome = ExchangeHome.forChain(this);
        this.exchangeOfferHome = ExchangeOfferHome.forChain(this);
        this.exchangeRequestHome = ExchangeRequestHome.forChain(this);
        this.tradeHome = TradeHome.forChain(this);
        this.orderHome = OrderHome.forChain(this);
        this.phasingVoteHome = PhasingVoteHome.forChain(this);
        this.phasingPollHome = PhasingPollHome.forChain(this);
        this.pollHome = PollHome.forChain(this);
        this.shufflingHome = ShufflingHome.forChain(this);
        this.shufflingParticipantHome = ShufflingParticipantHome.forChain(this);
        this.taggedDataHome = TaggedDataHome.forChain(this);
        this.voteHome = VoteHome.forChain(this);
        this.disabledTransactionTypes = Collections.unmodifiableSet(set);
        childChains.put(string, this);
        childChainsById.put(n, this);
    }

    public AliasHome getAliasHome() {
        return this.aliasHome;
    }

    public AssetDividendHome getAssetDividendHome() {
        return this.assetDividendHome;
    }

    public CurrencyFounderHome getCurrencyFounderHome() {
        return this.currencyFounderHome;
    }

    public DigitalGoodsHome getDigitalGoodsHome() {
        return this.digitalGoodsHome;
    }

    public ExchangeHome getExchangeHome() {
        return this.exchangeHome;
    }

    public ExchangeOfferHome getExchangeOfferHome() {
        return this.exchangeOfferHome;
    }

    public ExchangeRequestHome getExchangeRequestHome() {
        return this.exchangeRequestHome;
    }

    public OrderHome getOrderHome() {
        return this.orderHome;
    }

    public PhasingPollHome getPhasingPollHome() {
        return this.phasingPollHome;
    }

    public PhasingVoteHome getPhasingVoteHome() {
        return this.phasingVoteHome;
    }

    public PollHome getPollHome() {
        return this.pollHome;
    }

    public ShufflingHome getShufflingHome() {
        return this.shufflingHome;
    }

    public ShufflingParticipantHome getShufflingParticipantHome() {
        return this.shufflingParticipantHome;
    }

    public TaggedDataHome getTaggedDataHome() {
        return this.taggedDataHome;
    }

    public TradeHome getTradeHome() {
        return this.tradeHome;
    }

    public VoteHome getVoteHome() {
        return this.voteHome;
    }

    @Override
    public boolean isAllowed(TransactionType transactionType) {
        return transactionType.getType() >= 0 && !this.disabledTransactionTypes.contains(transactionType) && (this == IGNIS || !transactionType.isGlobal());
    }

    @Override
    public Set<TransactionType> getDisabledTransactionTypes() {
        return this.disabledTransactionTypes;
    }

    public boolean isEnabled() {
        return true;
    }

    @Override
    public ChildTransactionImpl.BuilderImpl newTransactionBuilder(byte[] byArray, long l, long l2, short s, Attachment attachment) {
        return ChildTransactionImpl.newTransactionBuilder(this.getId(), (byte)1, byArray, l, l2, s, (Attachment.AbstractAttachment)attachment);
    }

    @Override
    ChildTransactionImpl.BuilderImpl newTransactionBuilder(byte by, byte[] byArray, long l, long l2, short s, List<Appendix.AbstractAppendix> list, JSONObject jSONObject) {
        return ChildTransactionImpl.newTransactionBuilder(this.getId(), by, byArray, l, l2, s, list, jSONObject);
    }

    @Override
    ChildTransactionImpl.BuilderImpl newTransactionBuilder(byte by, byte[] byArray, long l, long l2, short s, List<Appendix.AbstractAppendix> list, ByteBuffer byteBuffer) {
        return ChildTransactionImpl.newTransactionBuilder(this.getId(), by, byArray, l, l2, s, list, byteBuffer);
    }

    @Override
    ChildTransactionImpl.BuilderImpl newTransactionBuilder(byte by, long l, long l2, short s, List<Appendix.AbstractAppendix> list, ResultSet resultSet) {
        return ChildTransactionImpl.newTransactionBuilder(this.getId(), by, l, l2, s, list, resultSet);
    }

    @Override
    UnconfirmedTransaction newUnconfirmedTransaction(ResultSet resultSet) throws SQLException, NxtException.NotValidException {
        return new UnconfirmedChildTransaction(resultSet);
    }
}

