/*
 * Decompiled with CFR 0.152.
 */
package nxt.blockchain;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import nxt.Constants;
import nxt.Nxt;
import nxt.NxtException;
import nxt.account.Account;
import nxt.account.AccountRestrictions;
import nxt.blockchain.Appendix;
import nxt.blockchain.Attachment;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildBlockFxtTransactionImpl;
import nxt.blockchain.ChildBlockFxtTransactionType;
import nxt.blockchain.ChildTransaction;
import nxt.blockchain.ChildTransactionImpl;
import nxt.blockchain.FxtChain;
import nxt.blockchain.FxtTransaction;
import nxt.blockchain.FxtTransactionType;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionImpl;
import nxt.blockchain.UnconfirmedFxtTransaction;
import nxt.crypto.Crypto;
import nxt.db.DbUtils;
import nxt.dbschema.Db;
import nxt.util.Convert;
import nxt.util.Logger;
import org.json.simple.JSONObject;

public class FxtTransactionImpl
extends TransactionImpl
implements FxtTransaction {
    private final long feeFQT;
    private final byte[] signature;

    FxtTransactionImpl(BuilderImpl builderImpl, String string, boolean bl) throws NxtException.NotValidException {
        super(builderImpl);
        if (builderImpl.fee <= 0L || Constants.correctInvalidFees && builderImpl.signature == null) {
            int n = this.getHeight() < Integer.MAX_VALUE ? this.getHeight() : Nxt.getBlockchain().getHeight();
            long l = this.getMinimumFeeFQT(n);
            this.feeFQT = Math.max(l, builderImpl.fee);
        } else {
            this.feeFQT = builderImpl.fee;
        }
        if (builderImpl.signature != null && string != null) {
            throw new NxtException.NotValidException("Transaction is already signed");
        }
        if (builderImpl.signature != null) {
            this.signature = builderImpl.signature;
        } else if (string != null) {
            byte[] byArray;
            byte[] byArray2 = byArray = builderImpl.senderPublicKey != null ? builderImpl.senderPublicKey : Account.getPublicKey(builderImpl.senderId);
            if (byArray != null && !Arrays.equals(byArray, Crypto.getPublicKey(string)) && !bl) {
                throw new NxtException.NotValidException("Secret phrase doesn't match transaction sender public key");
            }
            this.signature = Crypto.sign(this.bytes(), string);
            this.bytes = null;
        } else {
            this.signature = null;
        }
    }

    @Override
    public final Chain getChain() {
        return FxtChain.FXT;
    }

    @Override
    public long getFee() {
        return this.feeFQT;
    }

    @Override
    public byte[] getSignature() {
        return this.signature;
    }

    @Override
    public boolean isPhased() {
        return false;
    }

    @Override
    public boolean attachmentIsPhased() {
        return false;
    }

    @Override
    boolean hasAllReferencedTransactions(int n, int n2) {
        return true;
    }

    @Override
    public void validate() throws NxtException.ValidationException {
        try {
            super.validate();
            if (FxtTransactionType.findTransactionType(this.getType().getType(), this.getType().getSubtype()) == null) {
                throw new NxtException.NotValidException("Invalid transaction type " + this.getType().getName() + " for FxtTransaction");
            }
            int n = -1;
            for (Appendix.AbstractAppendix abstractAppendix : this.appendages()) {
                if (abstractAppendix.getAppendixType() <= n) {
                    throw new NxtException.NotValidException("Duplicate or not in order appendix " + abstractAppendix.getAppendixName());
                }
                n = abstractAppendix.getAppendixType();
                if (!abstractAppendix.isAllowed(FxtChain.FXT)) {
                    throw new NxtException.NotValidException("Appendix not allowed on Fxt chain " + abstractAppendix.getAppendixName());
                }
                abstractAppendix.loadPrunable(this);
                if (!abstractAppendix.verifyVersion()) {
                    throw new NxtException.NotValidException("Invalid attachment version " + abstractAppendix.getVersion());
                }
                abstractAppendix.validate(this);
            }
            if (this.getFullSize() > 131072) {
                throw new NxtException.NotValidException("Transaction size " + this.getFullSize() + " exceeds maximum payload size");
            }
            long l = this.getMinimumFeeFQT(Nxt.getBlockchain().getHeight());
            if (this.feeFQT < l) {
                throw new NxtException.NotCurrentlyValidException(String.format("Transaction fee %f %s less than minimum fee %f %s at height %d", (double)this.feeFQT / 1.0E8, "ARDR", (double)l / 1.0E8, "ARDR", Nxt.getBlockchain().getHeight()));
            }
            this.validateEcBlock();
            AccountRestrictions.checkTransaction(this);
        }
        catch (NxtException.NotValidException notValidException) {
            if (this.getSignature() != null) {
                Logger.logMessage("Invalid transaction " + this.getStringId());
            }
            throw notValidException;
        }
    }

    @Override
    protected void validateId() throws NxtException.ValidationException {
        super.validateId();
        for (Appendix.AbstractAppendix abstractAppendix : this.appendages()) {
            abstractAppendix.validateId(this);
        }
    }

    @Override
    void apply() {
        Account account = Account.getAccount(this.getSenderId());
        account.apply(this.getSenderPublicKey());
        Account account2 = null;
        if (this.getRecipientId() != 0L && (account2 = Account.getAccount(this.getRecipientId())) == null) {
            account2 = Account.addOrGetAccount(this.getRecipientId());
        }
        for (Appendix.AbstractAppendix abstractAppendix : this.appendages()) {
            abstractAppendix.loadPrunable(this);
            abstractAppendix.apply(this, account, account2);
        }
    }

    @Override
    void unsetBlock() {
        super.unsetBlock();
        this.setIndex(-1);
    }

    public Collection<ChildTransactionImpl> getChildTransactions() {
        return Collections.emptyList();
    }

    public List<ChildTransactionImpl> getSortedChildTransactions() {
        return Collections.emptyList();
    }

    @Override
    public void setChildTransactions(List<? extends ChildTransaction> list, byte[] byArray) throws NxtException.NotValidException {
        throw new UnsupportedOperationException("Only allowed for ChildBlockFxtTransactions");
    }

    public long[] getBackFees() {
        return Convert.EMPTY_LONG;
    }

    @Override
    final UnconfirmedFxtTransaction newUnconfirmedTransaction(long l, boolean bl) {
        return new UnconfirmedFxtTransaction(this, l);
    }

    public final boolean equals(Object object) {
        return object instanceof FxtTransactionImpl && this.getId() == ((Transaction)object).getId();
    }

    public final int hashCode() {
        return (int)(this.getId() ^ this.getId() >>> 32);
    }

    @Override
    void save(Connection connection, String string) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO " + string + " (id, deadline, recipient_id, amount, fee, height, block_id, signature, timestamp, type, subtype, sender_id, attachment_bytes, block_timestamp, full_hash, version, has_prunable_message, has_prunable_encrypted_message, has_prunable_attachment, ec_block_height, ec_block_id, transaction_index) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");){
            int n = 0;
            preparedStatement.setLong(++n, this.getId());
            preparedStatement.setShort(++n, this.getDeadline());
            DbUtils.setLongZeroToNull(preparedStatement, ++n, this.getRecipientId());
            preparedStatement.setLong(++n, this.getAmount());
            preparedStatement.setLong(++n, this.getFee());
            preparedStatement.setInt(++n, this.getHeight());
            preparedStatement.setLong(++n, this.getBlockId());
            preparedStatement.setBytes(++n, this.getSignature());
            preparedStatement.setInt(++n, this.getTimestamp());
            preparedStatement.setByte(++n, this.getType().getType());
            preparedStatement.setByte(++n, this.getType().getSubtype());
            preparedStatement.setLong(++n, this.getSenderId());
            int n2 = 0;
            for (Appendix appendix : this.getAppendages()) {
                n2 += appendix.getSize();
            }
            if (n2 == 0) {
                preparedStatement.setNull(++n, -3);
            } else {
                ByteBuffer byteBuffer = ByteBuffer.allocate(n2 + 4);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                this.putAppendages(byteBuffer, false);
                preparedStatement.setBytes(++n, byteBuffer.array());
            }
            preparedStatement.setInt(++n, this.getBlockTimestamp());
            preparedStatement.setBytes(++n, this.getFullHash());
            preparedStatement.setByte(++n, this.getVersion());
            preparedStatement.setBoolean(++n, this.hasPrunablePlainMessage());
            preparedStatement.setBoolean(++n, this.hasPrunableEncryptedMessage());
            preparedStatement.setBoolean(++n, this.getAttachment() instanceof Appendix.Prunable);
            preparedStatement.setInt(++n, this.getECBlockHeight());
            DbUtils.setLongZeroToNull(preparedStatement, ++n, this.getECBlockId());
            preparedStatement.setShort(++n, this.getIndex());
            preparedStatement.executeUpdate();
            if ((this.getIndex() + 1) % Constants.BATCH_COMMIT_SIZE == 0) {
                Db.db.commitTransaction();
            }
        }
    }

    static BuilderImpl newTransactionBuilder(byte by, long l, long l2, short s, List<Appendix.AbstractAppendix> list, ResultSet resultSet) {
        return new BuilderImpl(by, null, l, l2, s, list);
    }

    static BuilderImpl newTransactionBuilder(byte by, byte[] byArray, long l, long l2, short s, Attachment.AbstractAttachment abstractAttachment) {
        return new BuilderImpl(by, byArray, l, l2, s, abstractAttachment);
    }

    static BuilderImpl newTransactionBuilder(byte by, byte[] byArray, long l, long l2, short s, List<Appendix.AbstractAppendix> list, ByteBuffer byteBuffer) {
        return new BuilderImpl(by, byArray, l, l2, s, list);
    }

    static BuilderImpl newTransactionBuilder(byte by, byte[] byArray, long l, long l2, short s, List<Appendix.AbstractAppendix> list, JSONObject jSONObject) {
        return new BuilderImpl(by, byArray, l, l2, s, list);
    }

    public static final class BuilderImpl
    extends TransactionImpl.BuilderImpl
    implements FxtTransaction.Builder {
        private BuilderImpl(byte by, byte[] byArray, long l, long l2, short s, Attachment.AbstractAttachment abstractAttachment) {
            super(FxtChain.FXT.getId(), by, byArray, l, l2, s, abstractAttachment);
        }

        private BuilderImpl(byte by, byte[] byArray, long l, long l2, short s, List<Appendix.AbstractAppendix> list) {
            super(FxtChain.FXT.getId(), by, byArray, l, l2, s, list);
        }

        @Override
        public FxtTransactionImpl build(String string, boolean bl) throws NxtException.NotValidException {
            this.preBuild(string, bl);
            return this.getTransactionType() == ChildBlockFxtTransactionType.INSTANCE ? new ChildBlockFxtTransactionImpl(this, string, bl) : new FxtTransactionImpl(this, string, bl);
        }

        @Override
        public FxtTransactionImpl build(String string) throws NxtException.NotValidException {
            return this.build(string, false);
        }

        @Override
        public FxtTransactionImpl build() throws NxtException.NotValidException {
            return this.build(null);
        }
    }
}

