/*
 * Decompiled with CFR 0.152.
 */
package nxt.blockchain;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import nxt.Constants;
import nxt.account.Account;
import nxt.account.AccountRestrictions;
import nxt.ae.Asset;
import nxt.aliases.AliasHome;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildChain;
import nxt.blockchain.FxtChain;
import nxt.crypto.Crypto;
import nxt.dbschema.Db;
import nxt.ms.Currency;
import nxt.util.Convert;
import nxt.util.Logger;
import nxt.util.ResourceLookup;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;

public final class Genesis {
    static final byte[] generationSignature;

    static byte[] apply() {
        MessageDigest messageDigest = Crypto.sha256();
        Genesis.importPublicKeys(messageDigest);
        Genesis.importBalances(messageDigest);
        Genesis.importAliases(messageDigest);
        Genesis.importAssets(messageDigest);
        Genesis.importCurrencies(messageDigest);
        Genesis.importAccountInfo(messageDigest);
        Genesis.importAccountProperties(messageDigest);
        Genesis.importAccountControls(messageDigest);
        messageDigest.update(Convert.toBytes(Constants.EPOCH_BEGINNING));
        return messageDigest.digest();
    }

    private static void importPublicKeys(MessageDigest messageDigest) {
        try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new DigestInputStream(ResourceLookup.getSystemResourceAsStream("data/PUBLIC_KEY" + (Constants.isTestnet ? "-testnet.json" : ".json")), messageDigest), "UTF-8");){
            JSONArray jSONArray = (JSONArray)JSONValue.parseWithException((Reader)inputStreamReader);
            Logger.logDebugMessage("Loading public keys");
            int n = 0;
            for (Object e : jSONArray) {
                byte[] byArray = Convert.parseHexString((String)e);
                Account account = Account.addOrGetAccount(Account.getId(byArray));
                account.apply(byArray);
                if (n++ % Constants.BATCH_COMMIT_SIZE != 0) continue;
                Db.db.commitTransaction();
                Db.db.clearCache();
            }
            Logger.logDebugMessage("Loaded " + jSONArray.size() + " public keys");
        }
        catch (IOException | ParseException throwable) {
            throw new RuntimeException("Failed to process genesis recipients public keys", throwable);
        }
    }

    private static void importBalances(MessageDigest messageDigest) {
        ArrayList<Chain> arrayList = new ArrayList<Chain>();
        ChildChain.getAll().forEach(childChain -> {
            if (childChain.isEnabled()) {
                arrayList.add((Chain)childChain);
            }
        });
        arrayList.add(FxtChain.FXT);
        arrayList.sort(Comparator.comparingInt(Chain::getId));
        for (Chain chain : arrayList) {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new DigestInputStream(ResourceLookup.getSystemResourceAsStream("data/" + chain.getName() + (Constants.isTestnet ? "-testnet.json" : ".json")), messageDigest), "UTF-8");
                Throwable throwable = null;
                try {
                    JSONObject jSONObject = (JSONObject)JSONValue.parseWithException((Reader)inputStreamReader);
                    Genesis.loadBalances(chain, (Map<String, Long>)jSONObject);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStreamReader == null) continue;
                    if (throwable != null) {
                        try {
                            inputStreamReader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStreamReader.close();
                }
            }
            catch (IOException | ParseException throwable) {
                throw new RuntimeException("Failed to process genesis recipients accounts for " + chain.getName(), throwable);
            }
        }
    }

    public static void loadBalances(Chain chain, Map<String, Long> map) {
        Logger.logDebugMessage("Loading balances for chain %s", chain.getName());
        int n = 0;
        long l = 0L;
        for (Map.Entry<String, Long> entry : map.entrySet()) {
            Account account;
            long l2 = entry.getValue();
            String string = entry.getKey();
            if (string.length() == 64) {
                byte[] byArray = Convert.parseHexString(string);
                if (!Crypto.isCanonicalPublicKey(byArray)) {
                    Logger.logErrorMessage("Public key is not canonical: " + Convert.toHexString(byArray));
                    continue;
                }
                account = Account.addOrGetAccount(Account.getId(byArray));
                try {
                    account.apply(byArray);
                }
                catch (IllegalStateException illegalStateException) {
                    Logger.logErrorMessage(String.format("Public key mismatch for account %s", Long.toUnsignedString(account.getId())), illegalStateException);
                }
            } else {
                account = Account.addOrGetAccount(Long.parseUnsignedLong(string));
            }
            account.addToBalanceAndUnconfirmedBalance(chain, null, null, l2);
            l += l2;
            if (n++ % Constants.BATCH_COMMIT_SIZE != 0) continue;
            Db.db.commitTransaction();
            Db.db.clearCache();
        }
        Logger.logDebugMessage("Total balance %f %s", (double)l / (double)chain.ONE_COIN, chain.getName());
    }

    private static void importAliases(MessageDigest messageDigest) {
        try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new DigestInputStream(ResourceLookup.getSystemResourceAsStream("data/IGNIS_ALIASES" + (Constants.isTestnet ? "-testnet.json" : ".json")), messageDigest), "UTF-8");){
            JSONObject jSONObject = (JSONObject)JSONValue.parseWithException((Reader)inputStreamReader);
            Logger.logDebugMessage("Loading aliases");
            int n = 0;
            long l = 1L;
            AliasHome aliasHome = ChildChain.IGNIS.getAliasHome();
            for (Map.Entry entry : jSONObject.entrySet()) {
                String string = (String)entry.getKey();
                String string2 = (String)((Map)entry.getValue()).get("uri");
                long l2 = Long.parseUnsignedLong((String)((Map)entry.getValue()).get("account"));
                aliasHome.importAlias(l++, l2, string, string2);
                if (n++ % Constants.BATCH_COMMIT_SIZE != 0) continue;
                Db.db.commitTransaction();
                Db.db.clearCache();
            }
            Logger.logDebugMessage("Loaded " + n + " aliases");
        }
        catch (IOException | ParseException throwable) {
            throw new RuntimeException("Failed to process aliases", throwable);
        }
    }

    private static void importAssets(MessageDigest messageDigest) {
        try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new DigestInputStream(ResourceLookup.getSystemResourceAsStream("data/ASSETS" + (Constants.isTestnet ? "-testnet.json" : ".json")), messageDigest), "UTF-8");){
            JSONObject jSONObject = (JSONObject)JSONValue.parseWithException((Reader)inputStreamReader);
            Logger.logDebugMessage("Loading assets");
            int n = 0;
            for (Map.Entry entry : jSONObject.entrySet()) {
                long l = Long.parseUnsignedLong((String)entry.getKey());
                Map map = (Map)entry.getValue();
                String string = (String)map.get("name");
                String string2 = (String)map.get("description");
                byte by = ((Long)map.get("decimals")).byteValue();
                long l2 = Long.parseUnsignedLong((String)map.get("issuer"));
                Map map2 = (Map)map.get("balances");
                long l3 = 0L;
                for (Map.Entry entry2 : map2.entrySet()) {
                    Account account = Account.addOrGetAccount(Long.parseUnsignedLong((String)entry2.getKey()));
                    long l4 = (Long)entry2.getValue();
                    account.addToAssetAndUnconfirmedAssetBalanceQNT(null, null, l, l4);
                    l3 += l4;
                    if (n++ % Constants.BATCH_COMMIT_SIZE != 0) continue;
                    Db.db.commitTransaction();
                    Db.db.clearCache();
                }
                Asset.importAsset(l, l2, string, string2, by, l3);
            }
            Logger.logDebugMessage("Loaded " + n + " assets");
        }
        catch (IOException | ParseException throwable) {
            throw new RuntimeException("Failed to process assets", throwable);
        }
    }

    private static void importCurrencies(MessageDigest messageDigest) {
        try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new DigestInputStream(ResourceLookup.getSystemResourceAsStream("data/IGNIS_CURRENCIES" + (Constants.isTestnet ? "-testnet.json" : ".json")), messageDigest), "UTF-8");){
            JSONObject jSONObject = (JSONObject)JSONValue.parseWithException((Reader)inputStreamReader);
            Logger.logDebugMessage("Loading currencies");
            int n = 0;
            long l = 1L;
            for (Map.Entry entry : jSONObject.entrySet()) {
                String string = (String)entry.getKey();
                String string2 = (String)((Map)entry.getValue()).get("name");
                long l2 = Long.parseUnsignedLong((String)((Map)entry.getValue()).get("account"));
                Account account = Account.addOrGetAccount(l2);
                account.addToCurrencyAndUnconfirmedCurrencyUnits(null, null, l, 1L);
                Currency.importCurrency(l++, l2, string, string2);
                if (n++ % Constants.BATCH_COMMIT_SIZE != 0) continue;
                Db.db.commitTransaction();
                Db.db.clearCache();
            }
            Logger.logDebugMessage("Loaded " + n + " currencies");
        }
        catch (IOException | ParseException throwable) {
            throw new RuntimeException("Failed to process currencies", throwable);
        }
    }

    private static void importAccountInfo(MessageDigest messageDigest) {
        try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new DigestInputStream(ResourceLookup.getSystemResourceAsStream("data/ACCOUNT_INFO" + (Constants.isTestnet ? "-testnet.json" : ".json")), messageDigest), "UTF-8");){
            JSONObject jSONObject = (JSONObject)JSONValue.parseWithException((Reader)inputStreamReader);
            Logger.logDebugMessage("Loading account info");
            int n = 0;
            for (Map.Entry entry : jSONObject.entrySet()) {
                long l = Long.parseUnsignedLong((String)entry.getKey());
                String string = (String)((Map)entry.getValue()).get("name");
                String string2 = (String)((Map)entry.getValue()).get("description");
                Account.getAccount(l).setAccountInfo(string, string2);
                if (n++ % Constants.BATCH_COMMIT_SIZE != 0) continue;
                Db.db.commitTransaction();
                Db.db.clearCache();
            }
            Logger.logDebugMessage("Loaded " + n + " account infos");
        }
        catch (IOException | ParseException throwable) {
            throw new RuntimeException("Failed to process account infos", throwable);
        }
    }

    private static void importAccountProperties(MessageDigest messageDigest) {
        try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new DigestInputStream(ResourceLookup.getSystemResourceAsStream("data/ACCOUNT_PROPERTIES" + (Constants.isTestnet ? "-testnet.json" : ".json")), messageDigest), "UTF-8");){
            JSONObject jSONObject = (JSONObject)JSONValue.parseWithException((Reader)inputStreamReader);
            Logger.logDebugMessage("Loading account properties");
            int n = 0;
            long l = 1L;
            for (Map.Entry entry : jSONObject.entrySet()) {
                long l2 = Long.parseUnsignedLong((String)entry.getKey());
                Map map = (Map)entry.getValue();
                for (Map.Entry entry2 : map.entrySet()) {
                    long l3 = Long.parseUnsignedLong((String)entry2.getKey());
                    Map map2 = (Map)entry2.getValue();
                    for (Map.Entry entry3 : map2.entrySet()) {
                        String string = (String)entry3.getKey();
                        String string2 = (String)entry3.getValue();
                        Account.importProperty(l++, l2, l3, string, string2);
                    }
                }
                if (n++ % Constants.BATCH_COMMIT_SIZE != 0) continue;
                Db.db.commitTransaction();
                Db.db.clearCache();
            }
            Logger.logDebugMessage("Loaded " + n + " account properties");
        }
        catch (IOException | ParseException throwable) {
            throw new RuntimeException("Failed to process account properties", throwable);
        }
    }

    private static void importAccountControls(MessageDigest messageDigest) {
        try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new DigestInputStream(ResourceLookup.getSystemResourceAsStream("data/ACCOUNT_CONTROL" + (Constants.isTestnet ? "-testnet.json" : ".json")), messageDigest), "UTF-8");){
            JSONObject jSONObject = (JSONObject)JSONValue.parseWithException((Reader)inputStreamReader);
            Logger.logDebugMessage("Loading account controls");
            int n = 0;
            for (Map.Entry entry : jSONObject.entrySet()) {
                long l = Long.parseUnsignedLong((String)entry.getKey());
                int n2 = ((Long)((Map)entry.getValue()).get("quorum")).intValue();
                long l2 = (Long)((Map)entry.getValue()).get("maxFees");
                int n3 = ((Long)((Map)entry.getValue()).get("minDuration")).intValue();
                int n4 = ((Long)((Map)entry.getValue()).get("maxDuration")).intValue();
                JSONArray jSONArray = (JSONArray)((Map)entry.getValue()).get("whitelist");
                AccountRestrictions.PhasingOnly.importPhasingOnly(l, Convert.toArray((List<Long>)jSONArray), n2, l2, n3, n4);
                if (n++ % Constants.BATCH_COMMIT_SIZE != 0) continue;
                Db.db.commitTransaction();
                Db.db.clearCache();
            }
            Logger.logDebugMessage("Loaded " + n + " account controls");
        }
        catch (IOException | ParseException throwable) {
            throw new RuntimeException("Failed to process account controls", throwable);
        }
    }

    private Genesis() {
    }

    static {
        byte[] byArray;
        if (Constants.isTestnet) {
            byte[] byArray2 = new byte[32];
            byArray2[0] = 124;
            byArray2[1] = 1;
            byArray2[2] = -34;
            byArray2[3] = -36;
            byArray2[4] = -112;
            byArray2[5] = 63;
            byArray2[6] = -104;
            byArray2[7] = 10;
            byArray2[8] = 96;
            byArray2[9] = -94;
            byArray2[10] = -102;
            byArray2[11] = 23;
            byArray2[12] = -119;
            byArray2[13] = 14;
            byArray2[14] = 19;
            byArray2[15] = -78;
            byArray2[16] = -127;
            byArray2[17] = -25;
            byArray2[18] = -21;
            byArray2[19] = 90;
            byArray2[20] = 33;
            byArray2[21] = 68;
            byArray2[22] = 21;
            byArray2[23] = 76;
            byArray2[24] = -31;
            byArray2[25] = 76;
            byArray2[26] = 18;
            byArray2[27] = 126;
            byArray2[28] = -45;
            byArray2[29] = 79;
            byArray2[30] = -5;
            byArray = byArray2;
            byArray2[31] = 20;
        } else {
            byte[] byArray3 = new byte[32];
            byArray3[0] = -29;
            byArray3[1] = -14;
            byArray3[2] = 37;
            byArray3[3] = -125;
            byArray3[4] = -35;
            byArray3[5] = -72;
            byArray3[6] = 86;
            byArray3[7] = 6;
            byArray3[8] = 15;
            byArray3[9] = -116;
            byArray3[10] = 84;
            byArray3[11] = -120;
            byArray3[12] = 100;
            byArray3[13] = 32;
            byArray3[14] = -79;
            byArray3[15] = 121;
            byArray3[16] = 127;
            byArray3[17] = -107;
            byArray3[18] = 41;
            byArray3[19] = 117;
            byArray3[20] = -51;
            byArray3[21] = -91;
            byArray3[22] = 81;
            byArray3[23] = 86;
            byArray3[24] = -111;
            byArray3[25] = 19;
            byArray3[26] = 105;
            byArray3[27] = -73;
            byArray3[28] = -91;
            byArray3[29] = 87;
            byArray3[30] = -47;
            byArray = byArray3;
            byArray3[31] = -49;
        }
        generationSignature = byArray;
    }
}

