/*
 * Decompiled with CFR 0.152.
 */
package nxt.blockchain;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import nxt.Constants;
import nxt.NxtException;
import nxt.blockchain.BlockchainImpl;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildChain;
import nxt.blockchain.ChildTransactionImpl;
import nxt.blockchain.FxtChain;
import nxt.blockchain.FxtTransactionImpl;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionImpl;
import nxt.blockchain.TransactionType;
import nxt.db.Table;
import nxt.dbschema.Db;
import nxt.util.Convert;

public final class TransactionHome {
    private final Chain chain;
    private final Table transactionTable;

    public static TransactionHome forChain(Chain chain) {
        if (chain.getTransactionHome() != null) {
            throw new IllegalStateException("already set");
        }
        return new TransactionHome(chain);
    }

    private TransactionHome(Chain chain) {
        this.chain = chain;
        this.transactionTable = new Table(chain.getSchemaTable(chain instanceof FxtChain ? "transaction_fxt" : "transaction"));
    }

    /*
     * Exception decompiling
     */
    static FxtTransactionImpl findFxtTransaction(long var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public TransactionImpl findTransaction(byte[] byArray) {
        return this.findTransaction(byArray, Integer.MAX_VALUE);
    }

    /*
     * Exception decompiling
     */
    public TransactionImpl findTransaction(byte[] var1_1, int var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 43[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static boolean hasFxtTransaction(long l) {
        return TransactionHome.hasFxtTransaction(l, Integer.MAX_VALUE);
    }

    /*
     * Exception decompiling
     */
    static boolean hasFxtTransaction(long var0, int var2_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 42[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    boolean hasTransaction(Transaction transaction) {
        return this.hasTransaction(transaction.getFullHash(), transaction.getId(), Integer.MAX_VALUE);
    }

    boolean hasTransaction(Transaction transaction, int n) {
        return this.hasTransaction(transaction.getFullHash(), transaction.getId(), n);
    }

    boolean hasTransaction(byte[] byArray) {
        return this.hasTransaction(byArray, Convert.fullHashToId(byArray), Integer.MAX_VALUE);
    }

    public boolean hasTransaction(byte[] byArray, int n) {
        return this.hasTransaction(byArray, Convert.fullHashToId(byArray), n);
    }

    /*
     * Exception decompiling
     */
    public boolean hasTransaction(byte[] var1_1, long var2_2, int var4_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 42[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    List<byte[]> findChildTransactionFullHashes(long l) {
        if (this.chain == FxtChain.FXT) {
            throw new RuntimeException("Invalid chain");
        }
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        BlockchainImpl.getInstance().readLock();
        try (Connection connection = this.transactionTable.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("SELECT full_hash FROM " + this.transactionTable.getSchemaTable() + " WHERE fxt_transaction_id = ? ORDER BY fxt_transaction_id, transaction_index");){
            preparedStatement.setLong(1, l);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    arrayList.add(resultSet.getBytes("full_hash"));
                }
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
        finally {
            BlockchainImpl.getInstance().readUnlock();
        }
        return arrayList;
    }

    List<ChildTransactionImpl> findChildTransactions(long l) {
        if (this.chain == FxtChain.FXT) {
            throw new RuntimeException("Invalid chain");
        }
        ArrayList<ChildTransactionImpl> arrayList = new ArrayList<ChildTransactionImpl>();
        BlockchainImpl.getInstance().readLock();
        try (Connection connection = this.transactionTable.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM " + this.transactionTable.getSchemaTable() + " WHERE fxt_transaction_id = ? ORDER BY fxt_transaction_id, transaction_index");){
            preparedStatement.setLong(1, l);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    arrayList.add((ChildTransactionImpl)TransactionImpl.loadTransaction(this.chain, resultSet));
                }
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
        catch (NxtException.ValidationException validationException) {
            throw new RuntimeException("Transaction already in database for fxtTransactionId = " + Long.toUnsignedString(l) + " does not pass validation!", validationException);
        }
        finally {
            BlockchainImpl.getInstance().readUnlock();
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static List<FxtTransactionImpl> findBlockTransactions(long l) {
        try (Connection connection = Db.getConnection();){
            List<FxtTransactionImpl> list = TransactionHome.findBlockTransactions(connection, l);
            return list;
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    static List<FxtTransactionImpl> findBlockTransactions(Connection connection, long l) {
        ArrayList<FxtTransactionImpl> arrayList = new ArrayList<FxtTransactionImpl>();
        BlockchainImpl.getInstance().readLock();
        try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM transaction_fxt WHERE block_id = ? ORDER BY transaction_index");){
            preparedStatement.setLong(1, l);
            preparedStatement.setFetchSize(50);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    arrayList.add((FxtTransactionImpl)TransactionImpl.loadTransaction(FxtChain.FXT, resultSet));
                }
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
        catch (NxtException.ValidationException validationException) {
            throw new RuntimeException("Transaction already in database for block_id = " + Long.toUnsignedString(l) + " does not pass validation!", validationException);
        }
        finally {
            BlockchainImpl.getInstance().readUnlock();
        }
        return arrayList;
    }

    static void deleteBlockTransactions(long l) {
        FxtChain.FXT.getTransactionHome().deleteTransactions(l);
        ChildChain.getAll().forEach(childChain -> childChain.getTransactionHome().deleteTransactions(l));
    }

    private void deleteTransactions(long l) {
        try (Connection connection = this.transactionTable.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM " + this.transactionTable.getSchemaTable() + " WHERE block_id = ? LIMIT " + Constants.BATCH_COMMIT_SIZE);){
            int n;
            preparedStatement.setLong(1, l);
            do {
                n = preparedStatement.executeUpdate();
                Db.db.commitTransaction();
            } while (n >= Constants.BATCH_COMMIT_SIZE);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    List<PrunableTransaction> findPrunableTransactions(Connection connection, int n, int n2) {
        ArrayList<PrunableTransaction> arrayList = new ArrayList<PrunableTransaction>();
        try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT full_hash, type, subtype, has_prunable_attachment AS prunable_attachment, has_prunable_message AS prunable_plain_message, has_prunable_encrypted_message AS prunable_encrypted_message FROM " + this.transactionTable.getSchemaTable() + " WHERE (timestamp BETWEEN ? AND ?) AND (has_prunable_attachment = TRUE OR has_prunable_message = TRUE OR has_prunable_encrypted_message = TRUE)");){
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(2, n2);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    byte[] byArray = resultSet.getBytes("full_hash");
                    byte by = resultSet.getByte("type");
                    byte by2 = resultSet.getByte("subtype");
                    TransactionType transactionType = TransactionType.findTransactionType(by, by2);
                    arrayList.add(new PrunableTransaction(byArray, transactionType, resultSet.getBoolean("prunable_attachment"), resultSet.getBoolean("prunable_plain_message"), resultSet.getBoolean("prunable_encrypted_message")));
                }
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
        return arrayList;
    }

    static void saveTransactions(Connection connection, List<FxtTransactionImpl> list) {
        try {
            for (FxtTransactionImpl fxtTransactionImpl : list) {
                fxtTransactionImpl.save(connection, "transaction_fxt");
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    int getTransactionCount() {
        return this.transactionTable.getCount();
    }

    static class PrunableTransaction {
        private final byte[] fullHash;
        private final TransactionType transactionType;
        private final boolean prunableAttachment;
        private final boolean prunablePlainMessage;
        private final boolean prunableEncryptedMessage;

        private PrunableTransaction(byte[] byArray, TransactionType transactionType, boolean bl, boolean bl2, boolean bl3) {
            this.fullHash = byArray;
            this.transactionType = transactionType;
            this.prunableAttachment = bl;
            this.prunablePlainMessage = bl2;
            this.prunableEncryptedMessage = bl3;
        }

        public byte[] getFullHash() {
            return this.fullHash;
        }

        public TransactionType getTransactionType() {
            return this.transactionType;
        }

        public boolean hasPrunableAttachment() {
            return this.prunableAttachment;
        }

        public boolean hasPrunablePlainMessage() {
            return this.prunablePlainMessage;
        }

        public boolean hasPrunableEncryptedMessage() {
            return this.prunableEncryptedMessage;
        }
    }
}

