/*
 * Decompiled with CFR 0.152.
 */
package nxt.ce;

import java.nio.ByteBuffer;
import nxt.blockchain.Attachment;
import nxt.blockchain.TransactionType;
import nxt.ce.CoinExchangeTransactionType;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public class OrderCancelAttachment
extends Attachment.AbstractAttachment {
    private final byte[] orderHash;
    private final long orderId;

    public OrderCancelAttachment(byte[] byArray) {
        this.orderHash = byArray;
        this.orderId = Convert.fullHashToId(this.orderHash);
    }

    OrderCancelAttachment(ByteBuffer byteBuffer) {
        super(byteBuffer);
        this.orderHash = new byte[32];
        byteBuffer.get(this.orderHash);
        this.orderId = Convert.fullHashToId(this.orderHash);
    }

    OrderCancelAttachment(JSONObject jSONObject) {
        super(jSONObject);
        this.orderHash = Convert.parseHexString((String)jSONObject.get((Object)"orderHash"));
        this.orderId = Convert.fullHashToId(this.orderHash);
    }

    @Override
    protected int getMySize() {
        return 32;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byteBuffer.put(this.orderHash);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"orderHash", (Object)Convert.toHexString(this.orderHash));
    }

    public byte[] getOrderHash() {
        return this.orderHash;
    }

    public long getOrderId() {
        return this.orderId;
    }

    @Override
    public TransactionType getTransactionType() {
        return CoinExchangeTransactionType.ORDER_CANCEL;
    }
}

