/*
 * Decompiled with CFR 0.152.
 */
package nxt.configuration;

import nxt.Constants;
import nxt.Nxt;
import nxt.account.Account;
import nxt.account.AccountLedger;
import nxt.account.AccountRestrictions;
import nxt.account.FundingMonitor;
import nxt.addons.AddOns;
import nxt.addons.DebugTrace;
import nxt.ae.Asset;
import nxt.ae.AssetControl;
import nxt.ae.AssetHistory;
import nxt.ae.AssetTransfer;
import nxt.blockchain.BlockchainProcessorImpl;
import nxt.blockchain.Bundler;
import nxt.blockchain.ChildChain;
import nxt.blockchain.FxtChain;
import nxt.blockchain.Generator;
import nxt.blockchain.TransactionProcessorImpl;
import nxt.ce.CoinExchange;
import nxt.crypto.Crypto;
import nxt.dbschema.Db;
import nxt.env.RuntimeEnvironment;
import nxt.env.ServerStatus;
import nxt.http.API;
import nxt.http.APIProxy;
import nxt.lightcontracts.ContractReference;
import nxt.ms.Currency;
import nxt.ms.CurrencyMint;
import nxt.ms.CurrencyTransfer;
import nxt.peer.NetworkHandler;
import nxt.peer.Peers;
import nxt.util.Logger;
import nxt.util.ThreadPool;
import nxt.util.Time;

public interface SubSystem {
    public static final SubSystem LOGGER = new SubSystem(){

        @Override
        public void init() {
            Logger.init();
            this.logSystemProperties();
        }

        @Override
        public void shutdown() {
            Logger.logShutdownMessage("Ardor server 2.2.6 stopped.");
            Logger.shutdown();
        }

        public void logSystemProperties() {
            String[] stringArray;
            for (String string : stringArray = new String[]{"java.version", "java.vm.version", "java.vm.name", "java.vendor", "java.vm.vendor", "java.home", "java.library.path", "java.class.path", "os.arch", "sun.arch.data.model", "os.name", "file.encoding", "java.security.policy", "java.security.manager", "java.specification.vendor", "nxt.runtime.mode", "nxt.runtime.dirProvider"}) {
                Logger.logDebugMessage(String.format("%s = %s", string, System.getProperty(string)));
            }
            Logger.logDebugMessage(String.format("availableProcessors = %s", Runtime.getRuntime().availableProcessors()));
            Logger.logDebugMessage(String.format("maxMemory = %s", Runtime.getRuntime().maxMemory()));
            Logger.logDebugMessage(String.format("processId = %s", Nxt.getProcessId()));
        }
    };
    public static final SubSystem SYSTEM_TRAY = new SubSystem(){

        @Override
        public void init() {
            Nxt.getRuntimeMode().init();
        }

        @Override
        public void shutdown() {
            Nxt.getRuntimeMode().shutdown();
        }
    };
    public static final SubSystem DB = new SubSystem(){

        @Override
        public void init() {
            Nxt.setServerStatus(ServerStatus.BEFORE_DATABASE, null);
            Db.init();
            Nxt.setServerStatus(ServerStatus.AFTER_DATABASE, null);
        }

        @Override
        public void shutdown() {
            Db.shutdown();
        }
    };
    public static final SubSystem BLOCKCHAIN = new SubSystem(){

        @Override
        public void init() {
            TransactionProcessorImpl.init();
            BlockchainProcessorImpl.init();
            ChildChain.init();
            FxtChain.init();
            Account.init();
            AccountRestrictions.init();
            AccountLedger.init();
            Asset.init();
            AssetTransfer.init();
            AssetControl.init();
            AssetHistory.init();
            Currency.init();
            CurrencyMint.init();
            CurrencyTransfer.init();
            CoinExchange.init();
            ContractReference.init();
            Generator.init();
            Bundler.init();
        }

        @Override
        public void shutdown() {
            FundingMonitor.shutdown();
            BlockchainProcessorImpl.getInstance().shutdown();
        }
    };
    public static final SubSystem PEER_NETWORKING = new SubSystem(){

        @Override
        public void init() {
            NetworkHandler.init();
            Peers.init();
            APIProxy.init();
        }

        @Override
        public void shutdown() {
            Peers.shutdown();
            NetworkHandler.shutdown();
        }
    };
    public static final SubSystem ADDONS = new SubSystem(){

        @Override
        public void init() {
            AddOns.init();
            DebugTrace.init();
        }

        @Override
        public void shutdown() {
            AddOns.shutdown();
        }
    };
    public static final SubSystem API_SERVER = new SubSystem(){

        @Override
        public void init() {
            API.init();
        }

        @Override
        public void shutdown() {
            API.shutdown();
        }
    };
    public static final SubSystem THREAD_POOL = new SubSystem(){

        @Override
        public void init() {
            int n = Constants.isTestnet && Constants.isOffline ? Math.max(Nxt.getIntProperty("nxt.timeMultiplier"), 1) : 1;
            ThreadPool.start(n);
            if (n > 1) {
                Nxt.setTime(new Time.FasterTime(Math.max(Nxt.getEpochTime(), Nxt.getBlockchain().getLastBlock().getTimestamp()), n));
                Logger.logMessage("TIME WILL FLOW " + n + " TIMES FASTER!");
            }
        }

        @Override
        public void shutdown() {
            ThreadPool.shutdown();
        }
    };
    public static final SubSystem RANDOMIZATION = new SubSystem(){

        @Override
        public void init() {
            Thread thread = this.initSecureRandom();
            try {
                thread.join(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.testSecureRandom();
        }

        @Override
        public void shutdown() {
        }

        private Thread initSecureRandom() {
            Thread thread = new Thread(() -> Crypto.getSecureRandom().nextBytes(new byte[1024]));
            thread.setDaemon(true);
            thread.start();
            return thread;
        }

        private void testSecureRandom() {
            Thread thread = new Thread(() -> Crypto.getSecureRandom().nextBytes(new byte[1024]));
            thread.setDaemon(true);
            thread.start();
            try {
                thread.join(2000L);
                if (thread.isAlive()) {
                    throw new RuntimeException("SecureRandom implementation too slow!!! Install haveged if on linux, or set nxt.useStrongSecureRandom=false.");
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    };
    public static final SubSystem DESKTOP_WALLET = new SubSystem(){

        @Override
        public void init() {
            if (RuntimeEnvironment.isDesktopApplicationEnabled()) {
                this.launchDesktopApplication();
            } else {
                Logger.logInfoMessage("Desktop application is disabled");
            }
        }

        @Override
        public void shutdown() {
        }

        private void launchDesktopApplication() {
            Nxt.getRuntimeMode().launchDesktopApplication();
        }
    };

    public void init();

    public void shutdown();
}

