/*
 * Decompiled with CFR 0.152.
 */
package nxt.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import nxt.Nxt;
import nxt.db.DbVersion;
import nxt.db.FullTextTrigger;
import nxt.db.pool.ConnectionPool;
import nxt.db.pool.H2ConnectionPool;
import nxt.util.Logger;
import nxt.util.security.BlockchainPermission;

public class BasicDb {
    private ConnectionPool cp;
    private final String dbUrl;
    private final String dbUsername;
    private final String dbPassword;
    private final int maxConnections;
    private final int loginTimeout;
    private final int defaultLockTimeout;
    private final int maxMemoryRows;
    private volatile boolean initialized = false;

    public BasicDb(DbProperties dbProperties) {
        String string;
        long l;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("db"));
        }
        if ((l = dbProperties.maxCacheSize) == 0L) {
            l = Math.min(256L, Math.max(16L, (Runtime.getRuntime().maxMemory() / 0x100000L - 128L) / 2L)) * 1024L;
        }
        if ((string = dbProperties.dbUrl) == null) {
            String string2 = Nxt.getDbDir(dbProperties.dbDir);
            string = String.format("jdbc:%s:%s;%s", dbProperties.dbType, string2, dbProperties.dbParams);
        }
        if (!string.contains("CACHE_SIZE=")) {
            string = string + ";CACHE_SIZE=" + l;
        }
        this.dbUrl = string;
        this.dbUsername = dbProperties.dbUsername;
        this.dbPassword = dbProperties.dbPassword;
        this.maxConnections = dbProperties.maxConnections;
        this.loginTimeout = dbProperties.loginTimeout;
        this.defaultLockTimeout = dbProperties.defaultLockTimeout;
        this.maxMemoryRows = dbProperties.maxMemoryRows;
    }

    public final void init(List<DbVersion> list) {
        Object object;
        Logger.logDebugMessage("Database jdbc url set to %s username %s", this.dbUrl, this.dbUsername);
        String string = Nxt.getStringProperty("nxt.connectionPoolImpl");
        try {
            object = Class.forName(string);
            this.cp = (ConnectionPool)((Class)object).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
            Logger.logErrorMessage("Failed to create connection pool instance", reflectiveOperationException);
            this.cp = new H2ConnectionPool();
        }
        this.cp.initialize(this.dbUrl, this.dbUsername, this.dbPassword, this.maxConnections, this.loginTimeout);
        FullTextTrigger.setActive(true);
        try {
            object = this.getPooledConnection();
            Throwable throwable = null;
            try (Statement statement = object.createStatement();){
                statement.executeUpdate("SET DEFAULT_LOCK_TIMEOUT " + this.defaultLockTimeout);
                statement.executeUpdate("SET MAX_MEMORY_ROWS " + this.maxMemoryRows);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            object.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        object.close();
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
        list.forEach(DbVersion::createSchema);
        list.forEach(DbVersion::init);
        this.initialized = true;
    }

    public final void shutdown() {
        if (!this.initialized) {
            return;
        }
        try {
            boolean bl;
            FullTextTrigger.setActive(false);
            Connection connection = this.getPooledConnection();
            Statement statement = connection.createStatement();
            boolean bl2 = bl = !Nxt.getBooleanProperty("nxt.disableCompactOnShutdown");
            if (bl) {
                statement.execute("SHUTDOWN COMPACT");
                Logger.logShutdownMessage("Database shutdown completed");
            } else {
                statement.execute("SHUTDOWN");
                Logger.logShutdownMessage("Database shutdown without compact completed");
            }
        }
        catch (SQLException sQLException) {
            Logger.logShutdownMessage(sQLException.toString(), sQLException);
        }
    }

    public final void analyzeTables() {
        try (Connection connection = this.getPooledConnection();
             Statement statement = connection.createStatement();){
            statement.execute("ANALYZE");
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public Connection getConnection(String string) throws SQLException {
        Connection connection = this.getPooledConnection();
        connection.setAutoCommit(true);
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate("SET SCHEMA " + string);
            statement.executeUpdate("SET SCHEMA_SEARCH_PATH " + string + ", PUBLIC");
        }
        return connection;
    }

    protected Connection getPooledConnection() throws SQLException {
        return this.cp.getConnection();
    }

    public final String getUrl() {
        return this.dbUrl;
    }

    public static final class DbProperties {
        private long maxCacheSize;
        private String dbUrl;
        private String dbType;
        private String dbDir;
        private String dbParams;
        private String dbUsername;
        private String dbPassword;
        private int maxConnections;
        private int loginTimeout;
        private int defaultLockTimeout;
        private int maxMemoryRows;

        public DbProperties maxCacheSize(int n) {
            this.maxCacheSize = n;
            return this;
        }

        public DbProperties dbUrl(String string) {
            this.dbUrl = string;
            return this;
        }

        public DbProperties dbType(String string) {
            this.dbType = string;
            return this;
        }

        public DbProperties dbDir(String string) {
            this.dbDir = string;
            return this;
        }

        public DbProperties dbParams(String string) {
            this.dbParams = string;
            return this;
        }

        public DbProperties dbUsername(String string) {
            this.dbUsername = string;
            return this;
        }

        public DbProperties dbPassword(String string) {
            this.dbPassword = string;
            return this;
        }

        public DbProperties maxConnections(int n) {
            this.maxConnections = n;
            return this;
        }

        public DbProperties loginTimeout(int n) {
            this.loginTimeout = n;
            return this;
        }

        public DbProperties defaultLockTimeout(int n) {
            this.defaultLockTimeout = n;
            return this;
        }

        public DbProperties maxMemoryRows(int n) {
            this.maxMemoryRows = n;
            return this;
        }
    }
}

