/*
 * Decompiled with CFR 0.152.
 */
package nxt.dgs;

import java.nio.ByteBuffer;
import nxt.blockchain.Attachment;
import nxt.blockchain.TransactionType;
import nxt.dgs.DigitalGoodsTransactionType;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public final class FeedbackAttachment
extends Attachment.AbstractAttachment {
    private final long purchaseId;

    FeedbackAttachment(ByteBuffer byteBuffer) {
        super(byteBuffer);
        this.purchaseId = byteBuffer.getLong();
    }

    FeedbackAttachment(JSONObject jSONObject) {
        super(jSONObject);
        this.purchaseId = Convert.parseUnsignedLong((String)jSONObject.get((Object)"purchase"));
    }

    public FeedbackAttachment(long l) {
        this.purchaseId = l;
    }

    @Override
    protected int getMySize() {
        return 8;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byteBuffer.putLong(this.purchaseId);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"purchase", (Object)Long.toUnsignedString(this.purchaseId));
    }

    @Override
    public TransactionType getTransactionType() {
        return DigitalGoodsTransactionType.FEEDBACK;
    }

    public long getPurchaseId() {
        return this.purchaseId;
    }
}

