/*
 * Decompiled with CFR 0.152.
 */
package nxt.dgs;

import java.nio.ByteBuffer;
import nxt.blockchain.Attachment;
import nxt.blockchain.TransactionType;
import nxt.dgs.DigitalGoodsTransactionType;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public final class QuantityChangeAttachment
extends Attachment.AbstractAttachment {
    private final long goodsId;
    private final int deltaQuantity;

    QuantityChangeAttachment(ByteBuffer byteBuffer) {
        super(byteBuffer);
        this.goodsId = byteBuffer.getLong();
        this.deltaQuantity = byteBuffer.getInt();
    }

    QuantityChangeAttachment(JSONObject jSONObject) {
        super(jSONObject);
        this.goodsId = Convert.parseUnsignedLong((String)jSONObject.get((Object)"goods"));
        this.deltaQuantity = ((Long)jSONObject.get((Object)"deltaQuantity")).intValue();
    }

    public QuantityChangeAttachment(long l, int n) {
        this.goodsId = l;
        this.deltaQuantity = n;
    }

    @Override
    protected int getMySize() {
        return 12;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byteBuffer.putLong(this.goodsId);
        byteBuffer.putInt(this.deltaQuantity);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"goods", (Object)Long.toUnsignedString(this.goodsId));
        jSONObject.put((Object)"deltaQuantity", (Object)this.deltaQuantity);
    }

    @Override
    public TransactionType getTransactionType() {
        return DigitalGoodsTransactionType.QUANTITY_CHANGE;
    }

    public long getGoodsId() {
        return this.goodsId;
    }

    public int getDeltaQuantity() {
        return this.deltaQuantity;
    }
}

