/*
 * Decompiled with CFR 0.152.
 */
package nxt.freeze;

import java.util.ArrayList;
import java.util.List;
import nxt.Constants;
import nxt.Nxt;
import nxt.account.HoldingType;
import nxt.db.DbIterator;
import nxt.env.ServerStatus;
import nxt.freeze.HoldingFreeze;
import nxt.util.Logger;

public class FreezeMonitor {
    private final HoldingType holdingType;

    public FreezeMonitor(HoldingType holdingType) {
        this.holdingType = holdingType;
    }

    public boolean isFrozen(long l) {
        return FreezeMonitor.isFrozen(this.holdingType, l);
    }

    public static boolean isFrozen(HoldingType holdingType, long l) {
        HoldingFreeze holdingFreeze = HoldingFreeze.getById(l, holdingType);
        return holdingFreeze != null && holdingFreeze.isFrozen(Nxt.getBlockchain().getHeight());
    }

    public void scheduleFreeze(long l, int n) {
        if (this.tryScheduleFreeze(l, n)) {
            Logger.logDebugMessage(String.format("Scheduled freezing of %s at height %d", Long.toUnsignedString(l), n));
        } else {
            Logger.logDebugMessage(String.format("Failed to schedule freezing of %s at height %d, current height %d", Long.toUnsignedString(l), n, Nxt.getBlockchain().getHeight()));
        }
    }

    private boolean tryScheduleFreeze(long l, int n) {
        int n2 = Nxt.getBlockchain().getHeight();
        if (n <= n2) {
            return false;
        }
        HoldingFreeze holdingFreeze = HoldingFreeze.getById(l, this.holdingType);
        if (holdingFreeze == null) {
            return false;
        }
        if (holdingFreeze.isFrozen(n2)) {
            return false;
        }
        if (n < holdingFreeze.getMinHeight()) {
            return false;
        }
        holdingFreeze.setActualHeight(n);
        HoldingFreeze.insert(holdingFreeze);
        return true;
    }

    public void enableFreeze(long l, int n, int n2) {
        if (!Constants.isAutomatedTest && Nxt.getServerStatus() != ServerStatus.BEFORE_DATABASE) {
            throw new IllegalStateException("Setting freeze only allowed during tests or in DbVersion");
        }
        HoldingFreeze holdingFreeze = HoldingFreeze.getById(l, this.holdingType);
        if (holdingFreeze != null) {
            throw new IllegalStateException("Holding freeze already set: " + holdingFreeze.toString());
        }
        if (n <= 0 || n2 < 0 || n2 > 0 && n2 < n) {
            throw new IllegalArgumentException(String.format("Invalid minHeight %d or actualHeight %d", n, n2));
        }
        HoldingFreeze.insert(new HoldingFreeze(l, this.holdingType, n, n2));
    }

    public static boolean hasFreezesAt(int n) {
        try (DbIterator<HoldingFreeze> dbIterator = HoldingFreeze.getFreezes(n);){
            boolean bl = dbIterator.hasNext();
            return bl;
        }
    }

    public static List<Long> getFreezeIdsAt(HoldingType holdingType, int n) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        try (DbIterator<HoldingFreeze> dbIterator = HoldingFreeze.getFreezes(holdingType, n);){
            while (dbIterator.hasNext()) {
                arrayList.add(dbIterator.next().getHoldingId());
            }
        }
        return arrayList;
    }

    public static int getMinFreezeHeight(long l, HoldingType holdingType) {
        HoldingFreeze holdingFreeze = HoldingFreeze.getById(l, holdingType);
        if (holdingFreeze == null) {
            return 0;
        }
        return holdingFreeze.getMinHeight();
    }

    static {
        HoldingFreeze.init();
    }
}

