/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nxt.http.API;
import nxt.http.APIProxy;
import nxt.http.APIServlet;
import nxt.http.HttpClientFactory;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.peer.Peer;
import nxt.peer.Peers;
import nxt.util.Convert;
import nxt.util.JSON;
import nxt.util.Logger;
import nxt.util.security.BlockchainPermission;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.proxy.AsyncMiddleManServlet;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.UrlEncoded;
import org.json.simple.JSONStreamAware;

public final class APIProxyServlet
extends AsyncMiddleManServlet {
    private static final String REMOTE_URL = APIProxyServlet.class.getName() + ".remoteUrl";
    private static final String REMOTE_SERVER_IDLE_TIMEOUT = APIProxyServlet.class.getName() + ".remoteServerIdleTimeout";
    static final int PROXY_IDLE_TIMEOUT_DELTA = 5000;

    static void initClass() {
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("api"));
        }
        super.init(servletConfig);
        servletConfig.getServletContext().setAttribute("apiServlet", (Object)new APIServlet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        Object object2;
        JSONStreamAware jSONStreamAware = null;
        try {
            if (API.isForbiddenHost(httpServletRequest.getRemoteHost())) {
                jSONStreamAware = JSONResponses.ERROR_NOT_ALLOWED;
                return;
            }
            object2 = this.getRequestParameters(httpServletRequest);
            object = this.getRequestType((MultiMap<String>)object2);
            if (APIProxy.isActivated() && this.isForwardable((String)object)) {
                for (String string : API.SENSITIVE_PARAMS) {
                    if (!object2.containsKey((Object)string)) continue;
                    throw new ParameterException(JSONResponses.PROXY_SECRET_DATA_DETECTED);
                }
                if (!this.initRemoteRequest(httpServletRequest, (String)object)) {
                    jSONStreamAware = Peers.getPeers(peer -> peer.getState() == Peer.State.CONNECTED, 1).size() >= 1 ? JSONResponses.API_PROXY_NO_OPEN_API_PEERS : JSONResponses.API_PROXY_NO_PUBLIC_PEERS;
                } else {
                    super.service(httpServletRequest, httpServletResponse);
                }
            } else {
                APIServlet aPIServlet = (APIServlet)((Object)httpServletRequest.getServletContext().getAttribute("apiServlet"));
                aPIServlet.service((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
            if (jSONStreamAware == null) return;
        }
        catch (ParameterException parameterException) {
            jSONStreamAware = parameterException.getErrorResponse();
            return;
        }
        try {
            object2 = httpServletResponse.getWriter();
            object = null;
            try {
                JSON.writeJSONString(jSONStreamAware, object2);
                return;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object != null) {
                        try {
                            ((Writer)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((Writer)object2).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            Logger.logInfoMessage("Failed to write response to client", iOException);
            return;
        }
        finally {
            if (jSONStreamAware != null) {
                try (PrintWriter printWriter = httpServletResponse.getWriter();){
                    JSON.writeJSONString(jSONStreamAware, printWriter);
                }
                catch (IOException iOException) {
                    Logger.logInfoMessage("Failed to write response to client", iOException);
                }
            }
        }
    }

    private MultiMap<String> getRequestParameters(HttpServletRequest httpServletRequest) {
        MultiMap multiMap = new MultiMap();
        String string = httpServletRequest.getQueryString();
        if (string != null) {
            UrlEncoded.decodeUtf8To((String)string, (MultiMap)multiMap);
        }
        return multiMap;
    }

    protected void addProxyHeaders(HttpServletRequest httpServletRequest, Request request) {
    }

    protected HttpClient newHttpClient() {
        return HttpClientFactory.newHttpClient();
    }

    protected String rewriteTarget(HttpServletRequest httpServletRequest) {
        Integer n = (Integer)httpServletRequest.getAttribute(REMOTE_SERVER_IDLE_TIMEOUT);
        HttpClient httpClient = this.getHttpClient();
        if (n != null && httpClient != null) {
            httpClient.setIdleTimeout((long)Math.max(n - 5000, 0));
        }
        String string = (String)httpServletRequest.getAttribute(REMOTE_URL);
        URI uRI = URI.create(string).normalize();
        return uRI.toString();
    }

    protected void onClientRequestFailure(HttpServletRequest httpServletRequest, Request request, HttpServletResponse httpServletResponse, Throwable throwable) {
        if (throwable instanceof PasswordDetectedException) {
            PasswordDetectedException passwordDetectedException = (PasswordDetectedException)throwable;
            try (PrintWriter printWriter = httpServletResponse.getWriter();){
                JSON.writeJSONString(passwordDetectedException.errorResponse, printWriter);
                this.sendProxyResponseError(httpServletRequest, httpServletResponse, 200);
            }
            catch (IOException iOException) {
                iOException.addSuppressed(throwable);
                super.onClientRequestFailure(httpServletRequest, request, httpServletResponse, (Throwable)iOException);
            }
        } else {
            super.onClientRequestFailure(httpServletRequest, request, httpServletResponse, throwable);
        }
    }

    private String getRequestType(MultiMap<String> multiMap) throws ParameterException {
        String string = multiMap.getString("requestType");
        if (Convert.emptyToNull(string) == null) {
            throw new ParameterException(JSONResponses.PROXY_MISSING_REQUEST_TYPE);
        }
        APIServlet.APIRequestHandler aPIRequestHandler = APIServlet.apiRequestHandlers.get(string);
        if (aPIRequestHandler == null) {
            if (APIServlet.disabledRequestHandlers.containsKey(string)) {
                throw new ParameterException(JSONResponses.ERROR_DISABLED);
            }
            throw new ParameterException(JSONResponses.ERROR_INCORRECT_REQUEST);
        }
        return string;
    }

    private boolean initRemoteRequest(HttpServletRequest httpServletRequest, String string) {
        Object object;
        StringBuilder stringBuilder;
        if (!APIProxy.forcedServerURL.isEmpty()) {
            stringBuilder = new StringBuilder();
            stringBuilder.append(APIProxy.forcedServerURL);
        } else {
            object = APIProxy.getInstance().getServingPeer(string);
            if (object == null) {
                return false;
            }
            stringBuilder = object.getPeerApiUri();
            httpServletRequest.setAttribute(REMOTE_SERVER_IDLE_TIMEOUT, (Object)object.getApiServerIdleTimeout());
        }
        stringBuilder.append("/nxt");
        object = httpServletRequest.getQueryString();
        if (object != null) {
            stringBuilder.append("?").append((String)object);
        }
        httpServletRequest.setAttribute(REMOTE_URL, (Object)stringBuilder.toString());
        return true;
    }

    private boolean isForwardable(String string) {
        APIServlet.APIRequestHandler aPIRequestHandler = APIServlet.apiRequestHandlers.get(string);
        if (!aPIRequestHandler.requireBlockchain()) {
            return false;
        }
        if (aPIRequestHandler.requireFullClient()) {
            return false;
        }
        return !APIProxy.NOT_FORWARDED_REQUESTS.contains(string);
    }

    protected Response.Listener newProxyResponseListener(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return new APIProxyResponseListener(httpServletRequest, httpServletResponse);
    }

    protected AsyncMiddleManServlet.ContentTransformer newClientRequestContentTransformer(HttpServletRequest httpServletRequest, Request request) {
        String string = httpServletRequest.getContentType();
        if (string != null && string.contains("multipart")) {
            return super.newClientRequestContentTransformer(httpServletRequest, request);
        }
        if (APIProxy.isActivated() && this.isForwardable(httpServletRequest.getParameter("requestType"))) {
            return new PasswordFilteringContentTransformer();
        }
        return super.newClientRequestContentTransformer(httpServletRequest, request);
    }

    private static class PasswordFilteringContentTransformer
    implements AsyncMiddleManServlet.ContentTransformer {
        private ByteArrayOutputStream os;

        private PasswordFilteringContentTransformer() {
        }

        public void transform(ByteBuffer byteBuffer, boolean bl, List<ByteBuffer> list) throws IOException {
            if (bl) {
                ByteBuffer byteBuffer2;
                if (this.os == null) {
                    byteBuffer2 = byteBuffer;
                } else {
                    byte[] byArray = new byte[byteBuffer.remaining()];
                    byteBuffer.get(byArray);
                    this.os.write(byArray);
                    byteBuffer2 = ByteBuffer.wrap(this.os.toByteArray());
                }
                int n = PasswordFinder.process(byteBuffer2, new String[]{"secretPhrase=", "adminPassword=", "sharedKey=", "sharedPiece="});
                if (n >= 0) {
                    JSONStreamAware jSONStreamAware = JSONResponses.PROXY_SECRET_DATA_DETECTED;
                    throw new PasswordDetectedException(jSONStreamAware);
                }
                list.add(byteBuffer2);
            } else {
                if (this.os == null) {
                    this.os = new ByteArrayOutputStream();
                }
                byte[] byArray = new byte[byteBuffer.remaining()];
                byteBuffer.get(byArray);
                this.os.write(byArray);
            }
        }
    }

    static class PasswordFinder {
        PasswordFinder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static int process(ByteBuffer byteBuffer, String[] stringArray) {
            try {
                int n;
                int[] nArray = new int[stringArray.length];
                byte[][] byArrayArray = new byte[stringArray.length][];
                for (n = 0; n < byArrayArray.length; ++n) {
                    byArrayArray[n] = stringArray[n].getBytes();
                }
                while (byteBuffer.hasRemaining()) {
                    n = byteBuffer.get();
                    for (int i = 0; i < byArrayArray.length; ++i) {
                        if (n != byArrayArray[i][nArray[i]]) {
                            nArray[i] = 0;
                            continue;
                        }
                        int n2 = i;
                        nArray[n2] = nArray[n2] + 1;
                        if (nArray[i] != byArrayArray[i].length) continue;
                        int n3 = byteBuffer.position() - byArrayArray[i].length;
                        return n3;
                    }
                }
                n = -1;
                return n;
            }
            finally {
                byteBuffer.rewind();
            }
        }
    }

    private static class PasswordDetectedException
    extends RuntimeException {
        private final JSONStreamAware errorResponse;

        private PasswordDetectedException(JSONStreamAware jSONStreamAware) {
            this.errorResponse = jSONStreamAware;
        }
    }

    private class APIProxyResponseListener
    extends AsyncMiddleManServlet.ProxyResponseListener {
        APIProxyResponseListener(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
            super((AsyncMiddleManServlet)APIProxyServlet.this, httpServletRequest, httpServletResponse);
        }

        public void onFailure(Response response, Throwable throwable) {
            super.onFailure(response, throwable);
            Logger.logErrorMessage("proxy failed", throwable);
            APIProxy.getInstance().blacklistHost(response.getRequest().getHost());
        }
    }
}

