/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.account.Account;
import nxt.blockchain.Bundler;
import nxt.blockchain.ChildChain;
import nxt.blockchain.FxtChain;
import nxt.crypto.Crypto;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.peer.Peers;
import nxt.util.Convert;
import org.json.simple.JSONStreamAware;

public final class AddBundlingRule
extends APIServlet.APIRequestHandler {
    static final AddBundlingRule instance = new AddBundlingRule();

    private AddBundlingRule() {
        super(new APITag[]{APITag.FORGING}, "secretPhrase", "minRateNQTPerFXT", "totalFeesLimitFQT", "overpayFQTPerFXT", "feeCalculatorName", "filter", "filter", "filter");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        String string = ParameterParser.getSecretPhrase(httpServletRequest, true);
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest);
        long l = ParameterParser.getLong(httpServletRequest, "totalFeesLimitFQT", 0L, 100000000000000000L, false);
        long l2 = ParameterParser.getLong(httpServletRequest, "minRateNQTPerFXT", 0L, 100000000000000000L, true);
        long l3 = ParameterParser.getLong(httpServletRequest, "overpayFQTPerFXT", 0L, 100000000000000000L, false);
        String string2 = httpServletRequest.getParameter("feeCalculatorName");
        List<Bundler.Filter> list = ParameterParser.getBundlingFilters(httpServletRequest);
        Bundler.Rule rule = Bundler.createBundlingRule(l2, l3, string2, list);
        long l4 = Account.getId(Crypto.getPublicKey(string));
        if (l > FxtChain.FXT.getBalanceHome().getBalance(l4).getUnconfirmedBalance()) {
            return JSONResponses.NOT_ENOUGH_FUNDS;
        }
        Account account = Account.getAccount(l4);
        if (account != null && account.getControls().contains((Object)Account.ControlType.PHASING_ONLY)) {
            return JSONResponses.error("Accounts under phasing only control cannot run a bundler");
        }
        Bundler bundler = Bundler.addBundlingRule(childChain, string, rule);
        if (bundler == null) {
            return JSONResponses.error("Missing bundler for chain " + childChain.getName() + " and account " + Convert.rsAccount(l4));
        }
        Peers.broadcastBundlerRates();
        return JSONData.bundler(bundler);
    }

    @Override
    protected boolean requirePost() {
        return true;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean requireFullClient() {
        return true;
    }
}

