/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.NxtException;
import nxt.blockchain.Transaction;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import nxt.util.Logger;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class BroadcastTransaction
extends APIServlet.APIRequestHandler {
    static final BroadcastTransaction instance = new BroadcastTransaction();

    private BroadcastTransaction() {
        super(new APITag[]{APITag.TRANSACTIONS}, "transactionJSON", "transactionBytes", "prunableAttachmentJSON");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        String string = Convert.emptyToNull(httpServletRequest.getParameter("transactionJSON"));
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter("transactionBytes"));
        String string3 = Convert.emptyToNull(httpServletRequest.getParameter("prunableAttachmentJSON"));
        JSONObject jSONObject = new JSONObject();
        try {
            Transaction.Builder builder = ParameterParser.parseTransaction(string, string2, string3);
            Transaction transaction = builder.build();
            Nxt.getTransactionProcessor().broadcast(transaction);
            jSONObject.put((Object)"fullHash", (Object)Convert.toHexString(transaction.getFullHash()));
        }
        catch (RuntimeException | NxtException.ValidationException exception) {
            if (exception instanceof RuntimeException) {
                Logger.logDebugMessage("Request processing failed", exception);
            }
            JSONData.putException(jSONObject, exception, "Failed to broadcast transaction");
        }
        return jSONObject;
    }

    @Override
    protected boolean requirePost() {
        return true;
    }

    @Override
    protected final boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }
}

