/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.NxtException;
import nxt.account.Account;
import nxt.blockchain.ChildBlockAttachment;
import nxt.blockchain.ChildTransaction;
import nxt.blockchain.UnconfirmedTransaction;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONStreamAware;

public final class BundleTransactions
extends CreateTransaction {
    static final BundleTransactions instance = new BundleTransactions();

    private BundleTransactions() {
        super(new APITag[]{APITag.FORGING, APITag.CREATE_TRANSACTION}, "transactionFullHash", "transactionFullHash", "transactionFullHash");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        ArrayList<ChildTransaction> arrayList = new ArrayList<ChildTransaction>();
        String[] stringArray = httpServletRequest.getParameterValues("transactionFullHash");
        if (stringArray == null || stringArray.length == 0) {
            return JSONResponses.missing("transactionFullHash");
        }
        for (String string : stringArray) {
            byte[] byArray = Convert.parseHexString(string);
            UnconfirmedTransaction unconfirmedTransaction = Nxt.getTransactionProcessor().getUnconfirmedTransaction(Convert.fullHashToId(byArray));
            if (unconfirmedTransaction == null || !Arrays.equals(byArray, unconfirmedTransaction.getFullHash())) {
                return JSONResponses.UNKNOWN_TRANSACTION_FULL_HASH;
            }
            if (!(unconfirmedTransaction.getTransaction() instanceof ChildTransaction)) {
                return JSONResponses.INCORRECT_TRANSACTION;
            }
            arrayList.add((ChildTransaction)((Object)unconfirmedTransaction.getTransaction()));
        }
        ChildBlockAttachment childBlockAttachment = new ChildBlockAttachment(arrayList);
        return this.createTransaction(httpServletRequest, account, childBlockAttachment);
    }
}

