/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.account.Account;
import nxt.aliases.AliasBuyAttachment;
import nxt.aliases.AliasHome;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import org.json.simple.JSONStreamAware;

public final class BuyAlias
extends CreateTransaction {
    static final BuyAlias instance = new BuyAlias();

    private BuyAlias() {
        super(new APITag[]{APITag.ALIASES, APITag.CREATE_TRANSACTION}, "alias", "aliasName", "amountNQT");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        AliasHome.Alias alias = ParameterParser.getAlias(httpServletRequest);
        long l = ParameterParser.getAmountNQT(httpServletRequest);
        if (alias.getOffer() == null) {
            return JSONResponses.INCORRECT_ALIAS_NOTFORSALE;
        }
        long l2 = alias.getAccountId();
        AliasBuyAttachment aliasBuyAttachment = new AliasBuyAttachment(alias.getAliasName());
        return this.transactionParameters(httpServletRequest, account, aliasBuyAttachment).setAmountNQT(l).setRecipientId(l2).createTransaction();
    }

    @Override
    String getDocsUrlPath() {
        return "Aliases#Buy_.2F_Sell_Alias";
    }
}

