/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.account.Token;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import org.json.simple.JSONStreamAware;

public final class DecodeFileToken
extends APIServlet.APIRequestHandler {
    static final DecodeFileToken instance = new DecodeFileToken();

    private DecodeFileToken() {
        super("file", new APITag[]{APITag.TOKENS}, "token");
    }

    @Override
    public JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        String string = httpServletRequest.getParameter("token");
        if (string == null) {
            return JSONResponses.MISSING_TOKEN;
        }
        ParameterParser.FileData fileData = ParameterParser.getFileData(httpServletRequest, "file", true);
        if (fileData == null) {
            return JSONResponses.INCORRECT_FILE;
        }
        byte[] byArray = fileData.getData();
        try {
            Token token = Token.parseToken(string, byArray);
            return JSONData.token(token);
        }
        catch (RuntimeException runtimeException) {
            return JSONResponses.INCORRECT_TOKEN;
        }
    }

    @Override
    protected boolean requirePost() {
        return true;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }
}

