/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.account.Account;
import nxt.crypto.EncryptedData;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import nxt.util.Logger;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class DecryptFrom
extends APIServlet.APIRequestHandler {
    static final DecryptFrom instance = new DecryptFrom();

    private DecryptFrom() {
        super(new APITag[]{APITag.MESSAGES}, "account", "data", "nonce", "decryptedMessageIsText", "uncompressDecryptedMessage", "secretPhrase");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        byte[] byArray = Account.getPublicKey(ParameterParser.getAccountId(httpServletRequest, true));
        if (byArray == null) {
            return JSONResponses.INCORRECT_ACCOUNT;
        }
        String string = ParameterParser.getSecretPhrase(httpServletRequest, true);
        byte[] byArray2 = Convert.parseHexString(Convert.nullToEmpty(httpServletRequest.getParameter("data")));
        byte[] byArray3 = Convert.parseHexString(Convert.nullToEmpty(httpServletRequest.getParameter("nonce")));
        EncryptedData encryptedData = new EncryptedData(byArray2, byArray3);
        boolean bl = !"false".equalsIgnoreCase(httpServletRequest.getParameter("decryptedMessageIsText"));
        boolean bl2 = !"false".equalsIgnoreCase(httpServletRequest.getParameter("uncompressDecryptedMessage"));
        try {
            byte[] byArray4 = Account.decryptFrom(byArray, encryptedData, string, bl2);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"decryptedMessage", (Object)(bl ? Convert.toString(byArray4) : Convert.toHexString(byArray4)));
            return jSONObject;
        }
        catch (RuntimeException runtimeException) {
            Logger.logDebugMessage(runtimeException.toString());
            return JSONResponses.DECRYPTION_FAILED;
        }
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }
}

