/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nxt.Nxt;
import nxt.NxtException;
import nxt.blockchain.ChildChain;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.taggeddata.TaggedDataHome;
import org.json.simple.JSONStreamAware;

public final class DownloadTaggedData
extends APIServlet.APIRequestHandler {
    static final DownloadTaggedData instance = new DownloadTaggedData();

    private DownloadTaggedData() {
        super(new APITag[]{APITag.DATA}, "transactionFullHash", "retrieve");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws NxtException {
        URI uRI;
        byte[] byArray = ParameterParser.getBytes(httpServletRequest, "transactionFullHash", true);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("retrieve"));
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest);
        TaggedDataHome taggedDataHome = childChain.getTaggedDataHome();
        TaggedDataHome.TaggedData taggedData = taggedDataHome.getData(byArray);
        if (taggedData == null && bl) {
            if (Nxt.getBlockchainProcessor().restorePrunedTransaction(childChain, byArray) == null) {
                return JSONResponses.PRUNED_TRANSACTION;
            }
            taggedData = taggedDataHome.getData(byArray);
        }
        if (taggedData == null) {
            return JSONResponses.incorrect("transaction", "Tagged data not found");
        }
        byte[] byArray2 = taggedData.getData();
        if (!taggedData.getType().equals("")) {
            httpServletResponse.setContentType(taggedData.getType());
        } else {
            httpServletResponse.setContentType("application/octet-stream");
        }
        String string = taggedData.getFilename();
        if (string == null || string.trim().isEmpty()) {
            string = taggedData.getName().trim();
        }
        String string2 = "attachment";
        try {
            uRI = new URI(null, null, string, null);
            string2 = string2 + "; filename*=UTF-8''" + uRI.toASCIIString();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        httpServletResponse.setHeader("Content-Disposition", string2);
        httpServletResponse.setContentLength(byArray2.length);
        try {
            uRI = httpServletResponse.getOutputStream();
            Throwable throwable = null;
            try {
                try {
                    ((OutputStream)((Object)uRI)).write(byArray2);
                }
                catch (IOException iOException) {
                    throw new ParameterException(JSONResponses.RESPONSE_WRITE_ERROR);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (uRI != null) {
                    if (throwable != null) {
                        try {
                            ((OutputStream)((Object)uRI)).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((OutputStream)((Object)uRI)).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new ParameterException(JSONResponses.RESPONSE_STREAM_ERROR);
        }
        return null;
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
        throw new UnsupportedOperationException();
    }
}

