/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.blockchain.Chain;
import nxt.db.DbIterator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterParser;
import nxt.messaging.PrunableMessageHome;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetAllPrunableMessages
extends APIServlet.APIRequestHandler {
    static final GetAllPrunableMessages instance = new GetAllPrunableMessages();

    private GetAllPrunableMessages() {
        super(new APITag[]{APITag.MESSAGES}, "firstIndex", "lastIndex", "timestamp");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        int n = ParameterParser.getFirstIndex(httpServletRequest);
        int n2 = ParameterParser.getLastIndex(httpServletRequest);
        int n3 = ParameterParser.getTimestamp(httpServletRequest);
        Chain chain = ParameterParser.getChain(httpServletRequest);
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        jSONObject.put((Object)"prunableMessages", (Object)jSONArray);
        try (DbIterator<PrunableMessageHome.PrunableMessage> dbIterator = chain.getPrunableMessageHome().getAll(n, n2);){
            while (dbIterator.hasNext()) {
                PrunableMessageHome.PrunableMessage prunableMessage = dbIterator.next();
                if (prunableMessage.getBlockTimestamp() < n3) {
                    break;
                }
                jSONArray.add((Object)JSONData.prunableMessage(prunableMessage, null, null));
            }
        }
        return jSONObject;
    }
}

